/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.changebill;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.dao.factory.AssetPolicyDaoFactory;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;

public class OriginalvalChangeHandle
extends FaBillBaseFormPlugin {
    Map<String, String> longNumberMapCache = new HashMap<String, String>();
    Map<String, String> bookIdAndassetPolicyIdCache = new HashMap<String, String>();
    Map<String, DynamicObjectCollection> depresystemCache = new HashMap<String, DynamicObjectCollection>();

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("m_aft_originalval".equalsIgnoreCase(property) || "o_aft_originalval".equalsIgnoreCase(property)) {
            this.predualvalPropertyChanged(e.getChangeSet()[0]);
        }
    }

    private void predualvalPropertyChanged(ChangeData changeData) {
        BigDecimal netResidualValRate;
        DynamicObject assetBookDO;
        String cardNumber;
        IDataModel model = this.getModel();
        if (changeData == null) {
            return;
        }
        String entityName = changeData.getDataEntity().getDynamicObjectType().getName();
        int curIndex = changeData.getRowIndex();
        BigDecimal originalValue = (BigDecimal)changeData.getNewValue();
        String finCardKey = entityName.equals("main_changebillentry") ? "m_fincard" : "o_fincard";
        String realCardKey = entityName.equals("main_changebillentry") ? "m_realcard" : "o_realcard";
        String preresidualKey = entityName.equals("main_changebillentry") ? "m_aft_preresidualval" : "o_aft_preresidualval";
        DynamicObject curfinDy = ((DynamicObject)model.getEntryEntity(entityName).get(curIndex)).getDynamicObject(finCardKey);
        DynamicObject curRealDy = ((DynamicObject)model.getEntryEntity(entityName).get(curIndex)).getDynamicObject(realCardKey);
        String string = cardNumber = curRealDy == null ? "" : curRealDy.getString("number");
        if (curfinDy == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a[%s]\u7684\u8d22\u52a1\u5361\u7247\u5df2\u7ecf\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5361\u7247\u3002", (String)"OriginalvalChangeHandle_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), cardNumber));
        }
        if (this.longNumberMapCache.size() == 0) {
            DataSet assetCatDs = QueryServiceHelper.queryDataSet((String)"OriginalvalChangeHandle", (String)"fa_assetcategory", (String)"id,longnumber", null, null);
            for (Row row : assetCatDs) {
                this.longNumberMapCache.put(String.valueOf(row.get("id")), (String)row.get("longnumber"));
            }
        }
        if (this.bookIdAndassetPolicyIdCache.get(String.valueOf((assetBookDO = curfinDy.getDynamicObject("assetbook")).getPkValue())) == null) {
            DynamicObject assetBookFromDB = BusinessDataServiceHelper.loadSingle((Object)assetBookDO.getPkValue(), (String)"fa_assetbook", (String)"id,depresystem");
            String depresystemId = String.valueOf(assetBookFromDB.getLong("depresystem.id"));
            this.bookIdAndassetPolicyIdCache.put(String.valueOf(assetBookDO.getPkValue()), depresystemId);
            DynamicObjectCollection assetPolicEntry = AssetPolicyDaoFactory.getInstance().queryOne((Object)assetBookFromDB.getLong("depresystem.id")).getDynamicObjectCollection("assetpolicy_entry");
            this.depresystemCache.put(depresystemId, assetPolicEntry);
        }
        if ((netResidualValRate = FinCardCalc.getNetResidualValRate((DynamicObject)curfinDy, this.longNumberMapCache, this.bookIdAndassetPolicyIdCache, this.depresystemCache)) != null && null != originalValue) {
            BigDecimal netResidualVal = originalValue.multiply(netResidualValRate).divide(new BigDecimal(100), 4);
            DynamicObject baseCurrency = curfinDy.getDynamicObject("basecurrency");
            netResidualVal = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrency, (BigDecimal)netResidualVal);
            model.setValue(preresidualKey, (Object)netResidualVal, curIndex);
        }
    }
}

