/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.dataasset;

import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dataasset.DetailStatusEnum;
import kd.fi.fa.business.utils.FaMutexRequireUtil;
import kd.fi.fa.common.util.DateUtil;

public class DataAssetDetailBaseListPlugin
extends AbstractListPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object actionId = formShowParameter.getCustomParams().get("actionId");
        if (actionId != null && !"tb_disable".equals(actionId.toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"batchdisable"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("disable".equals(operateKey)) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            Set selectIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object dataAssetId = formShowParameter.getCustomParams().get("dataAssetId");
            QFilter fidFilter = new QFilter("dataasset", "=", dataAssetId);
            QFilter statusFilter = new QFilter("detailstatus", "=", (Object)DetailStatusEnum.ENABLE.getValue());
            List enableIds = QueryServiceHelper.queryPrimaryKeys((String)"fa_dataassetdetail_base", (QFilter[])new QFilter[]{fidFilter, statusFilter}, null, (int)-1);
            if (selectedRows.size() > 0 && selectIds.containsAll(enableIds)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6548\u7684\u6570\u636e\u660e\u7ec6\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"DataAssetDetailBaseListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            op.getOption().setVariableValue("dataAssetId", String.valueOf(dataAssetId));
            Object lastModifyTime = formShowParameter.getCustomParams().get("lastModifyTime");
            if (lastModifyTime != null) {
                try {
                    Date date = DateUtil.parseDate((String)String.valueOf(lastModifyTime), (String)"yyyy-MM-dd HH:mm:ss", (boolean)true);
                    op.getOption().setVariableValue("lastModifyTime", DateUtil.getLongDate().format(date));
                }
                catch (ParseException e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object dataAssetId;
        super.beforeClosed(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object actionId = formShowParameter.getCustomParams().get("actionId");
        if (actionId != null && "tb_disable".equals(actionId.toString())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u6570\u636e\u8d44\u4ea7\u83b7\u53d6\u6700\u65b0\u6570\u636e\u3002", (String)"DataAssetDetailBaseListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, null);
        }
        if ((dataAssetId = formShowParameter.getCustomParams().get("dataAssetId")) != null) {
            FaMutexRequireUtil.releaseMutex(dataAssetId, (String)"fa_dataasset_card", (String)"detailmodify");
        }
    }
}

