/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.dataasset;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.dataasset.DataAssetUtil;
import kd.fi.fa.business.dataasset.DetailStatusEnum;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.ThrowableHelper;

public class DataAssetDetailPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DataAssetDetailPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btnokdisable", "viewlist"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long dataAssetId = Long.valueOf(String.valueOf(formShowParameter.getCustomParams().get("dataAssetId")));
        String operationKey = String.valueOf(formShowParameter.getCustomParams().get("operationKey"));
        if ("tb_modify".equals(operationKey)) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u8d44\u4ea7\u660e\u7ec6\u65b0\u589e", (String)"DataAssetDetailPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnokdisable", "disablelabel"});
        } else {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u8d44\u4ea7\u660e\u7ec6\u5931\u6548", (String)"DataAssetDetailPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok", "tb_new", "tb_del", "modifylabel"});
            DataAssetUtil.fillEntry((Object)dataAssetId, (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (IFormView)this.getView(), (String)"entryentity", (int)100);
        }
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Set idSet = entryEntity.stream().map(dynamicObject -> dynamicObject.get("id")).collect(Collectors.toSet());
        this.getPageCache().put("oldIdSet", SerializationUtils.toJsonString(idSet));
        Long scaleUnit = Long.valueOf(String.valueOf(formShowParameter.getCustomParams().get("scaleUnit")));
        this.getModel().setValue("detailunit", (Object)scaleUnit);
        this.getView().updateView("fieldsetpanelap");
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("deleteentry".equals(key)) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            StringBuilder oldRowIndexSb = new StringBuilder(16);
            for (int rowIndex : selectRows) {
                DynamicObject row = (DynamicObject)collection.get(rowIndex);
                if (row.getLong("id") == 0L) continue;
                oldRowIndexSb.append(rowIndex + 1).append(",");
            }
            if (oldRowIndexSb.length() > 0) {
                args.setCancel(true);
                String message = String.format(ResManager.loadKDString((String)"\u7b2c\u3010%s\u3011\u884c\u6570\u636e\u660e\u7ec6\u662f\u5386\u53f2\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DataAssetDetailPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), oldRowIndexSb.substring(0, oldRowIndexSb.length() - 1));
                this.getView().showErrorNotification(message);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object dataAssetId = formShowParameter.getCustomParams().get("dataAssetId");
        Date lastModifyTime = null;
        try {
            lastModifyTime = DateUtil.parseDate((String)String.valueOf(formShowParameter.getCustomParams().get("lastModifyTime")), (String)"yyyy-MM-dd HH:mm:ss", (boolean)true);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Control ctlSource = (Control)evt.getSource();
        String itemKey = ctlSource.getKey();
        if ("btnokdisable".equals(itemKey)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5931\u6548\u7684\u6570\u636e\u660e\u7ec6\u3002", (String)"DataAssetDetailPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
                return;
            }
            boolean haveEnableRow = this.checkEnableRow(collection, selectRows);
            if (!haveEnableRow) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6548\u7684\u6570\u636e\u660e\u7ec6\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"DataAssetDetailPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.confirmDisable(dataAssetId, lastModifyTime, collection, selectRows);
        } else if ("viewlist".equals(itemKey)) {
            HashMap<String, Boolean> ret = new HashMap<String, Boolean>(1);
            ret.put("viewlist", Boolean.TRUE);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(ret));
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirmmodify".equals(operateKey)) {
            OperationResult operationResult = args.getOperationResult();
            if (!operationResult.isSuccess()) {
                return;
            }
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (collection.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u660e\u7ec6\u65e0\u53d8\u5316\u3002", (String)"DataAssetDetailPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object dataAssetId = formShowParameter.getCustomParams().get("dataAssetId");
            List<String> detailMdfTimeMsgList = this.checkDetailMdfTime(collection, dataAssetId);
            if (detailMdfTimeMsgList.size() > 0) {
                FormShowParameter showParameter = this.buildFormShowParameter(detailMdfTimeMsgList);
                this.getView().showForm(showParameter);
                return;
            }
            Date lastModifyTime = null;
            try {
                lastModifyTime = DateUtil.parseDate((String)String.valueOf(formShowParameter.getCustomParams().get("lastModifyTime")), (String)"yyyy-MM-dd HH:mm:ss", (boolean)true);
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
            this.confirmModify(dataAssetId, lastModifyTime, collection);
        }
    }

    private List<String> checkDetailMdfTime(DynamicObjectCollection newRows, Object dataAssetId) {
        DynamicObjectCollection existDetails = QueryServiceHelper.query((String)"fa_dataassetdetail_base", (String)"detailmdftime", (QFilter[])new QFilter[]{new QFilter("dataasset", "=", dataAssetId)});
        HashSet<Long> existMdfTimes = new HashSet<Long>(existDetails.size());
        for (DynamicObject existDetail : existDetails) {
            existMdfTimes.add(existDetail.getDate("detailmdftime").getTime());
        }
        HashMap<Long, Set> detailMdfTimeMap = new HashMap<Long, Set>(newRows.size());
        for (int i = 0; i < newRows.size(); ++i) {
            long detailMdfTime = ((DynamicObject)newRows.get(i)).getDate("detailmdftime").getTime();
            detailMdfTimeMap.computeIfAbsent(detailMdfTime, k -> new HashSet(16)).add(i + 1 + "");
        }
        ArrayList<String> detailMdfTimeMsgList = new ArrayList<String>(detailMdfTimeMap.size());
        for (Map.Entry entry : detailMdfTimeMap.entrySet()) {
            Set indexSet = (Set)entry.getValue();
            if (indexSet.size() > 1) {
                detailMdfTimeMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u7684\u751f\u6548\u65f6\u95f4\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"DataAssetDetailPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", indexSet)));
            }
            if (!existMdfTimes.contains(entry.getKey())) continue;
            detailMdfTimeMsgList.add(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u7684\u751f\u6548\u65f6\u95f4\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"DataAssetDetailPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", indexSet)));
        }
        return detailMdfTimeMsgList;
    }

    private FormShowParameter buildFormShowParameter(List<String> messages) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("errorMsg", messages);
        customParams.put("title", ResManager.loadKDString((String)"\u51711\u6761\u5355\u636e\uff0c\u786e\u8ba4\u4fee\u6539\u6210\u529f0\u6761\uff0c\u5931\u8d251\u6761", (String)"DataAssetDetailPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setShowTitle(false);
        return parameter;
    }

    private void confirmModify(Object dataAssetId, Date lastModifyTime, DynamicObjectCollection collection) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DBRoute fa = DBRoute.of((String)"fa");
                List<DynamicObject> dataAssetDetails = this.buildDataAssetDetail(collection, dataAssetId);
                OperationResult saveOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"fa_dataassetdetail_base", (DynamicObject[])dataAssetDetails.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!saveOpResult.isSuccess()) {
                    logger.error("ConfirmModify save detail failed !DataAssetId : {},Error : {}", dataAssetId, (Object)saveOpResult.getMessage());
                    StringBuilder stringBuilder = new StringBuilder();
                    List allInfo = saveOpResult.getAllErrorOrValidateInfo();
                    for (IOperateInfo info : allInfo) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append("\r\n");
                        }
                        stringBuilder.append(info.getMessage());
                    }
                    throw new KDBizException(stringBuilder.toString());
                }
                boolean updateSuccess = DataAssetUtil.updateDataAsset((DBRoute)fa, (Object)dataAssetId, (Date)lastModifyTime, null);
                if (!updateSuccess) {
                    logger.error("Update dataAsset failed !LastModifyTime not match.DataAssetId : {}", dataAssetId);
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u8d44\u4ea7\u5df2\u88ab\u66f4\u65b0\uff0c\u4fee\u6539\u5931\u8d25\u3002", (String)"DataAssetDetailPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAssetDetailPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().close();
            }
            catch (Throwable t) {
                logger.error("ConfirmModify failed !DataAssetId : {},Error : {}", dataAssetId, (Object)ThrowableHelper.toString((Throwable)t));
                txHandle.markRollback();
                this.getView().showErrorNotification(ThrowableHelper.toString((Throwable)t));
            }
        }
    }

    private List<DynamicObject> buildDataAssetDetail(DynamicObjectCollection collection, Object dataAssetId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"fa_dataassetdetail_base");
        ArrayList<DynamicObject> detailBaseList = new ArrayList<DynamicObject>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            long detailId = dynamicObject.getLong("id");
            DynamicObject detailBase = (DynamicObject)mainEntityType.createInstance();
            if (detailId != 0L) {
                detailBase.set("id", (Object)detailId);
            }
            detailBase.set("dataasset", dataAssetId);
            detailBase.set("detailname", dynamicObject.get("detailname"));
            detailBase.set("detailqty", dynamicObject.get("detailqty"));
            detailBase.set("detailsupplier", dynamicObject.get("detailsupplier"));
            detailBase.set("detailremark", dynamicObject.get("detailremark"));
            detailBase.set("detailstatus", dynamicObject.get("detailstatus"));
            detailBase.set("detailmodifer", dynamicObject.get("detailmodifer"));
            detailBase.set("detailmdftime", dynamicObject.get("detailmdftime"));
            detailBase.set("detailunit", DataAssetUtil.getBaseDataId((IDataModel)this.getModel(), (String)"detailunit"));
            detailBaseList.add(detailBase);
        }
        return detailBaseList;
    }

    private void confirmDisable(Object dataAssetId, Date lastModifyTime, DynamicObjectCollection collection, int[] selectRows) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                HashSet<Long> toDisableDetailIds = new HashSet<Long>(selectRows.length);
                for (int rowIndex : selectRows) {
                    toDisableDetailIds.add(((DynamicObject)collection.get(rowIndex)).getLong("id"));
                }
                SqlBuilder updateDetailSb = new SqlBuilder();
                updateDetailSb.append("UPDATE t_fa_data_detail SET fstatus=?", new Object[]{DetailStatusEnum.DISABLE.getValue()});
                updateDetailSb.append("WHERE ", new Object[0]);
                updateDetailSb.appendIn("fentryid ", new ArrayList(toDisableDetailIds));
                DBRoute fa = DBRoute.of((String)"fa");
                boolean updateDetailSuccess = DB.execute((DBRoute)fa, (SqlBuilder)updateDetailSb);
                if (!updateDetailSuccess) {
                    String error = String.format("Update dataAssetDetail failed !DataAssetId is %s .", dataAssetId);
                    logger.error(error);
                    throw new KDBizException(error);
                }
                boolean updateSuccess = DataAssetUtil.updateDataAsset((DBRoute)fa, (Object)dataAssetId, (Date)lastModifyTime, null);
                if (!updateSuccess) {
                    String error = String.format("Update dataAsset failed !LastModifyTime not match.DataAssetId is %s .", dataAssetId);
                    logger.error(error);
                    throw new KDBizException(error);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataAssetDetailPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            catch (Throwable t) {
                logger.error("ConfirmDisable failed ! DataAssetId : {}, {}", dataAssetId, (Object)ThrowableHelper.toString((Throwable)t));
                txHandle.markRollback();
                throw new KDBizException(ThrowableHelper.toString((Throwable)t));
            }
            this.getView().close();
        }
    }

    private boolean checkEnableRow(DynamicObjectCollection collection, int[] selectRows) {
        HashSet<Integer> selectRowSet = new HashSet<Integer>(selectRows.length);
        for (int rowIndex : selectRows) {
            selectRowSet.add(rowIndex);
        }
        boolean haveEnableRow = false;
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject row = (DynamicObject)collection.get(i);
            String detailStatus = row.getString("detailstatus");
            if (!DetailStatusEnum.ENABLE.getValue().equals(detailStatus) || selectRowSet.contains(i)) continue;
            haveEnableRow = true;
            break;
        }
        return haveEnableRow;
    }
}

