/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.importhandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.changemode.ChangeModeTypeEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUserUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;
import kd.fi.fa.formplugin.importhandler.ClearBillImportHandler;

public class ClearApplyBillImportHandler {
    private static final Log log = LogFactory.getLog(ClearApplyBillImportHandler.class);
    private static final String ORG = "ORG";
    private static final String ASSERT_UNIT = "ASSERT_UNIT";
    private static final String FA_CHANGE_MODE = "fa_changemode";
    private static final String NAME = "name";
    private static final String FORM_PLUGIN = "fi-fa-formplugin";

    public void dataCheck(BeforeImportDataEventArgs e) {
        JSONObject orgObj;
        String orgName;
        JSONObject sourceData = new JSONObject(e.getSourceData());
        String orgNumber = this.getNumber(sourceData, "org");
        Long orgId = this.checkAndGetOrgId(orgNumber, e, ORG, orgName = (orgObj = sourceData.getJSONObject("org")).getString(NAME));
        if (Objects.isNull(orgId)) {
            return;
        }
        JSONObject assertObj = sourceData.getJSONObject("assetunit");
        String assertName = assertObj.getString(NAME);
        String assertNumber = this.getNumber(sourceData, "assetunit");
        Long assertOrgId = this.checkAndGetOrgId(assertNumber, e, ASSERT_UNIT, assertName);
        if (Objects.isNull(assertOrgId)) {
            return;
        }
        if (!this.validateOrgAndComputeOrg(orgId, assertOrgId, e)) {
            return;
        }
        JSONObject handlerPerson = sourceData.getJSONObject("handler");
        if (Objects.isNull(handlerPerson)) {
            JSONObject jsonObject = new JSONObject();
            DynamicObject userById = FaUserUtils.getUserById((String)String.valueOf(ContextUtil.getUserId()));
            jsonObject.put("number", (Object)userById.getString("number"));
            sourceData.put("handler", (Object)jsonObject);
            handlerPerson = sourceData.getJSONObject("handler");
        }
        if (!this.checkPerson(e, handlerPerson)) {
            return;
        }
        JSONObject changeMode = sourceData.getJSONObject("changemode");
        if (!this.validChangeMode(e, changeMode, orgNumber)) {
            return;
        }
        DynamicObject assetBooks = FaUtils.getMainBookByOrg((Long)orgId);
        if (Objects.isNull(assetBooks)) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u5bf9\u5e94\u4e3b\u8d26\u7c3f\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ClearApplyBillImportHandler_0", (String)FORM_PLUGIN, (Object[])new Object[0]), orgNumber));
            return;
        }
        Long currentPeriodId = assetBooks.getLong("curperiod");
        Date clearDate = this.noteDate(e, sourceData);
        DynamicObject mainBookPeriod = this.getMainBookPeriod(currentPeriodId);
        if (Objects.isNull(mainBookPeriod)) {
            this.setErrorMessage((ImportDataEventArgs)e, ResManager.loadKDString((String)"\u8d26\u7c3f\u5bf9\u5e94\u7684\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ClearApplyBillImportHandler_1", (String)FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Date beginDate = mainBookPeriod.getDate("begindate");
        Date endDate = mainBookPeriod.getDate("enddate");
        if (DateUtil.compareShortDate((Date)clearDate, (Date)beginDate) < 0) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u201c%s\u201d\u4e0d\u80fd\u65e9\u4e8e\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"ClearApplyBillImportHandler_2", (String)FORM_PLUGIN, (Object[])new Object[0]), sourceData.getString("cleardate")));
            return;
        }
        this.validCard(sourceData, e, clearDate, endDate, orgId, currentPeriodId);
    }

    private String getNumber(JSONObject sourceData, String prop) {
        if (!sourceData.containsKey((Object)prop)) {
            return "";
        }
        return sourceData.getJSONObject(prop).getString("number");
    }

    private boolean checkPerson(BeforeImportDataEventArgs e, JSONObject handlerPerson) {
        String resultMapFields;
        DynamicObject user;
        String number = handlerPerson.getString("number");
        Object[] qFilters = new QFilter[]{};
        if (StringUtils.isNotBlank((CharSequence)number)) {
            ArrayUtils.add((Object[])qFilters, (Object)new QFilter("number", "=", (Object)number));
        }
        if (Objects.isNull(user = QueryServiceHelper.queryOne((String)"bos_user", (String)(resultMapFields = new StringJoiner(",").add("number").add("phone").toString()), (QFilter[])qFilters))) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u201c%s\u201d\u4e0d\u5c5e\u4e8e\u7ec4\u7ec7\u4eba\u5458\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_3", (String)FORM_PLUGIN, (Object[])new Object[0]), number));
            return false;
        }
        return true;
    }

    private boolean validChangeMode(BeforeImportDataEventArgs e, JSONObject obj, String orgNumber) {
        String number = obj.getString("number");
        String name = obj.getString(NAME);
        QFilter enableQ = new QFilter("enable", "=", (Object)"1");
        QFilter isLeafQ = new QFilter("isleaf", "=", (Object)"1");
        QFilter statusQ = new QFilter("status", "=", (Object)"C");
        QFilter typeQ = new QFilter("type", "=", (Object)ChangeModeTypeEnum.REDUCE.name());
        QFilter numberQ = new QFilter("number", "=", (Object)number);
        String resultMapFields = new StringJoiner(",").add("id").add(NAME).toString();
        DynamicObject changeMode = QueryServiceHelper.queryOne((String)FA_CHANGE_MODE, (String)resultMapFields, (QFilter[])new QFilter[]{enableQ, statusQ, numberQ, isLeafQ, typeQ});
        if (Objects.isNull(changeMode)) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u51cf\u5c11\u65b9\u5f0f\u975e\u53f6\u5b50\u8282\u70b9\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_4", (String)FORM_PLUGIN, (Object[])new Object[0]), orgNumber));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)name) && !name.equals(changeMode.get(NAME))) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u51cf\u5c11\u65b9\u5f0f\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ClearApplyBillImportHandler_5", (String)FORM_PLUGIN, (Object[])new Object[0]), orgNumber));
            return false;
        }
        return true;
    }

    private void validCard(JSONObject sourceData, BeforeImportDataEventArgs e, Date clearDate, Date endDate, Long orgId, Long currentPeriodId) {
        Set hasFutureBizCardIds;
        FutureBizChecker checker;
        Optional futureCheckResult;
        JSONArray clrApplyBillEntryList = sourceData.getJSONArray("clrapplybill_entry");
        if (CollectionUtils.isEmpty((Collection)clrApplyBillEntryList)) {
            return;
        }
        Map<String, DynamicObject> realCardMap = this.importNumberToId(e);
        HashSet<Long> realCardIds = new HashSet<Long>();
        for (Object element : clrApplyBillEntryList) {
            JSONObject clrApplyBillEntryElement = (JSONObject)JSON.toJSON(element);
            JSONObject realCardJson = clrApplyBillEntryElement.getJSONObject("realcard");
            DynamicObject realCard = realCardMap.get(realCardJson.getString("number"));
            Long realCardId = realCard.getLong("id");
            BigDecimal assertAmount = realCard.getBigDecimal("assetamount");
            if (!new ClearBillImportHandler().isNumeric(clrApplyBillEntryElement.get((Object)"clearqty").toString())) {
                this.setErrorMessage((ImportDataEventArgs)e, ResManager.loadKDString((String)"\u6e05\u7406\u6570\u91cf\u4e0d\u4e3a\u6570\u5b57\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_6", (String)FORM_PLUGIN, (Object[])new Object[0]));
            } else {
                BigDecimal clearApplyQty = clrApplyBillEntryElement.getBigDecimal("clearqty");
                if (clearApplyQty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.setErrorMessage((ImportDataEventArgs)e, ResManager.loadKDString((String)"\u6e05\u7406\u6570\u91cf\u4e0d\u5927\u4e8e0\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_7", (String)FORM_PLUGIN, (Object[])new Object[0]));
                } else if (assertAmount.compareTo(clearApplyQty) < 0) {
                    this.setErrorMessage((ImportDataEventArgs)e, ResManager.loadKDString((String)"\u6e05\u7406\u6570\u91cf\u5927\u4e8e\u8d44\u4ea7\u6570\u91cf\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_8", (String)FORM_PLUGIN, (Object[])new Object[0]));
                } else if (!this.checkClearQty(realCard, clearApplyQty)) {
                    this.setErrorMessage((ImportDataEventArgs)e, ResManager.loadKDString((String)"\u201c\u6e05\u7406\u6570\u91cf\u201d\u7684\u5c0f\u6570\u4f4d\u6570\u8d85\u8fc7\u8ba1\u91cf\u5355\u4f4d\u7cbe\u5ea6\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_9", (String)FORM_PLUGIN, (Object[])new Object[0]));
                }
            }
            realCardIds.add(realCardId);
        }
        Set existCards = FaUtils.getCurRealCard((Date)clearDate, (Long)orgId, (Boolean)false, realCardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.REAL_FIN_CHG, null);
        if (!existCards.containsAll(realCardIds)) {
            Collection<DynamicObject> realCardColl = realCardMap.values();
            String orgNumber = this.getNumber(sourceData, "org");
            for (DynamicObject realCard : realCardColl) {
                if (existCards.contains(realCard.getLong("id"))) continue;
                this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u3010%1$s\u3011\u7684\u5165\u8d26\u65e5\u671f\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3010%2$s\u3011\u4e3b\u8d26\u7c3f\u5f53\u524d\u53ca\u4ee5\u524d\u671f\u95f4\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_10", (String)FORM_PLUGIN, (Object[])new Object[0]), realCard.getString("number"), orgNumber));
            }
        }
        if ((futureCheckResult = (checker = new FutureBizChecker(null, (Object)orgId, realCardIds, clearDate, BusyTypeDetailEnum.REAL_FIN_CHG)).check()).isPresent() && !(hasFutureBizCardIds = checker.checkAndReturnRealCard()).isEmpty()) {
            Tuple checkFutureResult = new Tuple(futureCheckResult.get(), (Object)hasFutureBizCardIds);
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff1a%s", (String)"ClearApplyBillImportHandler_11", (String)FORM_PLUGIN, (Object[])new Object[0]), checkFutureResult.item1));
        }
    }

    private Map<String, DynamicObject> importNumberToId(BeforeImportDataEventArgs e) {
        Map sourceDataMap = e.getSourceData();
        JSONObject sourceData = new JSONObject(sourceDataMap);
        String assetUnitNumber = sourceData.getJSONObject("assetunit").getString("number");
        String orgNumber = sourceData.getJSONObject("org").getString("number");
        JSONArray entry = sourceData.getJSONArray("clrapplybill_entry");
        HashSet<String> numberSet = new HashSet<String>(entry.size());
        int index = -1;
        for (Object row : entry) {
            ++index;
            JSONObject jsonObj = new JSONObject((Map)row);
            String realCardNum = jsonObj.getJSONObject("realcard").getString("number");
            if (numberSet.contains(realCardNum)) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u5b58\u5728\u91cd\u590d\uff1a%s\u3002", (String)"ClearApplyBillImportHandler_12", (String)FORM_PLUGIN, (Object[])new Object[0]), realCardNum));
                e.setCancel(true);
                continue;
            }
            numberSet.add(realCardNum);
        }
        HashMap<String, DynamicObject> numAndIdMap = new HashMap<String, DynamicObject>(numberSet.size());
        String selectFields = Fa.comma((String[])new String[]{"id", "number", "assetamount", "realaccountdate", Fa.dot((String[])new String[]{"org", "id"}), Fa.dot((String[])new String[]{"unit", "precision"})});
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numberSet), new QFilter("id", "=", (Object)"masterid", true), new QFilter(Fa.dot((String[])new String[]{"assetunit", "number"}), "=", (Object)assetUnitNumber), new QFilter(Fa.dot((String[])new String[]{"org", "number"}), "=", (Object)orgNumber), new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY.name()), new QFilter("billstatus", "=", (Object)"C")};
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filters);
        for (DynamicObject realCard : realCards) {
            String number = realCard.getString("number");
            numAndIdMap.put(number, realCard);
        }
        for (Object row : entry) {
            JSONObject jsonObj = new JSONObject((Map)row);
            JSONObject realCard = jsonObj.getJSONObject("realcard");
            String realCardNum = realCard.getString("number");
            realCard.put("importprop", (Object)"id");
            DynamicObject realCardValue = (DynamicObject)numAndIdMap.get(realCardNum);
            if (realCardValue == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u3010%s\u3011\u5728\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u5bf9\u5e94\u7684\u5361\u7247\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u5c31\u7eea\u3002", (String)"ClearApplyBillImportHandler_13", (String)FORM_PLUGIN, (Object[])new Object[0]), realCardNum));
            }
            realCard.put("id", (Object)realCardValue.getLong("id"));
        }
        return numAndIdMap;
    }

    private Date noteDate(BeforeImportDataEventArgs e, JSONObject sourceData) {
        Date clearDate = null;
        try {
            String date = sourceData.getString("cleardate");
            if (kd.bos.util.StringUtils.isEmpty((String)date)) {
                return null;
            }
            clearDate = DateUtil.getShortDate().parse(date);
        }
        catch (Exception parse) {
            log.error("==ClearApplyBillImportHandler==error:", (Throwable)parse);
            this.setErrorMessage((ImportDataEventArgs)e, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u7684\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ClearApplyBillImportHandler_14", (String)FORM_PLUGIN, (Object[])new Object[0]));
        }
        return clearDate;
    }

    private Long checkAndGetOrgId(String number, BeforeImportDataEventArgs e, String desc, String name) {
        String orgViewType;
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("status", "=", (Object)BillStatus.C)};
        String resultMapFields = Fa.comma((String[])new String[]{"id", NAME, "number"});
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org", (String)resultMapFields, (QFilter[])filters);
        if (ORG.equals(desc)) {
            desc = ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ClearApplyBillImportHandler_15", (String)FORM_PLUGIN, (Object[])new Object[0]);
            orgViewType = "10";
        } else {
            desc = ResManager.loadKDString((String)"\u8d44\u4ea7\u7ec4\u7ec7", (String)"ClearApplyBillImportHandler_16", (String)FORM_PLUGIN, (Object[])new Object[0]);
            orgViewType = "09";
        }
        if (Objects.isNull(orgInfo)) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"%1$s\uff08\u7f16\u7801\uff1a%2$s\uff09\u4e0d\u5b58\u5728\u3002", (String)"ClearApplyBillImportHandler_17", (String)FORM_PLUGIN, (Object[])new Object[0]), desc, number));
            return null;
        }
        if (name != null && !name.equals(orgInfo.getString(NAME))) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"%1$s\u540d\u79f0\u3010%2$s\u3011\u4e0e%3$s\u7f16\u7801\u3010%4$s\u3011\u4e0d\u7b26\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_18", (String)FORM_PLUGIN, (Object[])new Object[0]), desc, name, desc, number));
            return null;
        }
        Long orgId = orgInfo.getLong("id");
        boolean isLeaf = FaPermissionUtils.checkOrgIsLeaf((Long)orgId, (String)orgViewType);
        if (!isLeaf) {
            this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u4e0d\u662f\u53f6\u5b50\u8282\u70b9\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_19", (String)FORM_PLUGIN, (Object[])new Object[0]), desc, number));
            return null;
        }
        return orgId;
    }

    private void setErrorMessage(ImportDataEventArgs e, String errorMessage) {
        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), errorMessage);
        e.setCancel(true);
    }

    private DynamicObject getMainBookPeriod(Long periodId) {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        if (Objects.nonNull(period)) {
            return period;
        }
        return null;
    }

    private boolean validateOrgAndComputeOrg(Long orgId, Long assetOrgId, BeforeImportDataEventArgs e) {
        if (orgId.compareTo(assetOrgId) != 0) {
            JSONObject sourceData = new JSONObject(e.getSourceData());
            String orgNumber = this.getNumber(sourceData, "org");
            String assertNumber = this.getNumber(sourceData, "assetunit");
            List allToOrg = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)assetOrgId, (String)"10", (boolean)false);
            if (!allToOrg.contains(orgId)) {
                this.setErrorMessage((ImportDataEventArgs)e, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%1$s\u3011\u4e0e\u8d44\u4ea7\u7ec4\u7ec7\u3010%2$s\u3011\u4e0d\u7b26\u6216\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"ClearApplyBillImportHandler_20", (String)FORM_PLUGIN, (Object[])new Object[0]), orgNumber, assertNumber));
                return false;
            }
        }
        return true;
    }

    private boolean checkClearQty(DynamicObject realCard, BigDecimal clearApplyQty) {
        int precision = realCard.getInt(Fa.dot((String[])new String[]{"unit", "precision"}));
        return clearApplyQty.compareTo(clearApplyQty.setScale(precision, 0)) == 0;
    }

    public void setData2Model(IDataModel model) {
        DynamicObjectCollection applyEntryColl = model.getDataEntity().getDynamicObjectCollection("clrapplybill_entry");
        for (DynamicObject applyEntry : applyEntryColl) {
            applyEntry.set("measureunit", (Object)applyEntry.getDynamicObject("realcard").getDynamicObject("unit"));
        }
    }
}

