/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.importhandler;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.bill.BillModel;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.cache.FaImportCardThreadCacheUtil;
import kd.fi.fa.utils.FaF7CostCenterUtils;

public class RealCardImportHandler {
    public void handleImport(BillModel model) {
        this.setDefaultValue(model);
    }

    protected void setDefaultValue(BillModel model) {
        DynamicObject dObj;
        boolean hasSaved;
        DynamicObjectCollection facilityEntry;
        Object headusedept = model.getValue("headusedept");
        long assetcat = (Long)model.getValue("assetcat_id");
        Object assetunit = model.getValue("assetunit");
        if (assetunit != null) {
            boolean isSealfA;
            boolean checkResult;
            DynamicObject orgObject = (DynamicObject)assetunit;
            Object org = model.getValue("org");
            if (headusedept != null && !(checkResult = FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)((DynamicObject)org), (DynamicObject)orgObject, (Long)((DynamicObject)headusedept).getLong("id")))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff1a%s\u4f7f\u7528\u90e8\u95e8\u4e0d\u5728\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u7684\u53ef\u7528\u8303\u56f4\u4e4b\u5185", (String)"RealCardImportHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), model.getValue("number")));
            }
            List fromOrgList = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)orgObject.getLong("id"), (String)"10", (boolean)true);
            if (org != null) {
                DynamicObject orgDy = (DynamicObject)org;
                if (!fromOrgList.contains(orgDy.getLong("id"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5728\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u7684\u53ef\u7528\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"RealCardImportHandler_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), model.getValue("number")));
                }
                Object costCenter = model.getValue("costcentrer");
                if (costCenter != null) {
                    long costCenterId = ((DynamicObject)costCenter).getLong("id");
                    if (!FaF7CostCenterUtils.checkCostCenterHasValidator4Org(orgDy.getLong("id"), costCenterId)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\uff1a%s\u6210\u672c\u4e2d\u5fc3\u4e0d\u5728\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u7684\u53ef\u7528\u8303\u56f4\u4e4b\u5185\u3002", (String)"RealCardImportHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), model.getValue("number")));
                    }
                }
            }
            if (!(isSealfA = FaImportCardThreadCacheUtil.getAsetValidate(assetcat, orgObject.getLong("id")))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u8be5\u8d44\u4ea7\u7c7b\u522b\u3002", (String)"RealCardImportHandler_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            model.setValue("assetcat", (Object)assetcat);
        }
        if ((facilityEntry = model.getEntryEntity("facility_entry")) != null && !facilityEntry.isEmpty()) {
            model.setValue("isfacility", (Object)true);
        }
        if (!(hasSaved = (dObj = model.getDataEntity()).getDataEntityState().getFromDatabase())) {
            model.setValue("billstatus", (Object)BillStatus.A);
            model.setValue("masterid", model.getValue("id"));
            model.setValue("sourceflag", (Object)SourceFlagEnum.IMPORT);
        }
        model.setValue("isimport", (Object)Boolean.TRUE);
        if (model.getValue("justrealcard").equals(Boolean.TRUE)) {
            model.setValue("bizstatus", (Object)BizStatusEnum.READY);
        } else {
            model.setValue("bizstatus", (Object)BizStatusEnum.ADD);
        }
        if (SourceFlagEnum.DATAASSET.name().equals(String.valueOf(model.getValue("sourceflag")))) {
            model.setValue("assetamount", (Object)BigDecimal.ONE);
            model.setValue("isstoraged", (Object)Boolean.TRUE);
        }
    }
}

