/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.init;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.Fa;

public class FaInitGuideFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(v -> {
            ListShowParameter parameter = (ListShowParameter)v.getFormShowParameter();
            List qFilters = parameter.getListFilterParameter().getQFilters();
            String orgFilterStr = this.getPageCache().get("orgFilter");
            if (orgFilterStr != null) {
                String[] splits = orgFilterStr.split(",");
                Set orgIds = Arrays.stream(splits).map(Long::parseLong).collect(Collectors.toSet());
                qFilters.add(new QFilter("id", "in", orgIds));
            } else {
                qFilters.add(new QFilter("id", "<", (Object)0L));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List leafOrgIdsV2 = FaPermissionUtils.getPermissionLeafOrgIdsV2((String)this.getView().getPageId(), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (String)"10");
        if (!leafOrgIdsV2.isEmpty()) {
            Long org = FaPermissionUtils.getDefaultAcctOrg((List)leafOrgIdsV2);
            this.getModel().setValue("org", (Object)org);
            this.getPageCache().put("orgFilter", Fa.join((Collection)leafOrgIdsV2, (String)","));
        } else {
            this.getModel().setValue("org", null);
        }
    }
}

