/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.fi.fa.formplugin.lease.ImportEntityMapping;
import org.xml.sax.SAXException;

public class BatchImportSheetHandler
extends SheetHandler {
    private static final String BOS_IMPORT = "bos-import";
    private String url;
    private MainEntityType mainEntityType;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private ImportLogger logger;
    private Map<Integer, String> nameRow;
    private ImportEntityMapping entityMapping;
    private int dataIndex = 0;
    private int startRowNum = 0;
    private int lastStartRowNum = 0;
    private int startEntryRowNum = 0;
    private boolean errorData = false;
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private JSONObject data;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, Object> option = new HashMap<String, Object>();
    private ImportContext ctx;
    private HeartBeat heartbeat;
    private Map<Integer, Integer> emptyRowsInBillData = new HashMap<Integer, Integer>(8);

    public Map<String, Object> getOption() {
        return this.option;
    }

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    @Deprecated
    public BatchImportSheetHandler(ImportContext ctx, MainEntityType mainEntityType, String url) {
        this.ctx = ctx;
        this.url = url;
        this.mainEntityType = mainEntityType;
        this.dataQueue = ctx.getDataQueue(url);
        this.logger = ctx.getLogger(url);
    }

    public BatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, HeartBeat heartbeat) {
        this(ctx2, mainEntityType2, url2);
        this.heartbeat = heartbeat;
    }

    public BatchImportSheetHandler(ImportContext ctx2, MainEntityType mainEntityType2, String url2, Map<String, Object> option, HeartBeat heartbeat) {
        this(ctx2, mainEntityType2, url2);
        this.option = option;
        this.heartbeat = heartbeat;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (this.heartbeat != null) {
            this.heartbeat.refresh();
        }
        int currRowNum = row.getRowNum();
        this.logger.setRowIndex(currRowNum);
        if (currRowNum == 0) {
            this.logger.setLastRowIndex(this.getRowCount());
            if (row.isEmpty()) {
                return;
            }
            String entityName = row.get(Integer.valueOf(0));
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                entityName = row.get(Integer.valueOf(1));
                this.hasErrorCol = true;
            }
            if (entityName == null || !entityName.contains(" # ") || !this.mainEntityType.getName().equalsIgnoreCase(entityName.split(" # ", -1)[1])) {
                this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowNum));
                this.ctx.setResolveComplete(this.url);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u4e0e\u5355\u636e\u4e0d\u5339\u914d\uff0c\u5bfc\u81f4\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\uff1a%s\u3002", (String)"BatchImportSheetHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), entityName));
            }
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.isNewFormat = !this.nameRow.get(this.hasErrorCol ? 1 : 0).contains(" # ");
            this.ctx.setNewFormat(this.isNewFormat);
        }
        if (currRowNum >= 2) {
            if (this.isNewFormat) {
                this.buildBill(row);
            } else {
                this.buildBillOld(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBill(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 3) {
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow, row.getData(), this.option);
        } else if (currRowNum > 3) {
            try {
                List<String> errMsg;
                if (!this.entityMapping.isSameOne(this.currentRow, row.getData()) ? !this.addNewBillData(row) : this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                if (row.isEmpty()) {
                    Integer emptyRowNum = this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0);
                    this.emptyRowsInBillData.put(this.dataIndex, emptyRowNum + 1);
                }
                if (!(errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject())).isEmpty()) {
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBillOld(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 2) {
            this.nameRow = row.getData();
            this.entityMapping = ImportEntityMapping.create((DynamicObjectType)this.mainEntityType, this.nameRow);
        } else if (currRowNum > 2) {
            try {
                if (!this.entityMapping.isSameOne(this.currentRow, row.getData()) ? !this.addNewBillData(row) : this.ctx.isBatchByEntry() && currRowNum - this.startEntryRowNum >= this.ctx.getBatchEntryRowSize() && !this.addNewEntryBatch(row)) {
                    return;
                }
                List<String> errMsg = this.entityMapping.push(this.currentRow, row, this.data != null ? this.data : new JSONObject());
                if (!errMsg.isEmpty()) {
                    if (!this.errorData) {
                        // empty if block
                    }
                    this.errorData = true;
                    this.logger.log(Integer.valueOf(currRowNum), String.join((CharSequence)"\uff1b", errMsg) + "\uff1b");
                }
            }
            finally {
                this.currentRow = row;
            }
        }
    }

    private boolean addNewBillData(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (this.entityMapping.isEntityEmpty(row.getData())) {
            return false;
        }
        if (this.data != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, (kd.bos.form.plugin.impt.ImportEntityMapping)this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                billData.setEmptyRowNum(this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0).intValue());
                this.addBillData(billData);
            }
            this.errorData = false;
            ++this.dataIndex;
        }
        this.data = new JSONObject();
        this.startRowNum = currRowNum;
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private boolean addNewEntryBatch(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        JSONObject lastData = this.data;
        if (lastData != null) {
            if (this.errorData) {
                this.logger.fail().tick();
            } else {
                ImportBillData billData = new ImportBillData(this.data, this.startEntryRowNum, currRowNum - 1, (kd.bos.form.plugin.impt.ImportEntityMapping)this.entityMapping);
                billData.setDataIndex(this.dataIndex);
                billData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
                this.addBillData(billData);
            }
            this.errorData = false;
        }
        this.data = new JSONObject();
        if (lastData != null) {
            for (Map.Entry fieldItem : lastData.entrySet()) {
                if (fieldItem.getValue() instanceof JSONArray) continue;
                this.data.put((String)fieldItem.getKey(), fieldItem.getValue());
            }
        }
        this.startEntryRowNum = currRowNum;
        return true;
    }

    private void addBillData(ImportBillData billData) {
        try {
            if (!this.dataQueue.offer(billData, 10L, TimeUnit.MINUTES)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
        catch (Throwable e) {
            throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 1000) {
            this.ctx.feedbackProgress(0, this.logger, null);
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        if (this.currentRow != null) {
            ImportBillData lastBillData;
            int currRowNum = this.currentRow.getRowNum();
            if (this.errorData) {
                this.logger.fail().tick();
                lastBillData = new ImportBillData(new JSONObject(), this.startRowNum, currRowNum);
            } else {
                lastBillData = new ImportBillData(this.data, this.startRowNum, currRowNum, (kd.bos.form.plugin.impt.ImportEntityMapping)this.entityMapping);
            }
            lastBillData.setDataIndex(this.dataIndex);
            lastBillData.setStartRowIndex(this.startEntryRowNum - this.startRowNum);
            lastBillData.setEmptyRowNum(this.emptyRowsInBillData.getOrDefault(this.dataIndex, 0).intValue());
            this.addBillData(lastBillData);
        }
        this.ctx.setResolveComplete(this.url);
    }
}

