/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.FaMutexRequireUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaBillImportOrgCheckUtil;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaLeaseInitEditPlugin
extends AbstractFormPlugin {
    private Set<String> orgNums = new HashSet<String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> {
            FaFormPermissionUtil.beforeOrgSelect_newPermissionLeafOrgV2(this.getView(), evt, "fa_lease_init", "10");
            List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            DataSet existsOrgDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (String)"select forgid from t_fa_lease_init group by forgid");
            if (!existsOrgDataSet.isEmpty()) {
                HashSet<Long> orgIds = new HashSet<Long>(16);
                for (Row row : existsOrgDataSet) {
                    orgIds.add(row.getLong("forgid"));
                }
                filters.add(new QFilter("id", "not in", orgIds));
            }
        });
        BasedataEdit period = (BasedataEdit)this.getControl("startperiod");
        period.addBeforeF7SelectListener(evt -> {
            ListShowParameter showPar = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = showPar.getListFilterParameter().getQFilters();
            long periodType = (Long)model.getValue(Fa.id((String)"periodtype"));
            if (periodType != 0L) {
                QFilter typeF = new QFilter("periodtype", "=", (Object)periodType);
                qFilters.add(typeF);
            }
            QFilter adjustFilter = new QFilter("isadjustperiod", "=", (Object)false);
            qFilters.add(adjustFilter);
            Long orgId = (Long)model.getValue(Fa.id((String)"org"));
            if (orgId != 0L) {
                Date sysSwitchDate;
                QFilter[] leaseContractQFilter;
                DynamicObject initLeaseContract;
                QFilter[] assetBookQFilter = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("ismainbook", "=", (Object)true)};
                DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"startperiod", (QFilter[])assetBookQFilter);
                if (assetBook != null) {
                    long startPeriodId = assetBook.getLong("startperiod");
                    qFilters.add(new QFilter("id", ">=", (Object)startPeriodId));
                }
                if ((initLeaseContract = QueryServiceHelper.queryOne((String)"fa_lease_contract_init", (String)"sysswitchdate", (QFilter[])(leaseContractQFilter = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isinitdata", "=", (Object)true)}))) != null && (sysSwitchDate = initLeaseContract.getDate("sysswitchdate")) != null) {
                    QFilter sFilter = new QFilter("begindate", "<=", (Object)sysSwitchDate);
                    qFilters.add(sFilter);
                    QFilter eFilter = new QFilter("enddate", ">=", (Object)sysSwitchDate);
                    qFilters.add(eFilter);
                }
            }
        });
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            List orgIds = FaPermissionUtils.getPermissionLeafOrgIdsV2((String)this.getView().getPageId(), (String)"fa_lease_init", (String)"47156aff000000ac", (String)"10");
            DataSet existsOrgDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (String)"select forgid from t_fa_lease_init group by forgid");
            if (!existsOrgDataSet.isEmpty()) {
                HashSet<Long> existsOrgIds = new HashSet<Long>(16);
                for (Row row : existsOrgDataSet) {
                    existsOrgIds.add(row.getLong("forgid"));
                }
                orgIds.removeAll(existsOrgIds);
            }
            if (!orgIds.contains(orgId)) {
                model.setValue("org", null);
            }
            this.changeOrg();
        } else if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            boolean existsLeaseContract = QueryServiceHelper.exists((String)"fa_lease_contract", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            if (existsLeaseContract) {
                this.setEnable(false);
            } else {
                boolean existsMainAssetBook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("ismainbook", "=", (Object)true)});
                if (existsMainAssetBook) {
                    this.setEnable(false);
                    IFormView view = this.getView();
                    view.setEnable(Boolean.valueOf(true), new String[]{"startperiod"});
                }
            }
        } else {
            this.setEnable(false);
        }
    }

    private void changeOrg() {
        IDataModel model = this.getModel();
        Long orgId = (Long)model.getValue(Fa.id((String)"org"));
        if (orgId == 0L) {
            return;
        }
        if (!this.requireMutexBatch(orgId)) {
            return;
        }
        String field = Fa.comma((String[])new String[]{"depresystem", "basecurrency", "exchangetable", "periodtype", "startperiod"});
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)field, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("ismainbook", "=", (Object)true)});
        if (assetBook != null) {
            model.setValue("depresystem", (Object)assetBook.getLong("depresystem"));
            model.setValue("basecurrency", (Object)assetBook.getLong("basecurrency"));
            model.setValue("exchangetable", (Object)assetBook.getLong("exchangetable"));
            model.setValue("periodtype", (Object)assetBook.getLong("periodtype"));
            model.setValue("startperiod", (Object)assetBook.getLong("startperiod"));
            this.setEnable(false);
            IFormView view = this.getView();
            view.setEnable(Boolean.valueOf(true), new String[]{"startperiod"});
        } else {
            DynamicObjectCollection leaseContracts = QueryServiceHelper.query((String)"fa_lease_contract_init", (String)Fa.comma((String[])new String[]{"currency", "sysswitchdate"}), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)}, (String)"sysswitchdate", (int)1);
            if (!leaseContracts.isEmpty()) {
                DynamicObject leaseContract = (DynamicObject)leaseContracts.get(0);
                model.setValue("basecurrency", (Object)leaseContract.getLong("currency"));
                model.setValue("systemswitchday", (Object)leaseContract.getDate("sysswitchdate"));
                IFormView view = this.getView();
                view.setEnable(Boolean.valueOf(false), new String[]{"basecurrency"});
            } else {
                this.setEnable(true);
            }
        }
    }

    private void setEnable(boolean canEditor) {
        IFormView view = this.getView();
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"depresystem"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"basecurrency"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"exchangetable"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"periodtype"});
        view.setEnable(Boolean.valueOf(canEditor), new String[]{"startperiod"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String property = e.getProperty().getName();
        if ("startperiod".equals(property)) {
            DynamicObject startPeriod = (DynamicObject)e.getChangeSet()[0].getNewValue();
            model.setValue("curperiod", (Object)startPeriod);
            if (startPeriod != null) {
                Date startPeriodBeginDate = startPeriod.getDate("begindate");
                model.setValue("systemswitchday", (Object)startPeriodBeginDate);
            } else {
                model.setValue("systemswitchday", null);
            }
        } else if ("org".equals(property)) {
            this.changeOrg();
            this.setNumberAndName(model);
        } else if ("depresystem".equals(property)) {
            if (model.getValue("depresystem") != null) {
                QFilter qFilter;
                Long depreSystemId = ((DynamicObject)model.getValue("depresystem")).getLong("id");
                String filed = Fa.comma((String[])new String[]{"basecurrency", "exchangetable", "periodtype"});
                DynamicObject depreSystem = QueryServiceHelper.queryOne((String)"fa_depresystem", (String)filed, (QFilter[])new QFilter[]{qFilter = new QFilter("id", "in", (Object)depreSystemId)});
                if (depreSystem.getLong("basecurrency") != 0L && model.getValue("basecurrency") == null) {
                    model.setValue("basecurrency", (Object)depreSystem.getLong("basecurrency"));
                }
                if (depreSystem.getLong("exchangetable") != 0L && model.getValue("exchangetable") == null) {
                    model.setValue("exchangetable", (Object)depreSystem.getLong("exchangetable"));
                }
                if (depreSystem.getLong("periodtype") != 0L && model.getValue("periodtype") == null) {
                    model.setValue("periodtype", (Object)depreSystem.getLong("periodtype"));
                    model.setValue("startperiod", null);
                    model.setValue("curperiod", null);
                }
            }
        } else if ("periodtype".equalsIgnoreCase(property)) {
            model.setValue("startperiod", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getParentView() == null) {
            return;
        }
        Long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
        if (!this.requireMutexBatch(orgId)) {
            return;
        }
        this.setNumberAndName(this.getModel());
    }

    private void setNumberAndName(IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            model.setValue("number", (Object)org.getString("number"));
            model.setValue("name", (Object)org.getString("name"));
        } else {
            model.setValue("number", null);
            model.setValue("name", null);
        }
    }

    public void pageRelease(EventObject e) {
        String org = this.getPageCache().get(((Object)((Object)this)).getClass().getName());
        if (org != null) {
            FaMutexRequireUtil.batchRelease((String)"fa_assetbook", Collections.singletonList(Long.parseLong(org)), (String)"leaseInit2AssetBook", (String)"add");
        }
    }

    private boolean requireMutexBatch(Long orgId) {
        Set lockIds;
        String cacheOrgId = this.getPageCache().get(((Object)((Object)this)).getClass().getName());
        if (cacheOrgId != null && orgId == Long.parseLong(cacheOrgId)) {
            return true;
        }
        if (cacheOrgId != null && orgId != Long.parseLong(cacheOrgId)) {
            FaMutexRequireUtil.batchRelease((String)"fa_assetbook", Collections.singletonList(Long.parseLong(cacheOrgId)), (String)"leaseInit2AssetBook", (String)"add");
        }
        if ((lockIds = FaMutexRequireUtil.requireMutexBatch((String)"fa_assetbook", Collections.singletonList(orgId), (String)"leaseInit2AssetBook", (String)"add")).isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u7f16\u8f91\u8d44\u4ea7\u8d26\u7c3f\uff0c\u6682\u65f6\u4e0d\u80fd\u7f16\u8f91\u79df\u8d41\u521d\u59cb\u5316\u3002", (String)"FaLeaseInitEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.setEnable(false);
            return false;
        }
        this.getPageCache().put(((Object)((Object)this)).getClass().getName(), orgId.toString());
        return true;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        FaBillImportOrgCheckUtil.checkOrgPermission(this.getView().getPageId(), e, "fa_lease_init", "org", "10");
        List data = e.getSourceDataList();
        HashSet queryPeriodTypeNums = new HashSet(4);
        HashSet periodNums = new HashSet(4);
        int i = 0;
        for (Map map : data) {
            Map org = (Map)map.get("org");
            if (!this.orgNums.add((String)org.get("number"))) {
                e.addCancelMessage(Integer.valueOf(i), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u5f15\u5165\u5b58\u5728\u76f8\u540c\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u5f15\u5165\u6570\u636e\u3002", (String)"FaLeaseInitEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            Map periodType = (Map)map.get("periodtype");
            queryPeriodTypeNums.add(periodType.get("number"));
            Map startPeriod = (Map)map.get("startperiod");
            periodNums.add(startPeriod.get("number"));
            ++i;
        }
        DynamicObjectCollection org4Db = QueryServiceHelper.query((String)"bos_org", (String)Fa.comma((String[])new String[]{"id", "number", "name"}), (QFilter[])new QFilter[]{new QFilter("number", "in", this.orgNums)});
        Map<String, Long> orgNumber2Id = org4Db.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        Map<Long, DynamicObject> orgNumber2Dy = org4Db.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObjectCollection existsLeaseInits = QueryServiceHelper.query((String)"fa_lease_init", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgNumber2Id.values())});
        Set existsLeaseInitOrgIds = existsLeaseInits.stream().map(v -> v.getLong("org")).collect(Collectors.toSet());
        DynamicObjectCollection periodTypeArray = QueryServiceHelper.query((String)"bd_period_type", (String)Fa.comma((String[])new String[]{"id", "number"}), (QFilter[])new QFilter[]{new QFilter("number", "in", queryPeriodTypeNums)});
        Map<String, Long> periodTypeNumber2Id = periodTypeArray.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id")));
        DynamicObjectCollection periodArray = QueryServiceHelper.query((String)"bd_period", (String)Fa.comma((String[])new String[]{"id", "number", "periodtype", "isadjustperiod"}), (QFilter[])new QFilter[]{new QFilter("number", "in", periodNums), new QFilter("periodtype", "in", periodTypeNumber2Id.values())});
        HashMap<String, DynamicObject> periodMap = new HashMap<String, DynamicObject>(periodArray.size());
        for (DynamicObject obj : periodArray) {
            String periodNum = obj.getString("number");
            long periodType = obj.getLong("periodtype");
            periodMap.put(periodNum + "_" + periodType, obj);
        }
        int index = -1;
        for (Map map : data) {
            ++index;
            Map org = (Map)map.get("org");
            String orgNumber = (String)org.get("number");
            Long orgId = orgNumber2Id.get(orgNumber);
            if (orgId != null) {
                DynamicObject orgDy = orgNumber2Dy.get(orgId);
                org.put("number", orgDy.getString("number"));
                org.put("name", orgDy.getString("name"));
                if (existsLeaseInitOrgIds.contains(orgId)) {
                    e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728\u5bf9\u5e94\u79df\u8d41\u521d\u59cb\u5316\uff0c\u4e0d\u53ef\u4ee5\u65b0\u589e\u3002", (String)"FaLeaseInitEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                Map depSystem = (Map)map.get("depresystem");
                this.checkDepSysAllowUse(e, orgId, depSystem, index);
            }
            Map periodType = (Map)map.get("periodtype");
            Map startPeriod = (Map)map.get("startperiod");
            Long periodTypeId = periodTypeNumber2Id.get(periodType.get("number"));
            if (periodTypeId == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u671f\u95f4\u7c7b\u578b\uff0c\u8bf7\u786e\u8ba4\u5f55\u5165\u662f\u5426\u6b63\u786e\u3002", (String)"FaLeaseInitEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject period = (DynamicObject)periodMap.get((String)startPeriod.get("number") + "_" + periodTypeId);
            if (period == null) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u4f1a\u8ba1\u671f\u95f4\uff0c\u8bf7\u786e\u8ba4\u5f55\u5165\u662f\u5426\u6b63\u786e\u3002", (String)"FaLeaseInitEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            boolean adjustPeriod = period.getBoolean("isadjustperiod");
            if (adjustPeriod) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4(%s)\u4e0d\u80fd\u4e3a\u8c03\u6574\u671f\u3002", (String)"FaLeaseInitEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[]{startPeriod.get("number")}));
                continue;
            }
            startPeriod.put("id", period.get("id").toString());
        }
    }

    private void checkDepSysAllowUse(InitImportDataEventArgs e, Long orgId, Map<String, String> depSystem, int index) {
        String depSysNum = depSystem.get("number");
        DynamicObjectCollection policies = (DynamicObjectCollection)ThreadCache.get((Object)("leaseInitImport_" + orgId + "_" + depSysNum), () -> BaseDataServiceHelper.queryBaseData((String)"fa_depresystem", (Long)orgId, (QFilter)new QFilter("number", "=", (Object)depSysNum), (String)Fa.comma((String[])new String[]{"id", "number", "createorg"})));
        if (policies.isEmpty()) {
            e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u53ef\u7528\u8d44\u4ea7\u653f\u7b56\u3002", (String)"FaLeaseInitEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[]{depSysNum}));
        } else if (policies.size() == 1) {
            depSystem.put("id", ((DynamicObject)policies.get(0)).getString("id"));
        } else {
            Long depreId = null;
            for (DynamicObject policy : policies) {
                long createOrg = policy.getLong("createorg");
                if (createOrg != orgId) continue;
                depreId = policy.getLong("id");
                break;
            }
            if (depreId == null || depreId.equals(0L)) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u5b58\u5728\u591a\u4e2a\u7f16\u7801\u4e3a%s\u7684\u8d44\u4ea7\u653f\u7b56\u3002", (String)"FaLeaseInitEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[]{depSysNum}));
                return;
            }
            depSystem.put("id", depreId.toString());
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String name;
        super.afterImportData(e);
        DynamicObject leaseInit = this.getModel().getDataEntity();
        Map org = (Map)e.getSourceData().get("org");
        String number = leaseInit.getString("number");
        if (StringUtils.isEmpty((String)number)) {
            leaseInit.set("number", org.get("number"));
        }
        if (StringUtils.isEmpty((String)(name = leaseInit.getString("name")))) {
            leaseInit.set("name", org.get("name"));
        }
        DynamicObject startPeriod = leaseInit.getDynamicObject("startperiod");
        Date startPeriodBeginDate = startPeriod.getDate("begindate");
        leaseInit.set("systemswitchday", (Object)startPeriodBeginDate);
        leaseInit.set("curperiod", leaseInit.get("startperiod"));
        leaseInit.set("status", (Object)"B");
        leaseInit.set("enable", (Object)"1");
    }
}

