/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaFilterList;

public class FaLeaseInitListPlugin
extends FaFilterList {
    private static final String[] HIDE_BTN = new String[]{"btn_upperiod", "syncmainbookcurperiod"};
    private static final String UPGRADEPERIODBTN = "btn_upperiod";
    private static final String SYNC_MAIN_BOOK_CUR_PERIOD = "syncmainbookcurperiod";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("leaseinitialization".equals(operateKey) || "leasedeinitialization".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setShortCuts();
    }

    private void setShortCuts() {
        this.getView().setVisible(Boolean.FALSE, HIDE_BTN);
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{UPGRADEPERIODBTN, SYNC_MAIN_BOOK_CUR_PERIOD});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (UPGRADEPERIODBTN.equals(evt.getItemKey())) {
            LeaseUtil.upgradeRentSettlePeriod();
            LeaseUtil.upgradeLeaseInterestDetailPeriod();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u644a\u9500\u671f\u95f4\u6210\u529f\u3002", (String)"FaLeaseInitListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else if (SYNC_MAIN_BOOK_CUR_PERIOD.equals(evt.getItemKey())) {
            ListSelectedRowCollection selectedRowIds = ((IListView)this.getView()).getSelectedRows();
            if (selectedRowIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"FaLeaseInitListPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<Object> pks = new HashSet<Object>(selectedRowIds.size());
            for (ListSelectedRow selectedRowId : selectedRowIds) {
                pks.add(selectedRowId.getPrimaryKeyValue());
            }
            DynamicObject[] leaseInits = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_lease_init"));
            Set orgIds = Arrays.stream(leaseInits).map(v -> v.getLong(Fa.id((String)"org"))).collect(Collectors.toSet());
            DynamicObjectCollection mainBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)true)});
            Map<Long, Long> org2CurPeriodMap = mainBooks.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getLong("curperiod")));
            ArrayList<String> orgNames = new ArrayList<String>(leaseInits.length);
            for (DynamicObject leaseInit : leaseInits) {
                long orgId = leaseInit.getLong(Fa.id((String)"org"));
                Long curPeriodId = org2CurPeriodMap.get(orgId);
                long startPeriodId = leaseInit.getLong(Fa.id((String)"startperiod"));
                if (startPeriodId > curPeriodId) {
                    orgNames.add(leaseInit.getString(Fa.dot((String[])new String[]{"org", "name"})));
                    continue;
                }
                leaseInit.set(Fa.id((String)"curperiod"), (Object)curPeriodId);
            }
            SaveServiceHelper.save((DynamicObject[])leaseInits);
            if (!orgNames.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u6838\u7b97\u7ec4\u7ec7\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u665a\u4e8e\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\uff0c\u540c\u6b65\u5931\u8d25\uff1a%s\u3002", (String)"FaLeaseInitListPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", orgNames)));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u4e3b\u8d26\u7c3f\u7684\u201c\u5f53\u524d\u671f\u95f4\u201d\u6210\u529f\u3002", (String)"FaLeaseInitListPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

