/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import com.alibaba.fastjson.JSONArray;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.lease.LeaseContractCal;
import kd.fi.fa.business.lease.utils.LeaseChangeUtil;
import kd.fi.fa.business.validator.lease.LeaseChangeBillValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.common.util.Tuple;

public class LeaseChangeEditPlugin
extends AbstractBillPlugIn {
    private static final String FA_CONTRACT_CHANGE_LAYOUT = "fa_contract_change_layout";
    private static final String AFT_CONTRACT_PANEL_AP = "aftcontractpanelap";
    private static final String BEF_CONTRACT_PANEL_AP = "befcontractpanelap";
    private static final String CACHE_BEF_CONTRACT_PAGE_ID = "cache_bef_contract_page_id";
    private static final String CACHE_AFT_CONTRACT_PAGE_ID = "cache_aft_contract_page_id";
    private static final List<String> LOAD_CONTRACT_INFO_OP = Arrays.asList("save", "submit", "unsubmit", "audit", "unaudit");
    private static final List<String> REFRESH_FIELD = Arrays.asList("generateassetchange", "deleteassetchange");
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String FORMAT = "yyyy-MM-dd";
    private static final Set<String> TRUE = new HashSet<String>(Arrays.asList(ResManager.loadKDString((String)"\u662f", (String)"LeaseChangeEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"LeaseChangeEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"LeaseChangeEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"LeaseChangeEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fi-fa-formplugin", "yes", "ok"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit leaseContractCtrl = (BasedataEdit)this.getControl("leasecontract");
        leaseContractCtrl.addBeforeF7SelectListener(this::setFilterBefContractF7);
        BasedataEdit changeItemsCtrl = (BasedataEdit)this.getControl("changeitems");
        changeItemsCtrl.addBeforeF7SelectListener(this::setFilterBefChangeItemsF7);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadContractInfo();
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        this.saveLeaseData(sourceData);
        this.setChangeItems(sourceData);
        DynamicObject changebakcontract = (DynamicObject)sourceData.get("changebakcontract");
        this.getModel().setValue("changebakcontract", (Object)changebakcontract);
        this.getView().updateView();
        this.deleteLeaseContractMapping(sourceData);
    }

    private Map<String, DataEntityPropertyCollection> getLeaseEntryMap(DynamicObject leaseContract) {
        HashMap<String, DataEntityPropertyCollection> leaseEntryMap = new HashMap<String, DataEntityPropertyCollection>(2);
        MainEntityType leaseEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_lease_contract");
        for (IDataEntityProperty isEntryProp : leaseEntityType.getProperties()) {
            String isEntryPropName = isEntryProp.getName();
            if (!(isEntryProp instanceof EntryProp)) continue;
            String entryName = isEntryProp.getName();
            DynamicObjectType entryObjectType = leaseContract.getDynamicObjectCollection(isEntryPropName).getDynamicObjectType();
            leaseEntryMap.put(entryName, entryObjectType.getProperties());
        }
        return leaseEntryMap;
    }

    private void saveLeaseData(Map<String, Object> sourceData) {
        QFilter qisbak;
        QFilter qnumber;
        ArrayList<DynamicObject> saveLeaseData = new ArrayList<DynamicObject>(16);
        String billno = (String)((Map)sourceData.get("leasecontract")).get("number");
        String org = (String)((Map)sourceData.get("org")).get("number");
        QFilter qorg = new QFilter("org.number", "=", (Object)org);
        DynamicObject lease = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_contract", (QFilter[])new QFilter[]{qorg, qnumber = new QFilter("number", "=", (Object)billno), qisbak = new QFilter("isbak", "=", (Object)"0")});
        if (null == lease) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e0e\u5f55\u5165\u7f16\u7801\u5bf9\u5e94\u7684\u79df\u8d41\u5408\u540c\uff1a%s\u3002", (String)"LeaseChangeEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), billno));
        }
        String bizStatus = lease.getString("bizstatus");
        if (!LeaseContractBizStatus.A.name().equals(bizStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u6b63\u5e38\u201d\uff0c\u8bf7\u5148\u5b8c\u6210\u76f8\u5173\u4e1a\u52a1\u540e\u518d\u53d8\u66f4\u3002", (String)"LeaseChangeEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        ((Map)sourceData.get("leasecontract")).put("importprop", "id");
        ((Map)sourceData.get("leasecontract")).put("id", lease.getLong("id"));
        ArrayList<String> changeItems = new ArrayList<String>(16);
        DynamicObject saveLease = LeaseChangeUtil.buildChangeBakContract((DynamicObject)lease);
        for (Map.Entry<String, Object> data : sourceData.entrySet()) {
            String feildName = data.getKey();
            Object feildValue = data.getValue();
            if (feildName.contains("changeitems_")) {
                String changeitem = feildName.split("changeitems_")[1];
                changeItems.add(changeitem);
                this.setValues(feildValue, changeitem, saveLease);
            }
            Map<String, DataEntityPropertyCollection> leaseEntryMap = this.getLeaseEntryMap(saveLease);
            HashMap<Integer, String> specialEntryPropMap = new HashMap<Integer, String>(1);
            if (!leaseEntryMap.containsKey(feildName) || ((JSONArray)feildValue).size() <= 0) continue;
            changeItems.add(feildName);
            DynamicObjectCollection leaseEntry = saveLease.getDynamicObjectCollection(feildName);
            DynamicObjectType entryObjectType = leaseEntry.getDynamicObjectType();
            if (feildName.equals("payruleentryentity")) {
                for (DynamicObject leaseEntryProp : leaseEntry) {
                    String paypoint = leaseEntryProp.getString("paypoint");
                    int seq = leaseEntryProp.getInt("seq");
                    if (StringUtils.isNotBlank((CharSequence)paypoint)) {
                        specialEntryPropMap.put(seq, paypoint);
                        continue;
                    }
                    specialEntryPropMap.put(seq, "A");
                }
            }
            leaseEntry.clear();
            DataEntityPropertyCollection entryDt = leaseEntryMap.get(feildName);
            JSONArray jsonData = (JSONArray)feildValue;
            int index = 1;
            for (Object obj : jsonData) {
                Map feildMap = (Map)obj;
                DynamicObject entryDy = new DynamicObject(entryObjectType);
                for (Map.Entry propMap : feildMap.entrySet()) {
                    Object value = propMap.getValue();
                    IDataEntityProperty entryProp = (IDataEntityProperty)entryDt.get(propMap.getKey());
                    if (null == entryProp) continue;
                    this.paseValue(entryProp, value, (String)propMap.getKey(), entryDy);
                }
                entryDy.set("seq", (Object)index);
                if (feildName.equals("payruleentryentity")) {
                    if (specialEntryPropMap.containsKey(index)) {
                        entryDy.set("paypoint", specialEntryPropMap.get(index));
                    } else {
                        entryDy.set("paypoint", (Object)"A");
                    }
                }
                ++index;
                leaseEntry.add((Object)entryDy);
            }
        }
        LeaseChangeEditPlugin.fillAutoCalFields(saveLease, changeItems);
        sourceData.put("changeitems", changeItems);
        sourceData.put("changebakcontract", saveLease);
        saveLeaseData.add(saveLease);
        Object[] save = SaveServiceHelper.save((DynamicObject[])saveLeaseData.toArray(new DynamicObject[0]));
        if (save.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f15\u5165\u79df\u8d41\u5408\u540c\u5931\u8d25\u3002", (String)"LeaseChangeEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private static void fillAutoCalFields(DynamicObject bakContract, List<String> changeItems) {
        DynamicObjectWrapper wrapper = new DynamicObjectWrapper(bakContract);
        if (changeItems.contains("leaseenddate")) {
            LeaseContractCal.setLeaseMonths((IObjWrapper)wrapper);
            LeaseContractCal.setDepreMonths((IObjWrapper)wrapper);
            LeaseContractCal.setIsExempt((IObjWrapper)wrapper);
        }
        if (changeItems.contains("discountrate")) {
            LeaseContractCal.setDailyDiscountRate((IObjWrapper)wrapper);
        }
    }

    private void setValues(Object feildValue, String feildName, DynamicObject leaseContract) {
        if (feildValue != null) {
            MainEntityType leaseEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_lease_contract");
            for (IDataEntityProperty isEntryProp : leaseEntityType.getProperties()) {
                String isEntryPropName = isEntryProp.getName();
                if (!feildName.equals(isEntryPropName) || isEntryProp instanceof EntryProp) continue;
                this.paseValue(isEntryProp, feildValue, feildName, leaseContract);
            }
        }
    }

    private void paseValue(IDataEntityProperty prop, Object feildValue, String feildName, DynamicObject leaseContract) {
        if (prop instanceof ComboProp) {
            List items = ((ComboProp)prop).getComboItems();
            if (items != null && !items.isEmpty()) {
                List<String> cellValueSplit = Arrays.asList(((String)feildValue).split(","));
                ArrayList<String> values = new ArrayList<String>();
                boolean isMulCombo = prop instanceof MulComboProp;
                for (ValueMapItem item : items) {
                    if (!(isMulCombo ? cellValueSplit.contains(item.getName().toString()) : item.getName().toString().equals(feildValue))) continue;
                    values.add(item.getValue());
                    if (isMulCombo) continue;
                    break;
                }
                if (StringUtils.isNotBlank((Object)feildValue) && values.isEmpty()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a%s\u3002", (String)"LeaseChangeEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), feildValue));
                }
                feildValue = String.join((CharSequence)",", values);
                leaseContract.set(feildName, feildValue);
            }
        } else if (prop instanceof BasedataProp) {
            String baseEntityId = ((BasedataProp)prop).getBaseEntityId();
            String baseDataNmuber = feildValue instanceof Map ? (String)((Map)feildValue).get("number") : feildValue.toString();
            QFilter qbaseNumber = new QFilter("number", "=", (Object)baseDataNmuber);
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)baseEntityId, (QFilter[])qbaseNumber.toArray());
            leaseContract.set(feildName, (Object)baseData);
        } else if (prop instanceof DateProp) {
            Date date;
            try {
                date = new SimpleDateFormat(FORMAT).parse(feildValue.toString());
            }
            catch (ParseException e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a%s\u3002", (String)"LeaseChangeEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), feildValue));
            }
            leaseContract.set(feildName, (Object)date);
        } else if (prop instanceof BooleanProp) {
            leaseContract.set(feildName, (Object)TRUE.contains(((String)feildValue).toLowerCase()));
        } else {
            leaseContract.set(feildName, feildValue);
        }
    }

    private void setChangeItems(Map<String, Object> sourceData) {
        List changeitemsList = (List)sourceData.get("changeitems");
        QFilter qchangeNumber = new QFilter("number", "in", (Object)changeitemsList);
        QFilter qchangeType = new QFilter("topic", "=", (Object)"fa_lease_contract");
        Map changeitemCol = BusinessDataServiceHelper.loadFromCache((String)"fa_change_item", (QFilter[])new QFilter[]{qchangeNumber, qchangeType});
        HashMap<String, DynamicObject> changeMap = new HashMap<String, DynamicObject>(1);
        for (Map.Entry dy : changeitemCol.entrySet()) {
            DynamicObject value = (DynamicObject)dy.getValue();
            String number = value.getString("number");
            changeMap.put(number, value);
        }
        DynamicObjectCollection changeitems = (DynamicObjectCollection)this.getModel().getValue("changeitems");
        DynamicObjectType objType = changeitems.getDynamicObjectType();
        for (String changeitemNumber : changeitemsList) {
            if (changeMap.containsKey(changeitemNumber)) {
                DynamicObject changeitemType = new DynamicObject(objType);
                DynamicObject changeitem = (DynamicObject)changeMap.get(changeitemNumber);
                changeitemType.set("fbasedataid", (Object)changeitem);
                changeitemType.set("fbasedataid_id", (Object)changeitem.getLong("id"));
                changeitems.add((Object)changeitemType);
                continue;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6a21\u677f\u5b57\u6bb5\uff1a%s\u672a\u627e\u5230\u5bf9\u5e94\u53ef\u53d8\u66f4\u9879\u76ee\uff0c\u8bf7\u914d\u7f6e\u5bf9\u5e94\u53ef\u53d8\u66f4\u9879\u76ee\u3002", (String)"LeaseChangeEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), changeitemNumber));
        }
    }

    private void deleteLeaseContractMapping(Map<String, Object> sourceData) {
        sourceData.remove("changeitems");
        sourceData.remove("changebakcontract");
        ArrayList<String> prpNmaeList = new ArrayList<String>(16);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_lease_change_bill");
        for (IDataEntityProperty prop : mainEntityType.getProperties()) {
            String propName = prop.getName();
            prpNmaeList.add(propName);
        }
        sourceData.keySet().removeIf(key -> !prpNmaeList.contains(key));
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObject changebakcontract = (DynamicObject)model.getValue("changebakcontract");
        Long id = changebakcontract.getLong("id");
        DynamicObject orileaseContract = (DynamicObject)model.getValue("leasecontract");
        Long oriContractId = orileaseContract.getLong("id");
        ArrayList<Long> contractIds = new ArrayList<Long>(2);
        contractIds.add(id);
        contractIds.add(oriContractId);
        DynamicObject[] changeBakContractArr = BusinessDataServiceHelper.load((Object[])contractIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_lease_contract"));
        Map<Long, DynamicObject> id2LeaseContractMap = Arrays.stream(changeBakContractArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        DynamicObject chgleaseObj = id2LeaseContractMap.get(id);
        DynamicObject orileaseObj = id2LeaseContractMap.get(oriContractId);
        List errorInfo = null;
        ArrayList<DynamicObject> deleteData = new ArrayList<DynamicObject>(16);
        try {
            errorInfo = LeaseChangeBillValidator.validate4Submit((DynamicObject)this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()), (DynamicObject)chgleaseObj, (DynamicObject)orileaseObj);
        }
        catch (Exception e1) {
            deleteData.add(changebakcontract);
            DeleteServiceHelper.delete((IDataEntityType)changebakcontract.getDynamicObjectType(), (Object[])deleteData.toArray(new DynamicObject[0]));
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"LeaseChangeEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"", ThrowableHelper.toString((Throwable)e1))));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
        if (errorInfo != null && errorInfo.size() > 0) {
            deleteData.add(changebakcontract);
            DeleteServiceHelper.delete((IDataEntityType)changebakcontract.getDynamicObjectType(), (Object[])deleteData.toArray(new DynamicObject[0]));
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u5bfc\u5165\u5931\u8d25\uff1a%s", (String)"LeaseChangeEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"", errorInfo)));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("leasecontract".equals(propName)) {
            this.loadContractInfo();
        } else if ("changeitems".equals(propName)) {
            this.addItemIfSelectedLeaseEndDate(oldValue);
            this.vadateSelectedChangeItems();
            this.loadContractInfo();
        }
    }

    private void vadateSelectedChangeItems() {
        DynamicObject changeBill = this.getModel().getDataEntity();
        if (changeBill == null) {
            return;
        }
        Object id = changeBill.getPkValue();
        if (id == null || (Long)id == 0L) {
            return;
        }
        DynamicObject changeBillInDb = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fa_lease_change_bill", (String)"changeitems");
        HashSet<Object> itemsSetInDb = new HashSet<Object>(8);
        DynamicObjectCollection itemsInDb = changeBillInDb.getDynamicObjectCollection("changeitems");
        for (DynamicObject items1 : itemsInDb) {
            DynamicObject item = items1.getDynamicObject("fbasedataid");
            itemsSetInDb.add(item.getPkValue());
        }
        DynamicObjectCollection items = changeBill.getDynamicObjectCollection("changeitems");
        HashSet<Object> itemsSet = new HashSet<Object>(8);
        for (DynamicObject item1 : items) {
            DynamicObject item = item1.getDynamicObject("fbasedataid");
            itemsSet.add(item.getPkValue());
        }
        itemsSetInDb.removeAll(itemsSet);
        if (itemsSetInDb.size() > 0) {
            Map changItemsDyMap = BusinessDataServiceHelper.loadFromCache((Object[])itemsSetInDb.toArray(new Object[1]), (String)"fa_change_item");
            DynamicObjectCollection changeItems = (DynamicObjectCollection)this.getModel().getValue("changeitems");
            for (DynamicObject changeItemDy : changItemsDyMap.values()) {
                DynamicObject newItem = changeItems.addNew();
                newItem.set("fbasedataid", (Object)changeItemDy);
                newItem.set("fbasedataid_id", changeItemDy.getPkValue());
            }
            this.getView().updateView("changeitems");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u4fdd\u5b58\u7684\u53d8\u66f4\u5355\u7684\u53d8\u66f4\u9879\u4e0d\u80fd\u5220\u9664\uff0c\u5df2\u81ea\u52a8\u52a0\u4e0a\u5220\u9664\u9879\u3002", (String)"LeaseChangeEditPlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (OP_SAVE.equals(key) || OP_SUBMIT.equals(key)) {
            String aftPageId = this.getPageCache().get(CACHE_AFT_CONTRACT_PAGE_ID);
            operate.getOption().setVariableValue("aftPageId", aftPageId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (LOAD_CONTRACT_INFO_OP.contains(key) && args.getOperationResult().isSuccess()) {
            this.loadContractInfo();
        }
        if (REFRESH_FIELD.contains(key) && args.getOperationResult().isSuccess()) {
            this.getView().updateView("pushstatus");
        }
    }

    private void setFilterBefContractF7(BeforeF7SelectEvent evt) {
        long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
        List filters = evt.getCustomQFilters();
        filters.add(new QFilter("assetunit", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)BillStatus.C.name()));
        filters.add(new QFilter("bizstatus", "=", (Object)LeaseContractBizStatus.A.name()));
        filters.add(new QFilter("isbak", "=", (Object)false));
    }

    private void setFilterBefChangeItemsF7(BeforeF7SelectEvent evt) {
        List filters = evt.getCustomQFilters();
        filters.add(new QFilter("topic", "=", (Object)"fa_lease_contract"));
    }

    private void addItemIfSelectedLeaseEndDate(Object oldValue) {
        QFilter[] filters;
        DynamicObject payRuleChangeItem;
        DynamicObjectCollection oldChangeItems = (DynamicObjectCollection)oldValue;
        HashSet<String> oldItemNumbers = new HashSet<String>(oldChangeItems.size());
        for (DynamicObject dyn : oldChangeItems) {
            DynamicObject item = dyn.getDynamicObject("fbasedataid");
            if (item == null) continue;
            String number = item.getString("number");
            oldItemNumbers.add(number);
        }
        if (oldItemNumbers.contains("leaseenddate")) {
            return;
        }
        DynamicObjectCollection changeItems = (DynamicObjectCollection)this.getModel().getValue("changeitems");
        HashSet<String> itemNumbers = new HashSet<String>(changeItems.size());
        for (DynamicObject dyn : changeItems) {
            DynamicObject item = dyn.getDynamicObject("fbasedataid");
            if (item == null) continue;
            String number = item.getString("number");
            itemNumbers.add(number);
        }
        if (itemNumbers.contains("leaseenddate") && !itemNumbers.contains("payruleentryentity") && (payRuleChangeItem = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_change_item", (QFilter[])(filters = new QFilter[]{new QFilter("topic", "=", (Object)"fa_lease_contract"), new QFilter("number", "=", (Object)"payruleentryentity")}))) != null) {
            DynamicObject newItem = changeItems.addNew();
            newItem.set("fbasedataid", (Object)payRuleChangeItem);
            newItem.set("fbasedataid_id", payRuleChangeItem.getPkValue());
            this.getView().updateView("changeitems");
        }
    }

    private void loadContractInfo() {
        this.loadBefContract();
        this.loadAftContract();
    }

    private void loadBefContract() {
        long befContractId = 0L;
        DynamicObject befContract = (DynamicObject)this.getModel().getValue("befcontract");
        if (befContract != null) {
            befContractId = befContract.getLong("id");
        }
        if (befContractId == 0L) {
            befContractId = (Long)this.getModel().getValue(Fa.id((String)"leasecontract"));
        }
        this.showContractLayout(befContractId, BEF_CONTRACT_PANEL_AP, "bef");
    }

    private void loadAftContract() {
        long aftContractId = 0L;
        DynamicObject aftContract = (DynamicObject)this.getModel().getValue("aftcontract");
        if (aftContract != null) {
            aftContractId = aftContract.getLong("id");
        }
        if (aftContractId == 0L) {
            aftContractId = (Long)this.getModel().getValue(Fa.id((String)"changebakcontract"));
        }
        if (aftContractId == 0L) {
            aftContractId = (Long)this.getModel().getValue(Fa.id((String)"leasecontract"));
        }
        this.showContractLayout(aftContractId, AFT_CONTRACT_PANEL_AP, "aft");
    }

    private void showContractLayout(long contractId, String targetKey, String type) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(FA_CONTRACT_CHANGE_LAYOUT);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(targetKey);
        param.setHasRight(true);
        if (contractId != 0L) {
            param.setPkId((Object)contractId);
        } else {
            Tuple<Long, Long> orgToShow = this.getOrgToShowContractLayout();
            param.setCustomParam("assetUnitToShow", (Object)((Long)orgToShow.item1).toString());
            param.setCustomParam("orgToShow", (Object)((Long)orgToShow.item2).toString());
        }
        if ("aft".equals(type)) {
            String changeFieldsJson = SerializationUtils.toJsonString(this.getChangeFields());
            param.setCustomParam("changeFields", (Object)changeFieldsJson);
        } else {
            param.setBillStatus(BillOperationStatus.VIEW);
        }
        param.setCustomParam("type", (Object)type);
        param.setCustomParam("changeBillStatus", this.getModel().getValue("billstatus"));
        this.getView().showForm((FormShowParameter)param);
        if ("bef".equals(type)) {
            this.getPageCache().put(CACHE_BEF_CONTRACT_PAGE_ID, param.getPageId());
        } else {
            this.getPageCache().put(CACHE_AFT_CONTRACT_PAGE_ID, param.getPageId());
        }
    }

    private Tuple<Long, Long> getOrgToShowContractLayout() {
        DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("org");
        if (assetUnit == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d44\u4ea7\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"LeaseChangeEditPlugin_12", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        long assetUnitId = assetUnit.getLong("id");
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType("09");
        param.setFromViewType("10");
        param.setOrgId(assetUnitId);
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(true);
        List fromOrgList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (fromOrgList.isEmpty()) {
            return new Tuple((Object)assetUnitId, (Object)0L);
        }
        return new Tuple((Object)assetUnitId, fromOrgList.get(0));
    }

    private List<String> getChangeFields() {
        DynamicObjectCollection changeItems = (DynamicObjectCollection)this.getModel().getValue("changeitems");
        return changeItems.stream().map(v -> v.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
    }
}

