/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.fa.formplugin.lease.BatchImportSheetHandler;

public class LeaseChangeImportPlugin
extends BatchImportPlugin {
    private static final String BOS_IMPORT = "bos-import";
    private static Log log = LogFactory.getLog(LeaseChangeImportPlugin.class);
    private HeartBeat heartbeat = new HeartBeat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        Map option = this.ctx.getOption();
        for (String url : this.ctx.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_lease_change_bill");
                    if (mainEntityType instanceof QueryEntityType) {
                        mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                    }
                    reader.read(in, (SheetHandler)new BatchImportSheetHandler(this.ctx, mainEntityType, url, option, this.heartbeat));
                }
                catch (Throwable mainEntityType) {
                    throwable = mainEntityType;
                    throw mainEntityType;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable mainEntityType) {
                            throwable.addSuppressed(mainEntityType);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                log.error(e);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), e);
                } else {
                    Throwable cause = e.getCause();
                    String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"LeaseChangeImportPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                }
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
            finally {
                this.ctx.setResolveComplete(url);
            }
        }
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockFields = new ArrayList<String>(2);
        lockFields.add("keyfields");
        lockFields.add("radiofield1");
        lockFields.add("radiofield2");
        lockFields.add("btndownload");
        return lockFields;
    }
}

