/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.operate.MutexHelper;

public class LeaseContractChangeLayoutEditPlugin
extends AbstractBillPlugIn {
    protected static final String PARAM_TYPE = "type";
    protected static final String PARAM_CHANGE_FIELDS = "changeFields";
    protected static final String PARAM_CHANGE_BILL_STATUS = "changeBillStatus";
    protected static final String PARAM_ASSET_UNIT_TO_SHOW = "assetUnitToShow";
    protected static final String PARAM_ORG_TO_SHOW = "orgToShow";
    protected static final String TYPE_BEF = "bef";
    protected static final String TYPE_AFT = "aft";
    private static final String TITLE_LAB = "titlelab";
    private static final Map<String, List<String>> RELATIVE_CONTROL = new HashMap<String, List<String>>(4);

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        e.setFireAfterCreateNewData(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrgForEmptyBill();
        this.setTitleLab();
        this.setLockFields();
        this.setUnLockFields();
    }

    public void destory() {
        MutexHelper.release((IFormView)this.getView());
        super.destory();
    }

    private void setOrgForEmptyBill() {
        String assetUnitToShow = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ASSET_UNIT_TO_SHOW);
        String orgToShow = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_ORG_TO_SHOW);
        if (StringUtils.isNotBlank((CharSequence)assetUnitToShow) && StringUtils.isNotBlank((CharSequence)orgToShow)) {
            this.getModel().beginInit();
            this.getModel().setValue("assetunit", (Object)Long.valueOf(assetUnitToShow));
            this.getModel().setValue("org", (Object)Long.valueOf(orgToShow));
            this.getModel().endInit();
        }
    }

    private void setTitleLab() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TYPE);
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        Label titleLab = (Label)this.getView().getControl(TITLE_LAB);
        if (TYPE_BEF.equals(type)) {
            titleLab.setText(ResManager.loadKDString((String)"\u53d8\u66f4\u524d", (String)"LeaseContractChangeLayoutEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else if (TYPE_AFT.equals(type)) {
            titleLab.setText(ResManager.loadKDString((String)"\u53d8\u66f4\u540e", (String)"LeaseContractChangeLayoutEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void setLockFields() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TYPE);
        if (TYPE_BEF.equals(type)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"conentpanel"});
            return;
        }
        String[] lockFields = (String[])this.getModel().getDataEntityType().getProperties().stream().map(IMetadata::getName).toArray(String[]::new);
        this.getView().setEnable(Boolean.FALSE, lockFields);
        this.lockRelativeControl();
    }

    private void lockRelativeControl() {
        List<String> allRelativeControl = null;
        for (List<String> controls : RELATIVE_CONTROL.values()) {
            if (allRelativeControl == null) {
                allRelativeControl = controls;
                continue;
            }
            allRelativeControl.addAll(controls);
        }
        if (allRelativeControl != null) {
            this.getView().setEnable(Boolean.FALSE, allRelativeControl.toArray(new String[0]));
        }
    }

    private void setUnLockFields() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_TYPE);
        if (TYPE_BEF.equals(type)) {
            return;
        }
        String changeBillStatus = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_CHANGE_BILL_STATUS);
        if (!BillStatus.A.name().equals(changeBillStatus)) {
            return;
        }
        String changeFieldsJson = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_CHANGE_FIELDS);
        List changeFields = SerializationUtils.fromJsonStringToList((String)changeFieldsJson, String.class);
        this.getView().setEnable(Boolean.TRUE, changeFields.toArray(new String[0]));
        changeFields.forEach(this::unLockRelativeControl);
    }

    private void unLockRelativeControl(String key) {
        List<String> controls = RELATIVE_CONTROL.get(key);
        if (controls == null) {
            return;
        }
        this.getView().setEnable(Boolean.TRUE, controls.toArray(new String[0]));
    }

    static {
        ArrayList<String> ruleEntryRelativeControl = new ArrayList<String>(5);
        ruleEntryRelativeControl.add("advconbaritemap");
        ruleEntryRelativeControl.add("advconbaritemap1");
        ruleEntryRelativeControl.add("advconbaritemap2");
        ruleEntryRelativeControl.add("advconbaritemap3");
        ruleEntryRelativeControl.add("generatepayplan");
        RELATIVE_CONTROL.put("payruleentryentity", ruleEntryRelativeControl);
    }
}

