/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.DataModelWrapper;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.enums.lease.InvoiceType;
import kd.fi.fa.business.enums.lease.LeaseContractDepreTypeEnum;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.business.enums.lease.PayFrequency;
import kd.fi.fa.business.lease.LeaseContractCal;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.lease.LeaseBizRecordTabHandler;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaShowFormUtils;

public class LeaseContractEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(LeaseContractEditPlugin.class);
    private static final String FA_LEASE_CONTRACT = "fa_lease_contract";
    private static final String FA_LEASE_CONTRACT_INIT = "fa_lease_contract_init";
    private static final String[] EXEMPT_AFFECTED_FIELDS = new String[]{"leaseliabori", "leaseliab", "leaseassets", "assetsaccumdepre", "assetsaddupyeardepre", "hasdepremonths", "accumrent", "addupyearrent", "accuminterest", "addupyearinterest"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit assetUnit = (BasedataEdit)this.getView().getControl("assetunit");
        assetUnit.addBeforeF7SelectListener(evt -> FaFormPermissionUtil.beforeAssetUnitSelectV2(this.getView().getPageId(), evt, FA_LEASE_CONTRACT));
        OrgEdit org = (OrgEdit)this.getView().getControl("org");
        if (org != null) {
            org.setIsOnlyDisplayOrgLeaves(true);
            org.addBeforeF7SelectListener(listener -> FaF7DeptUtils.orgDelegateAssetUnit(listener, this.getModel()));
        }
        EntryGrid srcContractEntry = (EntryGrid)this.getControl("srccontractentity");
        srcContractEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid terminationEntry = (EntryGrid)this.getControl("terminationentry");
        terminationEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid leaseChangeEntry = (EntryGrid)this.getControl("leasechangeentry");
        leaseChangeEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setCurrencyAndSysSwitchDate();
    }

    public void afterLoadData(EventObject e) {
        this.setDiscountRateEnable();
        this.setRuleDeductibleEnable4LoadData();
        String isClickBefChgContract = this.getView().getParentView().getPageCache().get("isClickBefChgContract");
        if ("true".equals(isClickBefChgContract)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"queryrentsettle", "viewbillrelation"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"queryrentsettle", "viewbillrelation"});
        }
        this.setFieldShowNameByDepreType();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        new LeaseBizRecordTabHandler(this.getView()).handle();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setLeaseAssetsGroupVisible();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue())};
            DynamicObject leaseInit = QueryServiceHelper.queryOne((String)"fa_lease_init", (String)Fa.comma((String[])new String[]{"basecurrency", "systemswitchday", "status"}), (QFilter[])filters);
            if (leaseInit == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u672a\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5408\u540c\u3002", (String)"LeaseContractEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
                return;
            }
            this.initLeaseContractCheck(leaseInit);
        }
        this.setFreeLeaseStartDateRange();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        logger.info(String.format("\u79df\u8d41\u5408\u540c[%s]\u53d8\u5316\u5b57\u6bb5\uff1a%s\uff0c\u884c\u53f7(\u4ece0\u5f00\u59cb)\uff1a%s\uff0c[%s] -> [%s]\u3002", this.getModel().getValue("number"), propName, index, e.getChangeSet()[0].getOldValue(), e.getChangeSet()[0].getNewValue()));
        switch (propName) {
            case "org": {
                this.setCurrencyAndSysSwitchDate();
                this.setInitConfirmDate();
                this.setTransitionPlan();
                this.setDailyDiscountRate();
                this.setIsExempt();
                this.setLeaseMonths();
                this.setDepreMonths();
                this.setFreeLeaseMonths();
                break;
            }
            case "currency": {
                this.setDiscountRate();
                break;
            }
            case "assetcat": {
                this.setUnit();
                break;
            }
            case "assetamount": {
                this.checkAssetAmountValid(e);
                break;
            }
            case "leasestartdate": {
                this.setLeaseEndDateRange();
                this.setFreeLeaseStartDateRange();
                this.setLeaseMonths();
                this.setFreeLeaseMonths();
                this.setInitConfirmDate();
                this.setLeaseTermStartDate();
                break;
            }
            case "leaseenddate": {
                this.setIsExempt();
                this.setLeaseMonths();
                this.setDepreMonths();
                break;
            }
            case "freeleasestartdate": {
                this.setFreeLeaseMonths();
                this.setInitConfirmDate();
                this.setLeaseTermStartDate();
                break;
            }
            case "initconfirmdate": {
                this.setIsExempt();
                this.setDepreMonths();
                this.setDiscountRate();
                break;
            }
            case "leasetermstartdate": {
                this.setTransitionPlan();
                this.setDepreMonths();
                break;
            }
            case "isexempt": {
                this.setDiscountRateEnable();
                this.clearDataIfExempt();
                this.setTransitionPlan();
                break;
            }
            case "depremonths": {
                this.setDiscountRate();
                break;
            }
            case "discountrate": {
                this.setDailyDiscountRate();
                break;
            }
            case "transitionplan": {
                this.setDepreMonths();
                this.setDiscountRate();
                break;
            }
            case "rule_payitem": {
                this.setPayRuleFrequency(index);
                break;
            }
            case "rule_invoicetype": {
                this.setRuleDeductibleRange(index);
                break;
            }
            case "rule_deductible": {
                this.checkRuleDeductibleValid(e);
                break;
            }
            case "rule_taxrate": 
            case "amount": {
                this.setRuleTax(index);
                break;
            }
            case "depretype": {
                this.setFieldShowNameByDepreType();
                this.setDepreMonths();
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().deleteEntryData("payplanentryentity");
        this.setDiscountRateEnable();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        switch (fieldName) {
            case "srccontractshow": {
                this.showSrcContractForm();
                break;
            }
            case "clearbillno": {
                this.showClearBillForm();
                break;
            }
            case "renewalcontractshow": {
                this.showRenewalContractForm();
                break;
            }
            case "leasechangebillno": {
                this.showLeaseChangeBillForm(rowIndex);
                break;
            }
            case "befchangeversion": {
                this.showBefChangeContractForm(rowIndex);
                break;
            }
        }
    }

    private IObjWrapper buildObjWrapper() {
        return new DataModelWrapper(this.getModel());
    }

    private void setCurrencyAndSysSwitchDate() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue())};
            DynamicObject leaseInit = QueryServiceHelper.queryOne((String)"fa_lease_init", (String)Fa.comma((String[])new String[]{"basecurrency", "systemswitchday", "status"}), (QFilter[])filters);
            if (leaseInit == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u672a\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5408\u540c\u3002", (String)"LeaseContractEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
                return;
            }
            long baseCurrencyId = leaseInit.getLong("basecurrency");
            this.getModel().setValue("currency", (Object)baseCurrencyId);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"LeaseContractEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void initLeaseContractCheck(DynamicObject leaseInit) {
        String entityName = this.getModel().getDataEntityType().getName();
        if (FA_LEASE_CONTRACT_INIT.equals(entityName)) {
            Date sysSwitchDate = leaseInit.getDate("systemswitchday");
            if (sysSwitchDate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u7ef4\u62a4\u79df\u8d41\u521d\u59cb\u5316\u4e2d\u6570\u636e\u3002", (String)"LeaseContractEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            }
            this.getModel().setValue("sysswitchdate", (Object)sysSwitchDate);
            String status = leaseInit.getString("status");
            if ("C".equals(status)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u65b0\u589e\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u3002", (String)"LeaseContractEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            }
        }
    }

    private void setUnit() {
        DynamicObject assetCat = (DynamicObject)this.getModel().getValue("assetcat");
        if (assetCat != null) {
            DynamicObject unit = assetCat.getDynamicObject("unit");
            DynamicObject curUnit = (DynamicObject)this.getModel().getValue("unit");
            if (curUnit == null && unit != null) {
                this.getModel().setValue("unit", unit.getPkValue());
            }
        }
    }

    private void setLeaseEndDateRange() {
        Date leaseStartDate = (Date)this.getModel().getValue("leasestartdate");
        if (leaseStartDate == null) {
            return;
        }
        DateEdit leaseEndDateEdit = (DateEdit)this.getView().getControl("leaseenddate");
        leaseEndDateEdit.setMinDate(DateUtil.addDay((Date)leaseStartDate, (int)1));
        Date leaseEndDate = (Date)this.getModel().getValue("leaseenddate");
        if (leaseEndDate != null && DateUtil.compareShortDate((Date)leaseStartDate, (Date)leaseEndDate) >= 0) {
            this.getModel().setValue("leaseenddate", null);
        }
    }

    private void setFreeLeaseStartDateRange() {
        Date leaseStartDate = (Date)this.getModel().getValue("leasestartdate");
        if (leaseStartDate == null) {
            return;
        }
        DateEdit freeLeaseStartDateEdit = (DateEdit)this.getView().getControl("freeleasestartdate");
        freeLeaseStartDateEdit.setMaxDate(DateUtil.addDay((Date)leaseStartDate, (int)-1));
        Date freeLeaseStartDate = (Date)this.getModel().getValue("freeleasestartdate");
        if (freeLeaseStartDate != null && DateUtil.compareShortDate((Date)freeLeaseStartDate, (Date)leaseStartDate) > 0) {
            this.getModel().setValue("freeleasestartdate", null);
        }
    }

    private void setLeaseMonths() {
        LeaseContractCal.setLeaseMonths((IObjWrapper)this.buildObjWrapper());
    }

    private void setFreeLeaseMonths() {
        LeaseContractCal.setFreeLeaseMonths((IObjWrapper)this.buildObjWrapper());
    }

    private void setRuleDeductibleRange(int index) {
        String invoiceType = (String)this.getModel().getValue("rule_invoicetype", index);
        if (InvoiceType.DEDICATED.getValue().equals(invoiceType)) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"rule_deductible"});
            this.getModel().setValue("rule_deductible", (Object)Boolean.TRUE, index);
        } else if (InvoiceType.COMMON.getValue().equals(invoiceType)) {
            this.getModel().setValue("rule_deductible", (Object)Boolean.FALSE, index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"rule_deductible"});
        }
    }

    private void setRuleTax(int index) {
        BigDecimal ruleTaxRate = (BigDecimal)this.getModel().getValue("rule_taxrate", index);
        BigDecimal ruleAmount = (BigDecimal)this.getModel().getValue("amount", index);
        if (BigDecimal.ZERO.compareTo(ruleTaxRate) == 0 || BigDecimal.ZERO.compareTo(ruleAmount) == 0) {
            return;
        }
        ruleTaxRate = ruleTaxRate.divide(FaBigDecimalUtil.HUNDRED, 4, LeaseUtil.getRoundingMode4CalAmount());
        BigDecimal ruleTax = ruleAmount.subtract(ruleAmount.divide(BigDecimal.ONE.add(ruleTaxRate), this.getCurrencyAmtPrecision(), LeaseUtil.getRoundingMode4CalAmount()));
        this.getModel().setValue("rule_tax", (Object)ruleTax, index);
    }

    private void setInitConfirmDate() {
        LeaseContractCal.setInitConfirmDate((IObjWrapper)this.buildObjWrapper());
    }

    private void setIsExempt() {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (!parentFormId.equals("fa_lease_change_bill")) {
            LeaseContractCal.setIsExempt((IObjWrapper)this.buildObjWrapper());
        }
    }

    private void setDiscountRate() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (FA_LEASE_CONTRACT.equalsIgnoreCase(formId) || FA_LEASE_CONTRACT_INIT.equalsIgnoreCase(formId)) {
            LeaseContractCal.setDiscountRate((IObjWrapper)this.buildObjWrapper());
        } else {
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate");
            if (discountRate == null || BigDecimal.ZERO.compareTo(discountRate) == 0) {
                LeaseContractCal.setDiscountRate((IObjWrapper)this.buildObjWrapper());
            }
        }
    }

    private void setDailyDiscountRate() {
        LeaseContractCal.setDailyDiscountRate((IObjWrapper)this.buildObjWrapper());
    }

    private void setDepreMonths() {
        LeaseContractCal.setDepreMonths((IObjWrapper)this.buildObjWrapper());
    }

    private void setPayRuleFrequency(int index) {
        DynamicObject payItem = (DynamicObject)this.getModel().getValue("rule_payitem", index);
        if (payItem == null) {
            this.getModel().setValue("frequency", null, index);
            return;
        }
        String frequency = payItem.getString("frequency");
        if (StringUtils.isBlank((CharSequence)frequency)) {
            this.getModel().setValue("frequency", (Object)PayFrequency.A, index);
        } else {
            this.getModel().setValue("frequency", (Object)frequency, index);
        }
    }

    private void setDiscountRateEnable() {
        boolean isExempt = (Boolean)this.getModel().getValue("isexempt");
        if (isExempt) {
            this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO);
            this.getView().setEnable(Boolean.FALSE, new String[]{"discountrate"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"discountrate"});
        }
    }

    private void setRuleDeductibleEnable4LoadData() {
        DynamicObjectCollection ruleEntry = this.getModel().getEntryEntity("payruleentryentity");
        for (DynamicObject row : ruleEntry) {
            int seq = row.getInt("seq");
            String ruleInvoiceType = row.getString("rule_invoicetype");
            if (!StringUtils.isNotBlank((CharSequence)ruleInvoiceType) || !InvoiceType.COMMON.getValue().equals(ruleInvoiceType)) continue;
            this.getView().setEnable(Boolean.FALSE, seq - 1, new String[]{"rule_deductible"});
        }
    }

    private void setLeaseTermStartDate() {
        LeaseContractCal.setLeaseTermStartDate((IObjWrapper)this.buildObjWrapper());
    }

    private void setTransitionPlan() {
        LeaseContractCal.setTransitionPlan((IObjWrapper)this.buildObjWrapper());
    }

    private int getCurrencyAmtPrecision() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ec4\u7ec7\u662f\u5426\u4e3a\u7a7a\uff0c\u6216\u8bbe\u7f6e\u201c\u79df\u8d41\u521d\u59cb\u5316\u201d\u3002", (String)"LeaseContractEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return currency.getInt("amtprecision");
    }

    private void checkAssetAmountValid(PropertyChangedArgs e) {
        BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
        BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (newValue.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8d44\u4ea7\u6570\u91cf\u201d\u4e0d\u80fd\u5c0f\u4e8e\u96f6\u3002", (String)"LeaseContractEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("assetamount", (Object)oldValue);
        }
    }

    private void checkRuleDeductibleValid(PropertyChangedArgs e) {
        Object oldValue = e.getChangeSet()[0].getOldValue();
        boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String ruleInvoiceType = (String)this.getModel().getValue("rule_invoicetype", rowIndex);
        if (newValue && StringUtils.isNotBlank((CharSequence)ruleInvoiceType) && InvoiceType.COMMON.getValue().equals(ruleInvoiceType)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u884c\uff1a\u201c\u53d1\u7968\u7c7b\u578b\u201d\u4e3a\u201c\u666e\u901a\u53d1\u7968\u201d\uff0c\u4e0d\u53ef\u62b5\u6263\u3002", (String)"LeaseContractEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), rowIndex + 1));
            this.getModel().setValue("rule_deductible", oldValue, rowIndex);
        }
    }

    private void clearDataIfExempt() {
        boolean isExempt = (Boolean)this.getModel().getValue("isexempt");
        if (isExempt) {
            this.getModel().deleteEntryData("payplanentryentity");
            this.getModel().setValue("leaseliabori", (Object)BigDecimal.ZERO);
            this.getModel().setValue("leaseliab", (Object)BigDecimal.ZERO);
            this.getModel().setValue("leaseassets", (Object)BigDecimal.ZERO);
            this.getModel().setValue("assetsaccumdepre", (Object)BigDecimal.ZERO);
            this.getModel().setValue("assetsaddupyeardepre", (Object)BigDecimal.ZERO);
            this.getModel().setValue("hasdepremonths", (Object)0);
            this.getModel().setValue("accumrent", (Object)BigDecimal.ZERO);
            this.getModel().setValue("addupyearrent", (Object)BigDecimal.ZERO);
            this.getModel().setValue("accuminterest", (Object)BigDecimal.ZERO);
            this.getModel().setValue("addupyearinterest", (Object)BigDecimal.ZERO);
            this.getView().setEnable(Boolean.FALSE, EXEMPT_AFFECTED_FIELDS);
        } else {
            String sourceType = (String)this.getModel().getValue("sourcetype");
            this.getView().setEnable(Boolean.valueOf(LeaseContractSourceType.B.name().equals(sourceType)), EXEMPT_AFFECTED_FIELDS);
        }
    }

    private void showClearBillForm() {
        DynamicObject clearBill = (DynamicObject)this.getModel().getValue("clearbill");
        if (clearBill == null) {
            return;
        }
        FaShowFormUtils.showSingleBillForm(this.getView(), "fa_clearbill", clearBill.getPkValue(), ShowType.MainNewTabPage);
    }

    private void showRenewalContractForm() {
        long renewalContractId = (Long)this.getModel().getValue("renewalcontractid");
        if (renewalContractId == 0L) {
            return;
        }
        FaShowFormUtils.showSingleBillForm(this.getView(), FA_LEASE_CONTRACT, renewalContractId, ShowType.MainNewTabPage);
    }

    private void showSrcContractForm() {
        DynamicObject srcContract = (DynamicObject)this.getModel().getValue("srccontract");
        if (srcContract == null) {
            return;
        }
        FaShowFormUtils.showSingleBillForm(this.getView(), FA_LEASE_CONTRACT, srcContract.getPkValue(), ShowType.MainNewTabPage);
    }

    private void showLeaseChangeBillForm(int rowIndex) {
        long leaseChangeBillId = (Long)this.getModel().getValue("leasechangebillid", rowIndex);
        FaShowFormUtils.showSingleBillForm(this.getView(), "fa_lease_change_bill", leaseChangeBillId, ShowType.MainNewTabPage, OperationStatus.VIEW);
    }

    private void showBefChangeContractForm(int rowIndex) {
        long befChangeContractId = (Long)this.getModel().getValue("befchgcontractid", rowIndex);
        this.getView().getPageCache().put("isClickBefChgContract", "true");
        FaShowFormUtils.showSingleBillForm(this.getView(), FA_LEASE_CONTRACT, befChangeContractId, ShowType.MainNewTabPage, OperationStatus.VIEW);
    }

    private void setLeaseAssetsGroupVisible() {
        String transitionPlan = (String)this.getModel().getValue("transitionplan");
        boolean showLeaseAssets = LeaseUtil.isCalLeaseAssetsForPayPlan((String)transitionPlan);
        this.getView().setVisible(Boolean.valueOf(showLeaseAssets), new String[]{"leaseassetsgroup"});
    }

    private void setFieldShowNameByDepreType() {
        DecimalEdit depreField = (DecimalEdit)this.getView().getControl("depremonths");
        String depreType = this.getModel().getDataEntity().getString("depretype");
        LeaseContractDepreTypeEnum depreTypeEnum = LeaseContractDepreTypeEnum.getByValue((String)depreType);
        if (depreTypeEnum == null) {
            depreTypeEnum = LeaseContractDepreTypeEnum.MONTH;
        }
        switch (depreTypeEnum) {
            case DAY: {
                depreField.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9002\u7528\u79df\u8d41\u671f(\u65e5)", (String)"LeaseContractEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0])));
                break;
            }
            case MONTH: {
                depreField.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9002\u7528\u79df\u8d41\u671f(\u6708)", (String)"LeaseContractEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0])));
            }
        }
    }
}

