/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.lease.LeaseContractInitListPlugin;

public class LeaseContractInitEditPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(LeaseContractInitEditPlugin.class);
    private static final String TRACK_DOWN_INIT_REAL_CARD = "trackdowninitrealcard";
    private static final String CLEAR_DATA = "cleardata";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("sourcetype", (Object)LeaseContractSourceType.B);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "trackdowninitrealcard": {
                this.showInitRealCardList();
                break;
            }
        }
    }

    private void showInitRealCardList() {
        Object masterId = this.getModel().getDataEntity().get("masterid");
        boolean isPush = BFTrackerServiceHelper.isPush((String)"fa_lease_contract_init", (Long)((Long)masterId));
        if (!isPush) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LeaseContractInitEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> masterIdList = new ArrayList<Object>(2);
        masterIdList.add(masterId);
        LeaseContractInitListPlugin.openTrackDown(masterIdList, this.getView());
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{CLEAR_DATA});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (CLEAR_DATA.equals(itemKey)) {
            Object leaseContractId = this.getModel().getDataEntity().getPkValue();
            QFilter[] qFilter = new QFilter[]{new QFilter("sourceflag", "=", (Object)SourceFlagEnum.INITLEASECONTRACT.name()), new QFilter("srcbillid", "=", leaseContractId)};
            DynamicObjectCollection realCard = QueryServiceHelper.query((String)"fa_card_real", (String)"id", (QFilter[])qFilter);
            Set readCardIds = realCard.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            ConvertDataService reader = new ConvertDataService();
            TableDefine leaseTableDefine = reader.loadTableDefine("fa_lease_contract", "fa_lease_contract");
            TableDefine realCardTableDefine = reader.loadTableDefine("fa_card_real", "fa_card_real");
            Long leaseTableId = leaseTableDefine.getTableId();
            Long realCardTableId = realCardTableDefine.getTableId();
            try {
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("delete from t_botp_billtracker where ", new Object[0]);
                sqlBuilder.append("fstableid = ?", new Object[]{leaseTableId});
                sqlBuilder.append(" and fsbillid = ?", new Object[]{leaseContractId});
                sqlBuilder.append(" and fttableid = ?", new Object[]{realCardTableId});
                if (!readCardIds.isEmpty()) {
                    sqlBuilder.append(String.format(" and ftbillid not in (%s)", Fa.join(readCardIds, (String)", ")), new Object[0]);
                }
                DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e05\u9664\u6210\u529f", (String)"LeaseContractInitEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrMessage("", ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LeaseContractInitEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setShortCuts();
        this.getView().setVisible(Boolean.FALSE, new String[]{CLEAR_DATA});
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }
}

