/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class LeaseContractInitListPlugin
extends AbstractListPlugin {
    private static final String CALL_BACK_REFRESH = "call_back_refresh";
    private static final String TRACK_DOWN_INIT_REAL_CARD = "trackdowninitrealcard";
    private static Log logger = LogFactory.getLog(LeaseContractInitListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        filters.add(new QFilter("sourcetype", "=", (Object)LeaseContractSourceType.B));
        filters.add(new QFilter("isinitdata", "=", (Object)true));
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        try {
            String jsonString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "assetunit");
            this.getPageCache().put("assetunits", jsonString);
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
        }
        FaFormPermissionUtil.filterContainerInitV2(args, this.getPageCache(), this.getView().getPageId());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        FaFormPermissionUtil.filterContainerBeforeF7SelectV2(e, this.getView().getPageId(), "fa_lease_contract_init");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "trackdowninitrealcard": {
                this.showInitRealCardList();
                break;
            }
        }
    }

    private void showInitRealCardList() {
        boolean hasDownBill;
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        Set pkValues = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toSet());
        Map initLeaseContractMap = BusinessDataServiceHelper.loadFromCache((Object[])pkValues.toArray(), (String)"fa_lease_contract_init");
        ArrayList<Object> masterIdList = new ArrayList<Object>(8);
        for (DynamicObject initLeaseContract : initLeaseContractMap.values()) {
            Long masterId = initLeaseContract.getLong("masterid");
            masterIdList.add(masterId);
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"fa_lease_contract_init", (Long[])masterIdList.toArray(new Long[0]));
        HashSet initCardIds = (HashSet)targetBills.get("fa_initcard_real");
        HashSet cardIds = (HashSet)targetBills.get("fa_card_real");
        boolean bl = hasDownBill = !(initCardIds != null && !initCardIds.isEmpty() || cardIds != null && !cardIds.isEmpty());
        if (hasDownBill) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LeaseContractInitListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else {
            LeaseContractInitListPlugin.openTrackDown(masterIdList, this.getView());
        }
    }

    protected static void openTrackDown(List<Object> masterIdList, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getCustomParams().put("masterIdList", masterIdList);
        parameter.setFormId("fa_init_lease_trackdowm");
        view.showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALL_BACK_REFRESH.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

