/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class LeaseContractInitTrackDownEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_TAB_BILLS = "tabbills";
    private Map<String, String> childPageIds = new HashMap<String, String>();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAllList();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            this.closePage(entityNumber);
        }
    }

    private String getPageId(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(entityNumber);
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get("pageIds");
        return StringUtils.isBlank((CharSequence)cacheValue) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    private void closePage(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        if (pageIds.containsKey(entityNumber)) {
            pageIds.remove(entityNumber);
        }
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }

    private void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put("pageIds", SerializationUtils.toJsonString(childPageIds));
    }

    private void showAllList() {
        this.childPageIds.clear();
        Map<Long, HashSet<Long>> mainTableIdMap = this.queryMainTableIdMap();
        if (mainTableIdMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, HashSet<Long>> entry : mainTableIdMap.entrySet()) {
            Long mainTableId = entry.getKey();
            HashSet<Long> billIds = entry.getValue();
            this.showList(mainTableId, billIds);
        }
        this.putPageIds(this.childPageIds);
    }

    private Map<Long, HashSet<Long>> queryMainTableIdMap() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List masterIdList = (List)customParams.get("masterIdList");
        return this.queryMainTableIdMap(masterIdList, this.getView());
    }

    protected Map<Long, HashSet<Long>> queryMainTableIdMap(List<Object> masterIdList, IFormView view) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, forgid, fnumber, fassetunitid, fisinitialcard from t_fa_card_real where fsourceflag = 'INITLEASECONTRACT' and", new Object[0]);
        sqlBuilder.appendIn("fsrcbillid ", masterIdList);
        sqlBuilder.append("group by fid, forgid, fnumber, fassetunitid, fsrcbillid, fisinitialcard ", new Object[0]);
        sqlBuilder.append("order by fid ", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)"LeaseContractInitListPlugin", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
        if (dataSet.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"LeaseContractInitTrackDownEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return Collections.emptyMap();
        }
        HashMap<String, Integer> numberAndCount = new HashMap<String, Integer>(masterIdList.size());
        HashMap<Long, Set<String>> orgAndInitCardNumber = new HashMap<Long, Set<String>>(masterIdList.size());
        HashMap<String, Long> showInitRealCardData = new HashMap<String, Long>(masterIdList.size());
        HashMap<Long, Set<String>> orgAndCardNumber = new HashMap<Long, Set<String>>(masterIdList.size());
        HashMap<String, Long> showRealCardData = new HashMap<String, Long>(masterIdList.size());
        for (Row row : dataSet) {
            Long orgId = row.getLong("forgid");
            String number = row.getString("fnumber");
            Integer step = (Integer)numberAndCount.get(number);
            if (step != null && step != 1) continue;
            String isInitialCard = row.getString("fisinitialcard");
            if ("1".equals(isInitialCard)) {
                showInitRealCardData.put(number, row.getLong("fid"));
                Set initCardNumbers = orgAndInitCardNumber.computeIfAbsent(orgId, k -> new HashSet(masterIdList.size()));
                initCardNumbers.add(number);
            } else {
                showRealCardData.put(number, row.getLong("fid"));
                Set cardNumbers = orgAndCardNumber.computeIfAbsent(orgId, k -> new HashSet(masterIdList.size()));
                cardNumbers.add(number);
            }
            step = step == null ? 1 : 2;
            numberAndCount.put(number, step);
        }
        HashMap<Long, HashSet<Long>> map = new HashMap<Long, HashSet<Long>>(masterIdList.size());
        ConvertDataService reader = new ConvertDataService();
        if (!showInitRealCardData.isEmpty()) {
            this.realCardFindFinCard(map, reader, "fa_initcard_real", showInitRealCardData, "fa_initcard_fin", orgAndInitCardNumber);
        }
        if (!showRealCardData.isEmpty()) {
            this.realCardFindFinCard(map, reader, "fa_card_real", showRealCardData, "fa_card_fin", orgAndCardNumber);
        }
        return map;
    }

    private void realCardFindFinCard(Map<Long, HashSet<Long>> map, ConvertDataService reader, String realEntry, Map<String, Long> showRealCardData, String finEntry, Map<Long, Set<String>> orgAndCardNumber) {
        TableDefine realCardTableDefine = reader.loadTableDefine(realEntry, realEntry);
        Long realCardTableId = realCardTableDefine.getTableId();
        HashSet<Long> realCards = new HashSet<Long>(showRealCardData.values());
        map.put(realCardTableId, realCards);
        TableDefine finCardTableDefine = reader.loadTableDefine(finEntry, finEntry);
        Long finCardTableId = finCardTableDefine.getTableId();
        for (Map.Entry<Long, Set<String>> orgAndNumber : orgAndCardNumber.entrySet()) {
            Long orgId = orgAndNumber.getKey();
            Set<String> numbers = orgAndNumber.getValue();
            QFilter[] qFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("number", "in", numbers), new QFilter("period", "=", (Object)"bizperiod", true), new QFilter("originaldata", "=", (Object)false)};
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])qFilters);
            if (finCards.isEmpty()) continue;
            HashSet finCardIds = (HashSet)finCards.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            HashSet<Long> finIds = map.get(finCardTableId);
            if (finIds == null) {
                map.put(finCardTableId, finCardIds);
                continue;
            }
            finIds.addAll(finCardIds);
        }
    }

    private void showList(Long mainTableId, HashSet<Long> billIds) {
        TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)mainTableId);
        if (tableDefine == null) {
            return;
        }
        String entityNumber = tableDefine.getEntityNumber();
        if (billIds.size() == 1) {
            BillShowParameter showParameter = this.createBillShowParameter(entityNumber, billIds.iterator().next());
            this.getView().showForm((FormShowParameter)showParameter);
            this.childPageIds.put(entityNumber, showParameter.getPageId());
            return;
        }
        ListShowParameter showParameter = this.createShowParameter(entityNumber, billIds);
        if (showParameter != null) {
            this.getView().showForm((FormShowParameter)showParameter);
            this.childPageIds.put(entityNumber, showParameter.getPageId());
        }
    }

    private BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.setPkId((Object)billId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s-\u67e5\u770b", (String)"LeaseContractInitTrackDownEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), mainType.getDisplayName().toString()));
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(KEY_TAB_BILLS);
        showParameter.setHasRight(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    protected ListShowParameter createShowParameter(String entityNumber, HashSet<Long> billIds) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(KEY_TAB_BILLS);
        showParameter.getCustomParams().put("trackdowninitrealcard", true);
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.setHasRight(true);
        showParameter.setSendToClient(true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }
}

