/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.enums.lease.LeaseContractSourceType;

public class LeaseContractNewListPlugin
extends AbstractListPlugin {
    private static final String KEY_RENT_SETTLE = "rentsettle";
    private static final String KEY_RENT_UN_SETTLE = "rentunsettle";
    private static final String PAGE_CACHE_SELECTED_DATA = "selectedData";

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        QFilter newContractFilter = new QFilter("sourcetype", "=", (Object)LeaseContractSourceType.A.name());
        QFilter initContractFilter = new QFilter("sourcetype", "=", (Object)LeaseContractSourceType.B.name()).and(new QFilter("status", "=", (Object)"C"));
        filters.add(newContractFilter.or(initContractFilter));
        filters.add(new QFilter("isbak", "=", (Object)false));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing doNothing;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (args.getSource() instanceof Donothing && (KEY_RENT_SETTLE.equals(operateKey = (doNothing = (Donothing)source).getOperateKey()) || KEY_RENT_UN_SETTLE.equals(operateKey))) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            ArrayList<Object> selectedContractIdList = new ArrayList<Object>(10);
            for (ListSelectedRow row : listSelectedData) {
                Object pk = row.getPrimaryKeyValue();
                selectedContractIdList.add(pk);
            }
            String selectedDataJson = SerializationUtils.toJsonString(selectedContractIdList);
            this.getPageCache().put(PAGE_CACHE_SELECTED_DATA, selectedDataJson);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Donothing doNothing;
        String operateKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (args.getSource() instanceof Donothing && (KEY_RENT_SETTLE.equals(operateKey = (doNothing = (Donothing)source).getOperateKey()) || KEY_RENT_UN_SETTLE.equals(operateKey))) {
            String selectedDataJson = this.getPageCache().get(PAGE_CACHE_SELECTED_DATA);
            List selectedData = SerializationUtils.fromJsonStringToList((String)selectedDataJson, Object.class);
            ListSelectedRowCollection selectedRowList = new ListSelectedRowCollection();
            for (Object selectedPk : selectedData) {
                ListSelectedRow selectedRow = new ListSelectedRow(selectedPk);
                selectedRowList.add((Object)selectedRow);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.putSelectedRows(selectedRowList);
            billList.refresh();
            this.getPageCache().remove(PAGE_CACHE_SELECTED_DATA);
        }
    }
}

