/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.validator.lease.LeaseContractValidator;

public class LeaseContractOperPlugin
extends AbstractFormPlugin {
    private static final String KEY_PUSH = "push";
    private static final String KEY_RENT_SETTLE = "rentsettle";
    private static final String KEY_QUERY_RENT_SETTLE = "queryrentsettle";
    private static final String KEY_QUERY_INTEREST_DETAIL = "queryinterestdetail";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject leaseContract = this.getModel().getDataEntity();
        ArrayList<DynamicObject> leaseContracts = new ArrayList<DynamicObject>(4);
        leaseContracts.add(leaseContract);
        List errorInfo = null;
        switch (operateKey) {
            case "push": {
                errorInfo = LeaseContractValidator.validateForPush(leaseContracts);
                break;
            }
            case "queryrentsettle": 
            case "queryinterestdetail": {
                errorInfo = LeaseContractValidator.validateForLinkQuery(leaseContracts);
                break;
            }
        }
        if (errorInfo != null && !errorInfo.isEmpty()) {
            args.setCancel(true);
            this.getView().showTipNotification(String.join((CharSequence)" ", errorInfo));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "rentsettle": {
                OperationResult opResult = args.getOperationResult();
                if (opResult == null || !opResult.isSuccess()) break;
                this.showRentSettleList();
                break;
            }
            case "queryrentsettle": {
                this.showRentSettleList();
                break;
            }
            case "queryinterestdetail": {
                this.showInterestDetail();
                break;
            }
        }
    }

    private void showRentSettleList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject leaseContract = this.getModel().getDataEntity();
        ArrayList<Long> contractIdList = new ArrayList<Long>(1);
        long leaseContractId = leaseContract.getLong("id");
        contractIdList.add(leaseContractId);
        parameter.getCustomParams().put("contractIdList", SerializationUtils.toJsonString(contractIdList));
        ArrayList<String> orgIdList = new ArrayList<String>(1);
        long orgId = leaseContract.getLong("org_id");
        orgIdList.add(Long.toString(orgId));
        parameter.getCustomParams().put("leaseContractOrgIdList", orgIdList);
        parameter.setBillFormId("fa_lease_rent_settle");
        parameter.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showInterestDetail() {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("fa_interest_detail");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setHasRight(Boolean.TRUE.booleanValue());
        long settleShareSrcId = (Long)this.getModel().getValue("settlesharesrcid");
        long contractId = settleShareSrcId != 0L ? settleShareSrcId : (Long)this.getModel().getDataEntity().getPkValue();
        QFilter filter = new QFilter("leasecontract", "=", (Object)contractId);
        DynamicObject interestDetail = QueryServiceHelper.queryOne((String)"fa_interest_detail", (String)"id", (QFilter[])new QFilter[]{filter});
        param.setPkId((Object)interestDetail.getLong("id"));
        this.getView().showForm((FormShowParameter)param);
    }
}

