/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class PayPlanToPublicReimburseBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(PayPlanToPublicReimburseBotpPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("curlease.id");
        e.addSrcField("curlease.number");
        e.addSrcField("curlease.currency");
        e.addSrcField("curlease.org");
        e.addSrcField("curlease.assetunit");
        e.addSrcField("tax");
        e.addSrcField("plan_invoicetype");
    }

    public void initVariable(InitVariableEventArgs e) {
        super.initVariable(e);
        AbstractConvertServiceArgs convertArgs = e.getConvertArgs();
        PushArgs pushArgs = (PushArgs)convertArgs;
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        DynamicObjectCollection collection = (DynamicObjectCollection)user.get("entryentity");
        List mainJob = collection.stream().filter(dyn -> !dyn.getBoolean("ispartjob")).collect(Collectors.toList());
        if (mainJob.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u4e3b\u90e8\u95e8\u3002", (String)"PayPlanToPublicReimburseBotpPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject mainDept = (DynamicObject)mainJob.get(0);
        DynamicObject mainOrg = mainDept.getDynamicObject("dpt");
        Long orgId = mainOrg.getLong("id");
        Long companyId = PayPlanToPublicReimburseBotpPlugin.initCompanyByDept(orgId);
        if (companyId == null || companyId.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"PayPlanToPublicReimburseBotpPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        log.info("\u5355\u636e\u8f6c\u6362\u9ed8\u8ba4\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7={}", (Object)companyId);
        pushArgs.setDefOrgId(companyId);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        log.info("\u4ed8\u6b3e\u8ba1\u5212\u4e0b\u63a8\uff0c\u76ee\u6807\u5355\u6570\u91cf={}", (Object)billDataEntitys.length);
        if (billDataEntitys.length == 0) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        DynamicObjectCollection collection = (DynamicObjectCollection)user.get("entryentity");
        List mainJob = collection.stream().filter(dyn -> !dyn.getBoolean("ispartjob")).collect(Collectors.toList());
        if (mainJob.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u4e3b\u90e8\u95e8\u3002", (String)"PayPlanToPublicReimburseBotpPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject mainDept = (DynamicObject)mainJob.get(0);
        DynamicObject mainOrg = mainDept.getDynamicObject("dpt");
        Long orgId = mainOrg.getLong("id");
        Long companyId = PayPlanToPublicReimburseBotpPlugin.initCompanyByDept(orgId);
        if (companyId == null || companyId.equals(0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"PayPlanToPublicReimburseBotpPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        log.info("\u5355\u636e\u8f6c\u6362\u76ee\u6807\u5355\u4e3b\u7ec4\u7ec7={}", (Object)companyId);
        HashMap<Long, Object> accountFundMap = new HashMap<Long, Object>(10);
        for (ExtendedDataEntity targetEntity : billDataEntitys) {
            List srcRows = (List)targetEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            String invoiceType = "A".equals(((DynamicProperty)e.getFldProperties().get("plan_invoicetype")).getValue((Object)srcRow)) ? "1" : "0";
            targetEntity.setValue("org_id", (Object)orgId);
            targetEntity.setValue("company_id", (Object)companyId);
            targetEntity.setValue("applierpositionstr", mainDept.get("position"));
            if (targetEntity.getValue("costdept") == null) {
                targetEntity.setValue("costdept_id", (Object)orgId);
            }
            Long costCompanyId = (Long)((DynamicProperty)e.getFldProperties().get("curlease.org")).getValue((Object)srcRow);
            Object fundingCompany = null;
            if (accountFundMap.containsKey(costCompanyId)) {
                fundingCompany = accountFundMap.get(costCompanyId);
            } else {
                fundingCompany = PayPlanToPublicReimburseBotpPlugin.getFundingOrg(costCompanyId);
                accountFundMap.put(costCompanyId, fundingCompany);
            }
            if (fundingCompany != null) {
                targetEntity.setValue("paycompany_id", fundingCompany);
            }
            DynamicObjectCollection entrys = (DynamicObjectCollection)targetEntity.getValue("expenseentryentity");
            for (DynamicObject entry : entrys) {
                entry.set("is_special_invoice", (Object)invoiceType);
                if (entry.get("entrycostdept") != null) continue;
                entry.set("entrycostdept_id", (Object)orgId);
            }
            DynamicObjectCollection accountEntrys = (DynamicObjectCollection)targetEntity.getValue("accountentry");
            for (DynamicObject entry : accountEntrys) {
                DynamicObject supplier = (DynamicObject)entry.get("supplier");
                entry.set("payername", (Object)supplier.getString("name"));
                DynamicObjectCollection entryBank = (DynamicObjectCollection)supplier.get("entry_bank");
                for (DynamicObject bank : entryBank) {
                    boolean defaultBank = bank.getBoolean("isdefault_bank");
                    if (!defaultBank) continue;
                    String bankaccount = bank.getString("bankaccount");
                    entry.set("payeraccount", (Object)bankaccount);
                    String accountname = bank.getString("accountname");
                    entry.set("payeraccountname", (Object)accountname);
                    Object bankId = bank.get("bank.id");
                    entry.set("payerbank_id", bankId);
                }
            }
        }
    }

    public static Long initCompanyByDept(Long deptId) {
        Map company;
        Long companyId = null;
        try {
            String fromOrgType = "01";
            String toOrgType = "01";
            Long billTypeId = 0L;
            companyId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)deptId, (Long)billTypeId);
        }
        catch (Exception fromOrgType) {
            // empty catch block
        }
        if ((companyId == null || companyId.equals(0L)) && (company = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId)) != null && company.containsKey("id")) {
            companyId = (Long)company.get("id");
        }
        return companyId;
    }

    private static Object getFundingOrg(Long companyId) {
        boolean isAssetItself = OrgUnitServiceHelper.checkOrgFunction((Long)companyId, (String)"08");
        if (isAssetItself) {
            return companyId;
        }
        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)companyId, (boolean)false);
        if (allToOrg.size() == 1) {
            DynamicObject paycompany = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", allToOrg.get(0))});
            return paycompany.getPkValue();
        }
        DynamicObject fundingOrg = PayPlanToPublicReimburseBotpPlugin.parentNodeIsFundingOrg(companyId);
        if (fundingOrg != null) {
            return fundingOrg.getPkValue();
        }
        return null;
    }

    private static DynamicObject parentNodeIsFundingOrg(Long company) {
        DynamicObject fundingOrg = null;
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(company));
        if (directSuperiorOrg.size() != 0) {
            Long parent = (Long)directSuperiorOrg.get(company);
            boolean parentIsFundingOrg = OrgUnitServiceHelper.checkOrgFunction((Long)parent, (String)"08");
            fundingOrg = parentIsFundingOrg ? BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parent)}) : PayPlanToPublicReimburseBotpPlugin.parentNodeIsFundingOrg(parent);
        }
        return fundingOrg;
    }
}

