/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.mediate;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.enums.changemode.ChangeModeTypeEnum;

public class UpdateChangeModeFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit changeMode = (BasedataEdit)this.getControl("changemode");
        changeMode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("changemode".equals(name)) {
            ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
            List qFilters = parameter.getListFilterParameter().getQFilters();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object changeType = formShowParameter.getCustomParam("changeType");
            String type = "0".equals(String.valueOf(changeType)) ? ChangeModeTypeEnum.REDUCE.getValue() : ChangeModeTypeEnum.ADD.getValue();
            qFilters.add(new QFilter("type", "=", (Object)type));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("btnok".equals(operateKey)) {
            Object changeModeObj = this.getModel().getValue("changemode");
            if (changeModeObj == null) {
                args.setCancel(Boolean.TRUE.booleanValue());
                HashMap<String, Object> returnData = new HashMap<String, Object>(2);
                returnData.put("success", Boolean.TRUE);
                String message = ResManager.loadKDString((String)"\u7ef4\u62a4\u6210\u529f\u3002", (String)"UpdateChangeModeFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                returnData.put("message", message);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                return;
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object ids = parameter.getCustomParam("ids");
            op.getOption().setVariableValue("ids", String.valueOf(ids));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("btnok".equals(operateKey)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(2);
            OperationResult result = args.getOperationResult();
            boolean success = result.isSuccess();
            if (success) {
                returnData.put("success", Boolean.TRUE);
                String message = ResManager.loadKDString((String)"\u7ef4\u62a4\u6210\u529f\u3002", (String)"UpdateChangeModeFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                returnData.put("message", message);
            } else {
                List msg = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.toList());
                if (msg.size() == 0) {
                    msg.add(result.getMessage());
                }
                String errInfo = String.join((CharSequence)" ", msg);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7ef4\u62a4\u5931\u8d25\uff0c%s\u3002", (String)"UpdateChangeModeFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), errInfo);
                returnData.put("success", Boolean.FALSE);
                returnData.put("message", errorMsg);
            }
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

