/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.merge;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.utils.FaFormCurPeriodBizUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaMergeBillListPlugin
extends AbstractListPlugin {
    private static final String IS_CLICK_ORG = "isClickOrg";

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        FaFormPermissionUtil.filterContainerInitV2(filtercontainerinitargs, this.getPageCache(), this.getView().getPageId());
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Object sFilter = paramMap.get("filter");
        QFilter[] filters2 = null;
        if (sFilter != null) {
            QFilter filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (FilterColumn listFilter : listFilterColumns) {
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String fieldName = commFilter.getFieldName();
                if (!"mergedate".equals(fieldName)) continue;
                List mergeDateDefValues = Stream.of(filters2).filter(v -> "mergedate".equals(v.getProperty())).map(v -> df.format((Date)v.getValue())).collect(Collectors.toList());
                commFilter.setDefaultValues(mergeDateDefValues);
            }
        }
        for (FilterColumn listFilter : listFilterColumns) {
            String defaultOrgId;
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String fieldName = commFilter.getFieldName();
            if (!"org.id".equals(fieldName) && !"org.number".equals(fieldName) && !"org.name".equals(fieldName)) continue;
            String orgFilterObjId = (String)paramMap.get("org");
            if (orgFilterObjId != null) {
                defaultOrgId = orgFilterObjId;
                commFilter.setDefaultValue(defaultOrgId);
                this.getPageCache().put("org", defaultOrgId);
                continue;
            }
            String billFormID = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
            List comboItems = FaPermissionUtils.getAllEnableBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)billFormID);
            commFilter.setComboItems(comboItems);
            if (comboItems.size() <= 0) continue;
            defaultOrgId = this.getDefaultId(comboItems);
            this.getPageCache().put("org", defaultOrgId);
            if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) continue;
            commFilter.setDefaultValue(defaultOrgId);
            commFilter.setDefValue(defaultOrgId);
            if (sFilter == null) continue;
            String transOrg = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("org")).map(QFilter::getValue).map(Object::toString).reduce("", String::concat);
            commFilter.setDefaultValue(transOrg);
        }
    }

    private String getDefaultId(List<ComboItem> items) {
        long currOrgId = RequestContext.get().getOrgId();
        for (ComboItem item : items) {
            long nextId;
            if (null == item || item.getValue().length() == 0 || (nextId = Long.parseLong(item.getValue())) != currOrgId) continue;
            return Long.toString(currOrgId);
        }
        return items.get(0).getValue();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("org.id".equals(field) || "org.number".equals(field) || "org.name".equals(field)) {
            List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_mergebill");
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object sFilter = this.getView().getFormShowParameter().getCustomParams().get("filter");
        if (sFilter != null) {
            e.getQFilters().add(QFilter.fromSerializedString((String)(sFilter + "")));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        FaFormCurPeriodBizUtils.showGuideConfirm4List(evt, this.getView(), "fa_mergebill", (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        FaFormCurPeriodBizUtils.guideConfirmCallBack(messageBoxClosedEvent, this.getView());
    }
}

