/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.utils.FaAssetUnitUtils;
import kd.fi.fa.utils.FaUserUtil;

public class ApplyInfoFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changedept"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject user = (DynamicObject)this.getModel().getValue("applyuser");
        String userPicture = user.getString("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)userPicture);
        Image userImage = (Image)this.getControl("picturefield");
        userImage.setUrl(imageFullUrl);
    }

    public void afterCreateNewData(EventObject e) {
        String billno = (String)this.getModel().getValue("billno");
        if (StringUtils.isEmpty((String)billno)) {
            this.initPageShow();
        }
    }

    private void initPageShow() {
        this.getModel().setValue("applyuser", (Object)ContextUtil.getUserId());
        DynamicObject user = (DynamicObject)this.getModel().getValue("applyuser");
        String userPicture = user.getString("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)userPicture);
        Image userImage = (Image)this.getControl("picturefield");
        userImage.setUrl(imageFullUrl);
        DynamicObject dep = FaUserUtil.getFirstDeptment(user);
        if (dep == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4e3b\u90e8\u95e8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u7533\u8bf7\u3002", (String)"ApplyInfoFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        long deptId = dep.getLong("id");
        this.setCompany(deptId);
        this.getModel().setValue("department", dep.getPkValue());
        Long assetOrgId = FaAssetUnitUtils.getAssetOrg(this.getView(), deptId);
        if (assetOrgId != null && assetOrgId != 0L) {
            this.getModel().setValue("assetorg", (Object)assetOrgId);
        } else {
            this.getModel().setValue("assetorg", null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getModel().setDataChanged(false);
        IFormView view = this.getView();
        DynamicObject bill = view.getModel().getDataEntity();
        if (bill.getString("billstatus").equals(BillStatus.D.toString())) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("changedept".equals(key)) {
            ListShowParameter show = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)false, (int)2, (boolean)true);
            this.setDeptListFilter(show);
            show.setShowFilter(true);
            show.setShowQuickFilter(true);
            show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changedept"));
            this.getView().showForm((FormShowParameter)show);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection dept;
        super.closedCallBack(closedCallBackEvent);
        String callBack = closedCallBackEvent.getActionId();
        IDataModel dataModel = this.getModel();
        if ("changedept".equalsIgnoreCase(callBack) && (dept = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            dataModel.setValue("department", dept.get(0).getPrimaryKeyValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeProperty;
        super.propertyChanged(e);
        switch (changeProperty = e.getProperty().getName()) {
            case "department": {
                ChangeData changeData = e.getChangeSet()[0];
                DynamicObject newValue = (DynamicObject)changeData.getNewValue();
                Long deptId = (Long)newValue.getPkValue();
                this.setCompany(deptId);
                this.updateAssetOrg(deptId);
            }
        }
    }

    private void setDeptListFilter(ListShowParameter show) {
        DynamicObject user = (DynamicObject)this.getModel().getValue("applyuser");
        DynamicObjectCollection orgEntrys = user.getDynamicObjectCollection("entryentity");
        List deptList = orgEntrys.stream().map(dynamicObject -> (DynamicObject)dynamicObject.get("dpt")).collect(Collectors.toList());
        if (deptList.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4e3b\u90e8\u95e8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u7533\u8bf7\u3002", (String)"ApplyInfoFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        List deptIds = deptList.stream().map(dept -> (Long)dept.getPkValue()).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", deptIds);
        ListFilterParameter filterParam = show.getListFilterParameter();
        filterParam.getQFilters().add(filter);
    }

    private void setCompany(Long deptId) {
        Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        if (depParent == null || depParent.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u516c\u53f8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u7533\u8bf7\u3002", (String)"ApplyInfoFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            this.getView().close();
            return;
        }
        this.getModel().setValue("org", depParent.get("id"));
    }

    private void updateAssetOrg(Long deptId) {
        Long assetOrgId = FaAssetUnitUtils.getAssetOrg(this.getView(), deptId);
        this.getModel().setValue("assetorg", (Object)assetOrgId);
    }
}

