/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.homepage;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.ContextUtil;

public class AssetCardsFormPlugin
extends AbstractFormPlugin {
    private static final String HOVER_ASSETNAME = "hov_assetname";
    private static final String HOVER_NUMBER = "hov_number";
    private static final String HOVER_MODEL = "hov_model";
    private static final String HOVER_TIME = "hov_time";
    private static final String ASSET_NAME = "assetname";
    private static final String ASSET_IMG = "assetimg";
    private static final String ASSET_ID = "realcardid";
    private static final String ASSET_STATUS = "cardstatus";
    private static final String ASSET_UNIT = "assetunit";
    private static final String ASSET_STOREPLACE = "storeplace";
    private static final String BTN_TRANS = "btn_trans";
    private static final String BTN_DRAWBACK = "btn_drawback";
    private static final String APPLY_ASSET = "apply_asset";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{APPLY_ASSET, BTN_TRANS, BTN_DRAWBACK});
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        int index = 0;
        switch (key = source.getKey()) {
            case "apply_asset": {
                this.showBillForm(this.getView(), "fa_asset_apply", null, null, null, null);
                break;
            }
            case "btn_trans": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.showBillForm(this.getView(), "fa_asset_transfer", this.getModel().getValue(ASSET_ID, index), (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
            case "btn_drawback": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.showBillForm(this.getView(), "fa_asset_drawback", this.getModel().getValue(ASSET_ID, index), (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.loadAssetData();
    }

    private void loadAssetData() {
        List<QFilter> qFilters = this.getQfilters();
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"fa_card_real", (String)"id,assetunit,storeplace,number,assetname,model,picturefield,bizstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        LinkedList realcardIds = new LinkedList();
        Stream.of(loads).forEach(load -> realcardIds.add(load.getPkValue()));
        QFilter qCardId = new QFilter("entryentity.real_card", "in", realcardIds);
        DynamicObject[] reqs = BusinessDataServiceHelper.load((String)"fa_asset_requisition", (String)"auditdate,entryentity.real_card", (QFilter[])new QFilter[]{qCardId});
        HashMap<Long, String> id_auditdates = new HashMap<Long, String>();
        String formatStr = InteServiceHelper.getDateFormat((Long)ContextUtil.getUserId());
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        for (DynamicObject req : reqs) {
            DynamicObjectCollection entryentitys = req.getDynamicObjectCollection("entryentity");
            Date auditdate = req.getDate("auditdate");
            entryentitys.stream().forEach(entry -> {
                String dateString = "";
                if (auditdate != null) {
                    dateString = sdf.format(auditdate);
                }
                id_auditdates.put((Long)entry.getDynamicObject("real_card").getPkValue(), dateString);
            });
        }
        this.setEntry(loads, id_auditdates);
    }

    private void setEntry(DynamicObject[] loads, HashMap<Long, String> id_auditdates) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(HOVER_ASSETNAME, new Object[0]);
        vs.addField(HOVER_NUMBER, new Object[0]);
        vs.addField(HOVER_MODEL, new Object[0]);
        vs.addField(HOVER_TIME, new Object[0]);
        vs.addField(ASSET_NAME, new Object[0]);
        vs.addField(ASSET_IMG, new Object[0]);
        vs.addField(ASSET_ID, new Object[0]);
        vs.addField(ASSET_STATUS, new Object[0]);
        vs.addField(ASSET_UNIT, new Object[0]);
        vs.addField(ASSET_STOREPLACE, new Object[0]);
        int length = loads.length;
        for (int i = 0; i < length; ++i) {
            String picturefield = loads[i].getString("picturefield");
            if (StringUtils.isEmpty((String)picturefield)) {
                String rootUrl = UrlService.getDomainContextUrl();
                if (rootUrl.endsWith("/")) {
                    rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                }
                picturefield = rootUrl + "/images/pc/other/rrzc_mrtp.png";
            }
            vs.addRow(new Object[]{loads[i].getString(ASSET_NAME), loads[i].get("number"), loads[i].getString("model"), id_auditdates.get((Long)loads[i].getPkValue()), loads[i].getString(ASSET_NAME), picturefield, loads[i].getString("id"), loads[i].getString("bizstatus"), loads[i].getDynamicObject(ASSET_UNIT).getPkValue(), loads[i].getDynamicObject(ASSET_STOREPLACE).getPkValue()});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public List<QFilter> getQfilters() {
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter("headuseperson", "=", (Object)ContextUtil.getUserId()));
        qFilters.add(new QFilter("isbak", "=", (Object)false));
        qFilters.add(new QFilter("isstoraged", "=", (Object)false));
        qFilters.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return qFilters;
    }

    private void showBillForm(IFormView view, String formId, Object realcardId, DynamicObject assetunit, Object storeplaceid, Object cardstatus) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put(ASSET_ID, realcardId);
        showParameter.getCustomParams().put(ASSET_STATUS, cardstatus);
        showParameter.getCustomParams().put("assetunitid", assetunit == null ? "" : String.valueOf(assetunit.getPkValue()));
        showParameter.getCustomParams().put("storeplaceid", storeplaceid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)showParameter);
    }
}

