/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;

public class AssetApplyMobPlugin
extends AbstractMobFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"flex_asset", "btn_next", "asset_picture", "is_selected_picture"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showItem();
        this.getView().updateView();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_next": {
                if (!this.getModel().getValue("count").equals(0)) {
                    this.journalizing();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u79cd\u8d44\u4ea7\u3002", (String)"AssetApplyMobPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "flex_asset": 
            case "is_selected_picture": 
            case "asset_picture": {
                this.selectItem();
                break;
            }
        }
    }

    private void journalizing() {
        DynamicObject currentDataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection currentEntry = currentDataEntity.getDynamicObjectCollection("asset_entity");
        ArrayList<Object> assetList = new ArrayList<Object>();
        for (DynamicObject dObject : currentEntry) {
            if (!dObject.get("isselected").equals("1")) continue;
            assetList.add(dObject.get("asset_name"));
        }
        List LParam = (List)this.getView().getFormShowParameter().getCustomParam("add_asset");
        if (LParam != null && LParam.get(0).equals("add_asset")) {
            LParam.clear();
            LParam.addAll(assetList);
            this.getView().returnDataToParent((Object)LParam);
        } else {
            MobileFormShowParameter parameter = new MobileFormShowParameter();
            parameter.setFormId("fa_asset_apply_confirm_m");
            parameter.getOpenStyle().setShowType(ShowType.Floating);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fa_asset_apply_confirm_m"));
            parameter.setCustomParam("assetList", assetList);
            this.getView().showForm((FormShowParameter)parameter);
        }
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("isselected")) {
            this.countAsset();
        }
    }

    private void countAsset() {
        IDataModel model = this.getModel();
        int row = this.getModel().getEntryRowCount("asset_entity");
        int count = 0;
        for (int i = 0; i < row; ++i) {
            if (!model.getValue("isselected", i).equals("1")) continue;
            ++count;
        }
        Label labelAp = (Label)this.getView().getControl("isselected_num");
        labelAp.setText(String.valueOf(count));
        this.getModel().setValue("count", (Object)String.valueOf(count));
    }

    private void selectItem() {
        int currentrow;
        IDataModel model = this.getModel();
        String state = (String)model.getValue("isselected", currentrow = model.getEntryCurrentRowIndex("asset_entity"));
        if (state.equals("0")) {
            model.setValue("isselected", (Object)"1", currentrow);
            model.setValue("is_selected_picture", (Object)(UrlService.getDomainContextUrl() + "/icons/mobile/other/icon_radio_selected_40_40.png"), currentrow);
        } else {
            model.setValue("isselected", (Object)"0", currentrow);
            model.setValue("is_selected_picture", (Object)(UrlService.getDomainContextUrl() + "/icons/mobile/other/icon_radio_checkbox_default_40_40.png"), currentrow);
        }
    }

    private void showItem() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        new FaBaseDaoFactory();
        DynamicObject[] item = FaBaseDaoFactory.getInstance((String)"fa_asset_apply_real").query(filter);
        IDataModel model = this.getModel();
        model.deleteEntryData("asset_entity");
        int row = item.length;
        for (int i = 0; i < row; ++i) {
            model.createNewEntryRow("asset_entity");
            model.setValue("asset_name", item[i].get("asset_name"), i);
            model.setValue("asset_picture", item[i].get("asset_picture"), i);
            model.setValue("isselected", (Object)"0", i);
            model.setValue("is_selected_picture", (Object)(UrlService.getDomainContextUrl() + "/icons/mobile/other/icon_radio_checkbox_default_40_40.png"), i);
        }
    }
}

