/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.mobile;

import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.bill.IBillPlugin;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListCardView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.fi.fa.business.model.ReturnDataBean;
import kd.fi.fa.business.utils.FaFormUtils;
import kd.fi.fa.business.utils.FaMyAssetUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;

public class MyAssetTemplateFormPlugin
extends AbstractMobListPlugin
implements IBillPlugin {
    private static final Log log = LogFactory.getLog(MyAssetTemplateFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"b_search", "btnexit", "l_apply_asset", "b_batch", "b_transfer", "toinventory", "b_applyasset"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button && "b_batch".equals(((Button)evt.getSource()).getKey())) {
            final BillList billList = (BillList)this.getView().getControl("billlistap");
            List controls = billList.getItems();
            controls.stream().forEach(new Consumer<Control>(){

                @Override
                public void accept(Control t) {
                    Container container = (Container)((ListCardView)t).getItems().get(0);
                    billList.getView().setVisible(Boolean.valueOf(true), new String[]{((Control)container.getItems().get(0)).getKey()});
                }
            });
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control control = (Control)source;
            switch (control.getKey()) {
                case "b_transfer": {
                    this.showFaMyAssetBillMobForm();
                    break;
                }
                case "btnexit": {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"f_search"});
                    this.getView().updateView();
                    break;
                }
                case "toinventory": {
                    String schemeId = this.getPageCache().get("schemeid");
                    String schemeName = this.getPageCache().get("schemename");
                    this.showFaInventoryBillMobForm(schemeId, schemeName);
                    break;
                }
                case "b_search": {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"f_search"});
                    break;
                }
                case "b_applyasset": {
                    MobileFormShowParameter showParameter = new MobileFormShowParameter();
                    showParameter.setFormId("fa_assetapply_mob");
                    showParameter.getOpenStyle().setShowType(ShowType.Floating);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
            }
        }
    }

    private void showFaMyAssetBillMobForm() {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("fa_mob_assetschedule");
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "b_transfer"));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void showFaInventoryBillMobForm(String schemeId, String schemeName) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("fa_mobile_inventpage");
        mobileFormShowParameter.setCustomParam("schemeid", (Object)schemeId);
        mobileFormShowParameter.setCustomParam("schemename", (Object)schemeName);
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "toinventory"));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ReturnDataBean returnDataBean;
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof ReturnDataBean && (returnDataBean = (ReturnDataBean)returnData).getActionCode() == ReturnDataBean.ActionCode.Update) {
            MobileListShowParameter showParameter = new MobileListShowParameter();
            showParameter.setBillFormId("fa_mobile");
            showParameter.setFormId("fa_my_asset_template");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.setAppId("fa");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initScheme();
        this.updateInDoingBillCount();
    }

    private void initScheme() {
        DataSet InventoryRecords = FaInventMobUtil.queryMobileInventAll(ContextUtil.getUserId(), Boolean.TRUE, Boolean.TRUE);
        DynamicObjectCollection records = ORMUtil.toDynamicObjectCollection((DataSet)InventoryRecords, (String)"fa_inventory_record");
        if (records.size() > 0) {
            Label labSchemeName = (Label)this.getView().getControl("schemename");
            String schemeName = ResManager.loadKDString((String)"\u5f85\u76d8\u8d44\u4ea7\u6e05\u5355", (String)"MyAssetTemplateFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            labSchemeName.setText(schemeName);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"schemepanel"});
        }
    }

    private void updateInDoingBillCount() {
        Label countLab = (Label)this.getControl("lab_indoingbills");
        int count = FaMyAssetUtils.findInDoingMyAssetBillsCountByUserId((Long)ContextUtil.getUserId());
        FaFormUtils.updateCountLable((Label)countLab, (int)count);
    }
}

