/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.widget;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FapHomeUtil;

public class FaAssetCardWidgetPlugin
extends AbstractFormPlugin {
    private static final String APPLY_ASSET = "apply_asset";
    private static final String ASSET_ID = "realcardid";
    private static final String ASSET_STATUS = "cardstatus";
    private static final String ASSET_UNIT = "assetunit";
    private static final String ASSET_STOREPLACE = "storeplace";
    private static final String BTN_TRANS = "btn_trans";
    private static final String BTN_DRAWBACK = "btn_drawback";
    private static final String BTN_REPAIR = "btn_repair";
    private static final Set<Long> exitRepairRealIds = new HashSet<Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{APPLY_ASSET, BTN_TRANS, BTN_DRAWBACK, BTN_REPAIR});
        final EntryGrid cardEntry = (EntryGrid)this.getView().getControl("entryentity");
        cardEntry.addDataBindListener(new EntryGridBindDataListener(){

            public void entryGridBindData(EntryGridBindDataEvent e) {
                super.entryGridBindData(e);
                List rows = e.getRows();
                for (RowDataEntity row : rows) {
                    DynamicObject entry = row.getDataEntity();
                    if (!exitRepairRealIds.contains(entry.getDynamicObject(FaAssetCardWidgetPlugin.ASSET_ID).getLong("id"))) continue;
                    ((CardEntry)cardEntry).setChildVisible(false, row.getRowIndex(), new String[]{FaAssetCardWidgetPlugin.BTN_REPAIR});
                }
            }
        });
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (APPLY_ASSET.equals(key)) {
            this.showBillForm(this.getView(), "fa_asset_apply", null, null, null, null);
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String realcardId = ((DynamicObject)this.getModel().getValue(ASSET_ID, index)).getString("id");
        switch (key) {
            case "btn_trans": {
                this.showBillForm(this.getView(), "fa_asset_transfer", realcardId, (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
            case "btn_drawback": {
                this.showBillForm(this.getView(), "fa_asset_drawback", realcardId, (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
            case "btn_repair": {
                this.showBillForm(this.getView(), "fa_apply_repair", realcardId, (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        exitRepairRealIds.clear();
        FapHomeUtil.loadData(this.getModel());
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        List realcardid = entryentity.stream().map(v -> v.getDynamicObject(ASSET_ID).getLong("id")).collect(Collectors.toList());
        List ids = QueryServiceHelper.query((String)"fa_apply_repair", (String)Fa.dot((String[])new String[]{"entryentity", "realcard"}), (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realcardid), new QFilter("billstatus", "=", (Object)BillStatus.B).or("billstatus", "=", (Object)BillStatus.A)}).stream().map(v -> v.getLong(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toList());
        exitRepairRealIds.addAll(ids);
        int i = 0;
        for (DynamicObject entry : entryentity) {
            if (exitRepairRealIds.contains(entry.getDynamicObject(ASSET_ID).getLong("id"))) {
                cardEntry.setChildVisible(false, i, new String[]{BTN_REPAIR});
            }
            ++i;
        }
        this.getView().updateView("entryentity");
    }

    private void showBillForm(IFormView view, String formId, Object realcardId, DynamicObject assetunit, Object storeplaceid, Object cardstatus) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put(ASSET_ID, realcardId);
        showParameter.getCustomParams().put(ASSET_STATUS, cardstatus);
        showParameter.getCustomParams().put("assetunitid", assetunit == null ? "" : String.valueOf(assetunit.getPkValue()));
        showParameter.getCustomParams().put("storeplaceid", storeplaceid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)showParameter);
    }
}

