/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.repair;

import java.math.BigDecimal;
import java.text.Format;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.utils.FaUserUtil;

public class FaRepairApplyFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"changedept"});
        BasedataEdit realcard = (BasedataEdit)this.getControl("realcard");
        realcard.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("changedept".equals(key)) {
            ListShowParameter show = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)false, (int)2, (boolean)true);
            show.setShowFilter(true);
            this.setDeptFilter(show);
            show.setShowQuickFilter(true);
            show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changedept"));
            this.getView().showForm((FormShowParameter)show);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        String userPicture = applier.getString("picturefield");
        String imageTruePath = ImageUtil.getImageTruePath((String)userPicture);
        Image pictureControl = (Image)this.getControl("picturefield");
        pictureControl.setUrl(imageTruePath);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (BillStatus.C.name().equals(billStatus)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            String sign = currency.getString("sign");
            int currencyAmtprecision = currency.getInt("amtprecision");
            Label amount = (Label)this.getControl("amountap");
            BigDecimal eBallAmount = (BigDecimal)this.getModel().getValue("eballamount");
            BigDecimal parseEBallAmount = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)currency, (BigDecimal)eBallAmount);
            FormatObject fobj = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
            fobj.getCurrencyFormat().setCurrencySymbols(sign);
            fobj.getCurrencyFormat().setMinimumFractionDigits(currencyAmtprecision);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            String str = format.format(parseEBallAmount);
            amount.setText(str);
        }
        if (BillStatus.D.name().equals(billStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("changedept".equals(actionId) && (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("applierdept", returnData.get(0).getPrimaryKeyValue());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("applier", (Object)ContextUtil.getUserId());
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        DynamicObject dept = FaUserUtil.getFirstDeptment(applier);
        if (dept == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u4e3b\u90e8\u95e8\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ef4\u4fee\u62a5\u8d26\u7533\u8bf7\u3002", (String)"FaRepairApplyFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        long deptId = dept.getLong("id");
        this.setCompany(deptId);
        this.getModel().setValue("applierdept", dept.getPkValue());
        String assetUnitId = (String)showParameter.getCustomParam("assetunitid");
        if (StringUtils.isNotEmpty((String)assetUnitId)) {
            this.getModel().setValue("org", (Object)Long.parseLong(assetUnitId));
            Object realCardId = showParameter.getCustomParam("realcardid");
            if (realCardId != null) {
                IDataModel model = this.getModel();
                Long realcardId = Long.parseLong(String.valueOf(realCardId));
                String fields = Fa.comma((String[])new String[]{"headusedept", "unit", "assetamount"});
                DynamicObject realcard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)realcardId)});
                model.batchCreateNewEntryRow("entryentity", 1);
                model.setValue("realcard", realCardId, 0);
                model.setValue("headusedept", (Object)realcard.getLong("headusedept"), 0);
                model.setValue("unit", (Object)realcard.getLong("unit"), 0);
                model.setValue("assetamount", realcard.get("assetamount"), 0);
                DynamicObject mainBook = this.getMainBook(Long.parseLong(assetUnitId));
                if (mainBook != null) {
                    model.setValue("currency", mainBook.get("basecurrency"));
                    DynamicObject newPeriodFinCard = this.getNewPeriodFinCard(mainBook, realcardId);
                    if (newPeriodFinCard != null) {
                        model.setValue("originalval", newPeriodFinCard.get("originalval"), 0);
                        model.setValue("networth", newPeriodFinCard.get("networth"), 0);
                        model.setValue("netamount", newPeriodFinCard.get("netamount"), 0);
                        model.setValue("preusingamount", newPeriodFinCard.get("preusingamount"), 0);
                        model.setValue("depredamount", newPeriodFinCard.get("depredamount"), 0);
                        model.setValue("accumdepre", newPeriodFinCard.get("accumdepre"), 0);
                        model.setValue("decval", newPeriodFinCard.get("decval"), 0);
                        model.setValue("preresidualval", newPeriodFinCard.get("preresidualval"), 0);
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changeName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if ("applierdept".equals(changeName) && newValue != null) {
            long deptId = ((DynamicObject)newValue).getLong("id");
            this.setCompany(deptId);
        }
        if ("realcard".equals(changeName) && newValue != null) {
            DynamicObject newPeriodFinCard;
            DynamicObject realcard = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            model.setValue("headusedept", (Object)realcard.getLong(Fa.id((String)"headusedept")), rowIndex);
            model.setValue("unit", (Object)realcard.getLong(Fa.id((String)"unit")), rowIndex);
            model.setValue("assetamount", realcard.get("assetamount"), rowIndex);
            DynamicObject assetOrg = (DynamicObject)this.getModel().getValue("org");
            DynamicObject mainBook = this.getMainBook(assetOrg.getLong("id"));
            if (mainBook != null && (newPeriodFinCard = this.getNewPeriodFinCard(mainBook, realcard.getLong("masterid"))) != null) {
                model.setValue("originalval", newPeriodFinCard.get("originalval"), rowIndex);
                model.setValue("networth", newPeriodFinCard.get("networth"), rowIndex);
                model.setValue("netamount", newPeriodFinCard.get("netamount"), rowIndex);
                model.setValue("preusingamount", newPeriodFinCard.get("preusingamount"), rowIndex);
                model.setValue("depredamount", newPeriodFinCard.get("depredamount"), rowIndex);
                model.setValue("accumdepre", newPeriodFinCard.get("accumdepre"), rowIndex);
                model.setValue("decval", newPeriodFinCard.get("decval"), rowIndex);
                model.setValue("preresidualval", newPeriodFinCard.get("preresidualval"), rowIndex);
            }
        }
        if ("eburdenamount".equals(changeName)) {
            BigDecimal cBurdenAmount = (BigDecimal)this.getModel().getValue("cburdenamount", rowIndex);
            this.getModel().setValue("repairamount", (Object)cBurdenAmount.add((BigDecimal)newValue), rowIndex);
        }
        if ("cburdenamount".equals(changeName)) {
            BigDecimal eBurdenAmount = (BigDecimal)this.getModel().getValue("eburdenamount", rowIndex);
            this.getModel().setValue("repairamount", (Object)eBurdenAmount.add((BigDecimal)newValue), rowIndex);
        }
    }

    private void setCompany(Long deptId) {
        Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        if (depParent == null || depParent.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u516c\u53f8\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ef4\u4fee\u62a5\u8d26\u7533\u8bf7\u3002", (String)"FaRepairApplyFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            this.getView().close();
            return;
        }
        this.getModel().setValue("applierorg", depParent.get("id"));
    }

    private void setDeptFilter(ListShowParameter show) {
        DynamicObjectCollection orgentry;
        List dptIds;
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        if (applier != null && !(dptIds = (orgentry = applier.getDynamicObjectCollection("entryentity")).stream().map(v -> v.getLong("dpt.id")).collect(Collectors.toList())).isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", dptIds);
            ListFilterParameter filterParameter = show.getListFilterParameter();
            filterParameter.setFilter(qFilter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("realcard".equals(name)) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = parameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
            qFilters.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
            qFilters.add(new QFilter("isstoraged", "=", (Object)false));
            qFilters.add(new QFilter("isbak", "=", (Object)false));
            DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
            if (applier != null) {
                qFilters.add(new QFilter("headuseperson", "=", applier.get("id")));
            }
            DynamicObject assetOrg = (DynamicObject)this.getModel().getValue("org");
            qFilters.add(new QFilter("assetunit", "=", assetOrg.get("id")));
            DynamicObjectCollection cardEntries = this.getModel().getEntryEntity("entryentity");
            Set exitIds = cardEntries.stream().map(v -> v.get(Fa.dot((String[])new String[]{"realcard", "id"}))).filter(Objects::nonNull).collect(Collectors.toSet());
            DynamicObjectCollection exitRepairBills = QueryServiceHelper.query((String)"fa_apply_repair", (String)"entryentity.realcard realcard", (QFilter[])new QFilter[]{new QFilter("org", "=", assetOrg.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatus.B).or("billstatus", "=", (Object)BillStatus.A), new QFilter("billno", "!=", this.getModel().getValue("billno"))});
            Set exitRepairRealIds = exitRepairBills.stream().map(v -> v.getLong("realcard")).collect(Collectors.toSet());
            exitIds.addAll(exitRepairRealIds);
            if (!exitIds.isEmpty()) {
                qFilters.add(new QFilter("id", "not in", exitIds));
            }
        }
    }

    private DynamicObject getNewPeriodFinCard(DynamicObject mainBook, Long realCardId) {
        long depreUseId = mainBook.getLong("depreuse");
        String selectFields = Fa.comma((String[])new String[]{"id", "originalval", "networth", "netamount", "preusingamount", "depredamount", "accumdepre", "decval", "preresidualval"});
        DynamicObject curFincard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "=", (Object)realCardId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("endperiod", "=", (Object)99999999999L)});
        return curFincard;
    }

    private DynamicObject getMainBook(Long assetUnitId) {
        Long orgId = 0L;
        OrgRelationParam param = new OrgRelationParam();
        param.setFromViewType("10");
        param.setToViewType("09");
        param.setOrgId(assetUnitId.longValue());
        param.setIncludeSelf(true);
        param.setDirectViewType("fromorg");
        List orgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (!orgIds.isEmpty()) {
            orgId = (Long)orgIds.get(0);
        }
        return FaUtils.getMainBookByOrg((Long)orgId);
    }
}

