/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.restartrealbill;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.enums.ClearBizStatus;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;

public class FaRestartRealBillEditPlugin
extends FaBillBaseFormPlugin {
    private static final DBRoute faRoute = DBRoute.of((String)"fa");
    private static final String ACTION_ID = "call_back_clear";
    private static final String REMOVE_REAL_CARD_ID_SET_CACHE_KEY = "removeRealCardIdCacheSet";
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public void initialize() {
        super.initialize();
        BasedataEdit orgBaseDataEdit = (BasedataEdit)this.getControl("org");
        orgBaseDataEdit.addBeforeF7SelectListener(this::orgF7Select);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setRestartEntityVisible();
    }

    private void setRestartEntityVisible() {
        Object org = this.getModel().getValue("org");
        if (Objects.nonNull(org)) {
            long orgId = (Long)((DynamicObject)org).getPkValue();
            DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg((Long)orgId);
            if (assetBooks.size() == 1) {
                DynamicObject dynamicObject = (DynamicObject)assetBooks.get(0);
                if (dynamicObject.getBoolean("ismainbook")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"entitydepreuse"});
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"entitydepreuse"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.getView().updateView("restartentity");
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        this.setDataRange();
    }

    private void setDataRange() {
        FaBizUtils.setDate((IFormView)this.getView(), (String)"restartdate", (DateEdit)((DateEdit)this.getControl("restartdate")), (boolean)Boolean.FALSE, (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW ? 1 : 0) != 0);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        HashSet<String> realCardIds = new HashSet<String>();
        int[] rows = e.getRowIndexs();
        IDataModel model = this.getModel();
        for (int i : rows) {
            DynamicObject realCard = (DynamicObject)model.getValue("realcard", i);
            DynamicObject clearBill = (DynamicObject)model.getValue("clearbillid", i);
            if (!Objects.nonNull(realCard)) continue;
            realCardIds.add(realCard.getPkValue().toString() + "_" + clearBill.getPkValue());
        }
        String pkStr = SerializationUtils.toJsonString(realCardIds);
        this.getPageCache().put(REMOVE_REAL_CARD_ID_SET_CACHE_KEY, pkStr);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("restartentity")) {
            if (Objects.isNull(this.getPageCache().get(REMOVE_REAL_CARD_ID_SET_CACHE_KEY))) {
                return;
            }
            Set realCardIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(REMOVE_REAL_CARD_ID_SET_CACHE_KEY), Set.class);
            Set<String> removeRealCardIdSet = realCardIds.stream().map(Object::toString).collect(Collectors.toSet());
            this.getPageCache().remove(REMOVE_REAL_CARD_ID_SET_CACHE_KEY);
            this.removeOldRows(removeRealCardIdSet);
        }
    }

    private void removeOldRows(Set<String> removeRealCardIdSet) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("restartentity");
        model.beginInit();
        for (int i = 0; i < rowCount; ++i) {
            Object pk = this.getPK(i);
            if (Objects.isNull(pk) || !removeRealCardIdSet.contains(pk.toString())) continue;
            model.deleteEntryRow("restartentity", i);
            --i;
            --rowCount;
        }
        model.endInit();
        this.getView().updateView("restartentity");
    }

    private Object getPK(int index) {
        IDataModel model = this.getModel();
        String pk = null;
        Object value = model.getValue("realcard", index);
        Object clearBill = model.getValue("clearbillid", index);
        if (value instanceof DynamicObject && clearBill instanceof DynamicObject) {
            pk = ((DynamicObject)value).getPkValue().toString() + "_" + ((DynamicObject)clearBill).getPkValue().toString();
        }
        return pk;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("add_row".equals(evt.getItemKey())) {
            this.showClearDetailListF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if (ACTION_ID.equals(evt.getActionId())) {
            ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnData;
            if (returnDataList.size() == 0) {
                return;
            }
            Set<Long> clearPKSet = this.getReturnClearPKSet(returnDataList);
            DynamicObjectCollection selectedClearDetailBaseDynObjCollection = this.getClearDetailBaseDynObjCollection(clearPKSet);
            this.setValues(selectedClearDetailBaseDynObjCollection);
        }
    }

    private void setMapData(Date reStartDate, DynamicObjectCollection clearDetailBaseDynObjCollection, Map<Long, Integer> clearDetailBaseRealCard2CountMap, Map<Long, Integer> realCardId2DiffDaysMap) {
        for (DynamicObject clearDetailBaseDynObj : clearDetailBaseDynObjCollection) {
            long clearDetailBaseRealCardId = clearDetailBaseDynObj.getLong("realcard");
            Integer clearDetailBaseRealCardCount = clearDetailBaseRealCard2CountMap.get(clearDetailBaseRealCardId);
            if (Objects.isNull(clearDetailBaseRealCardCount)) {
                clearDetailBaseRealCardCount = 1;
            } else {
                Integer n = clearDetailBaseRealCardCount;
                Integer n2 = clearDetailBaseRealCardCount = Integer.valueOf(clearDetailBaseRealCardCount + 1);
            }
            clearDetailBaseRealCard2CountMap.put(clearDetailBaseRealCardId, clearDetailBaseRealCardCount);
            Date clearDate = clearDetailBaseDynObj.getDate("clearbill.cleardate");
            int diffDays = this.getDiffDays(clearDate, reStartDate);
            Integer integer = realCardId2DiffDaysMap.get(clearDetailBaseRealCardId);
            if (Objects.isNull(integer)) {
                realCardId2DiffDaysMap.put(clearDetailBaseRealCardId, diffDays);
                continue;
            }
            if (integer <= diffDays) continue;
            realCardId2DiffDaysMap.put(clearDetailBaseRealCardId, diffDays);
        }
    }

    private int getDiffDays(Date beginDate, Date endDate) {
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        return Math.abs((int)diff + 1);
    }

    private void setValues(DynamicObjectCollection selectedClearDetailBaseDynObjCollection) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject selected : selectedClearDetailBaseDynObjCollection) {
            String isClearAll;
            setter.set("entitydepreuse", (Object)selected.getLong("depreuse"), index);
            setter.set("clearbillid", (Object)selected.getLong("clearbill"), index);
            setter.set("clearbilldetailid", (Object)selected.getLong("entrysid"), index);
            setter.set("realcard", (Object)selected.getLong("realcard"), index);
            setter.set("restassetvalue", (Object)selected.getBigDecimal("assetvalue"), index);
            setter.set("restaddupdepre", (Object)selected.getBigDecimal("addupdepre"), index);
            setter.set("restdecval", (Object)selected.getBigDecimal("decval"), index);
            setter.set("restpreresidualval", (Object)selected.getBigDecimal("preresidualval"), index);
            setter.set("restarttype", (Object)selected.getString("isclearall"), index);
            setter.set("basecurrency", (Object)selected.getLong("basecurrency"), index);
            setter.set("measureunit", (Object)selected.getLong("measureunit"), index);
            setter.set("assetqty", (Object)selected.getLong("assetqty"), index);
            BigDecimal assetQty = selected.getBigDecimal("assetqty");
            if (Objects.nonNull(assetQty)) {
                if (assetQty.compareTo(BigDecimal.ONE) == 0) {
                    if ("1".equals(selected.getString("isclearall"))) {
                        setter.set("restclearqty", (Object)BigDecimal.ONE, index);
                    } else {
                        setter.set("restclearqty", (Object)BigDecimal.ZERO, index);
                    }
                } else {
                    setter.set("restclearqty", (Object)selected.getBigDecimal("clearqty"), index);
                }
            }
            if ("1".equals(isClearAll = selected.getString("isclearall"))) {
                Long clearPeriodId = selected.getLong("clearbill.clearperiod");
                setter.set("clearallperiod", (Object)clearPeriodId, index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("restartentity", setter);
        model.endInit();
        this.getView().updateView("restartentity");
    }

    private DynamicObjectCollection getClearDetailBaseDynObjCollection(Set<Long> clearPKSet) {
        String selectFields = Fa.comma((String[])new String[]{"entrysid", "clearqty", "assetvalue", "addupdepre", "decval", "preresidualval", "isclearall", "realcard", "realcard.masterid", "realcard.number", "clearbill.clearsource", "clearbill.billno", "clearbill", "depreuse", "clearbill.cleardate", "clearbill.clearperiod", "bizdate", "basecurrency", "measureunit", "assetqty"});
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT A.fentrysid FROM T_FA_CLRBILLENTRY_D A", new Object[0]);
        sqlBuilder.append(" INNER JOIN (", new Object[0]);
        sqlBuilder.append("   SELECT fid, frealcardid", new Object[0]);
        sqlBuilder.append("   FROM T_FA_CLRBILLENTRY_D", new Object[0]);
        sqlBuilder.appendIn("   WHERE fentrysid", clearPKSet.toArray());
        sqlBuilder.append(") B", new Object[0]);
        sqlBuilder.append(" ON A.fid = B.fid", new Object[0]);
        sqlBuilder.append(" WHERE A.frealcardid = B.frealcardid", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)faRoute, (SqlBuilder)sqlBuilder);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long fEntrySid = Long.parseLong(row.get("fentrysid").toString());
            clearPKSet.add(fEntrySid);
        }
        return QueryServiceHelper.query((String)"fa_cleardetail_base", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("entrysid", "in", clearPKSet)});
    }

    private Set<Long> getReturnClearPKSet(ListSelectedRowCollection listSelectedRows) {
        HashSet<Long> clearIds = new HashSet<Long>();
        for (ListSelectedRow row : listSelectedRows) {
            clearIds.add(Long.parseLong(row.getPrimaryKeyValue().toString()));
        }
        return clearIds;
    }

    private void showClearDetailListF7() {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"fa_clear_basedata", (boolean)true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_ID));
        List<QFilter> selectFilterList = this.getSelectFilter();
        if (CollectionUtils.isEmpty(selectFilterList)) {
            return;
        }
        para.getListFilterParameter().getQFilters().addAll(selectFilterList);
        para.setHasRight(Boolean.TRUE.booleanValue());
        para.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)para);
    }

    private List<QFilter> getSelectFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        DynamicObject mainAssetBookDynObj = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)Fa.comma((String[])new String[]{"depreuse", "periodtype"}));
        if (Objects.isNull(mainAssetBookDynObj)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaReStartRealBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        long depUseId = mainAssetBookDynObj.getLong("depreuse");
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("restartentity");
        Set needRemoveClearDetailIdSet = entryEntity.stream().filter(v -> Objects.nonNull(v.get("clearbilldetailid"))).map(v -> v.getDynamicObject("clearbilldetailid").getLong("id")).collect(Collectors.toSet());
        Date reStartDate = (Date)this.getModel().getValue("restartdate");
        if (Objects.isNull(reStartDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8bb0\u8d26\u65e5\u671f\u3002", (String)"FaReStartRealBillEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        DynamicObject periodDynamic = FaUtils.getPeriodByDate((Date)reStartDate, (long)mainAssetBookDynObj.getLong("periodtype"));
        String year = periodDynamic.getString("periodyear");
        Date startDate = this.getYearFirstDay(year);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("clearbill.billstatus", "=", (Object)BillStatus.C));
        qFilterList.add(new QFilter("clearbill.clearsource", "not in", this.getNotRestartClearSrc()));
        qFilterList.add(new QFilter("clearbill.org", "=", (Object)orgId));
        qFilterList.add(new QFilter("depreuse", "=", (Object)depUseId));
        qFilterList.add(new QFilter("clearbill.cleardate", ">=", (Object)startDate));
        qFilterList.add(new QFilter("clearbill.cleardate", "<=", (Object)reStartDate));
        qFilterList.add(new QFilter("bizstatus", "=", (Object)ClearBizStatus.READY));
        if (needRemoveClearDetailIdSet.size() > 0) {
            qFilterList.add(new QFilter("entrysid", "not in", needRemoveClearDetailIdSet));
        }
        return qFilterList;
    }

    private Date getYearFirstDay(String year) {
        try {
            return FORMAT.parse(year + "-01-01");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Set<FaClearSourceEnum> getNotRestartClearSrc() {
        HashSet<FaClearSourceEnum> unDisposalClearSrc = new HashSet<FaClearSourceEnum>(5);
        unDisposalClearSrc.add(FaClearSourceEnum.INVENTORY_LOSS);
        unDisposalClearSrc.add(FaClearSourceEnum.DISPATCH);
        unDisposalClearSrc.add(FaClearSourceEnum.LEASE_TERMINATION);
        unDisposalClearSrc.add(FaClearSourceEnum.SPLIT);
        unDisposalClearSrc.add(FaClearSourceEnum.MERGE);
        return unDisposalClearSrc;
    }

    private void orgF7Select(BeforeF7SelectEvent evt) {
        List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_restartrealbill", (String)"47156aff000000ac");
        QFilter idFilter = new QFilter("id", "in", (Object)orgIds);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(idFilter);
    }

    private Date getBizDate(DynamicObject org) {
        Date endDate;
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)org.getLong("id"));
        if (Objects.nonNull(mainBook)) {
            endDate = (Date)mainBook.get("enddate");
            if (Objects.isNull(endDate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8d26\u7c3f\u7684\u5f00\u59cb\u671f\u95f4\u3002", (String)"FaReStartRealBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"FaReStartRealBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        Date bizDate = DateUtil.stripTime((Date)endDate);
        return bizDate;
    }
}

