/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.restartrealbill;

import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaPermissionUtils;

public class FaRestartRealListPlugin
extends AbstractListPlugin {
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String key = args.getFieldName();
        if ("org.id".equalsIgnoreCase(key)) {
            List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_restartrealbill", (String)"47156aff000000ac");
            args.getCustomQFilters().add(new QFilter("id", "in", (Object)orgIds));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        int rowIndex = args.getRowIndex();
        if ("clearbillid_billno".equalsIgnoreCase(fieldName)) {
            args.setCancel(true);
            this.showClearForm(rowIndex);
        } else if ("realcard_number".equals(fieldName)) {
            args.setCancel(true);
            this.showRealCardForm(rowIndex);
        }
    }

    private void showRealCardForm(int rowIndex) {
        BillList billList = (BillList)this.getControl("billlistap");
        Object entryId = billList.getCurrentListAllRowCollection().get(rowIndex).getEntryPrimaryKeyValue();
        Object id = billList.getCurrentListAllRowCollection().get(rowIndex).getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fa_restartrealbill");
        DynamicObjectCollection dynObjCollection = dynamicObject.getDynamicObjectCollection("restartentity");
        String realCardPk = "";
        for (DynamicObject entry : dynObjCollection) {
            DynamicObject realCard;
            if (!entryId.toString().equals(String.valueOf(entry.getPkValue())) || !Objects.nonNull(realCard = entry.getDynamicObject("realcard"))) continue;
            realCardPk = String.valueOf(realCard.getPkValue());
        }
        if (Objects.isNull(realCardPk)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5b9e\u7269\u5361\u7247\uff0c\u8df3\u8f6c\u5931\u8d25\u3002", (String)"FaRestartRealListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.setFormId("fa_card_real");
        param.setPkId((Object)realCardPk);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showClearForm(int rowIndex) {
        BillList billList = (BillList)this.getControl("billlistap");
        Object entryId = billList.getCurrentListAllRowCollection().get(rowIndex).getEntryPrimaryKeyValue();
        Object id = billList.getCurrentListAllRowCollection().get(rowIndex).getPrimaryKeyValue();
        QFilter idFilter = new QFilter("id", "=", id);
        QFilter entryFilter = new QFilter("restartentity.id", "=", entryId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fa_restartrealbill", (String)"id,restartentity,restartentity.clearbillid", (QFilter[])new QFilter[]{idFilter, entryFilter});
        Long clearBillId = dynamicObject.getLong("restartentity.clearbillid");
        BillShowParameter param = new BillShowParameter();
        param.setFormId("fa_clearbill");
        param.setPkId((Object)clearBillId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if ("fa_new_depre".equals(this.getView().getFormShowParameter().getParentFormId())) {
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            String orgId = "10000";
            for (QFilter qFilter : qFilters) {
                if (!"org".equals(qFilter.getProperty())) continue;
                orgId = qFilter.getValue().toString();
            }
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn column : commonFilterColumns) {
                if ("org.id".equals(column.getFieldName())) {
                    column.setDefaultValue(orgId);
                    continue;
                }
                if (!"billstatus".equals(column.getFieldName())) continue;
                column.setDefaultValues(new Object[]{"A", "B"});
            }
        }
    }
}

