/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;
import kd.fi.fa.inventory.mobile.bean.Scheme;

public class FaInvenotryScanPCPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(FaInvenotryScanPCPlugin.class);
    private static String inventoryReportTable = "t_fa_inventory_record";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        String barcode = String.valueOf(this.getModel().getValue("barcodetext"));
        if (propName.equals("barcodetext") && !StringUtils.isEmpty((String)barcode)) {
            this.updateRecord(barcode);
            this.getModel().setValue("barcodetext", (Object)"");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)"refresh");
    }

    private void updateRecord(String barCode) {
        Scheme scheme = FaInventMobUtil.getLatestSchemeId(ContextUtil.getUserId());
        if (scheme != null) {
            Long schemeId = scheme.getSchemeId();
            QFilter qChecker = new QFilter("realcard.headuseperson", "=", (Object)ContextUtil.getUserId());
            log.info("FaInvenotryScanPCPlugin\u7528\u6237\u7684\u5224\u65ad\u6761\u4ef6-----qChecker--------------" + qChecker.toString());
            QFilter qSchemeId = new QFilter("inventschemeentry", "=", (Object)schemeId);
            log.info("FaInvenotryScanPCPlugin\u76d8\u70b9\u65b9\u6848\u7684\u5224\u65ad\u6761\u4ef6-----schemeId-------------" + schemeId.toString());
            QFilter qBarCode = new QFilter("realcard.barcode", "=", (Object)barCode);
            DynamicObject assetInventory = BusinessDataServiceHelper.loadSingle((String)"fa_inventory_record", (String)"inventorystate,difference,realcard.barcode", (QFilter[])new QFilter[]{qChecker, qSchemeId, qBarCode});
            if (assetInventory == null) {
                return;
            }
            Long recordId = (Long)assetInventory.getPkValue();
            boolean status = FaInvenotryScanPCPlugin.updateRecordSuccess(recordId);
            if (!status) {
                log.info("\u6267\u884csql,\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25!----" + barCode);
                return;
            }
        }
    }

    private static boolean updateRecordSuccess(Object recordId) {
        String sql = "update " + inventoryReportTable + " set finventorystate = 'A',finventoryway = 'A',finventoryquantity = 1,finventorytime = ?,fdifference = 1-fbookquantity where finventoryuser = '" + ContextUtil.getUserId() + "' and fid = '" + recordId + "'";
        log.info("----------------\u66f4\u65b0\u8bed\u53e5sql\uff1a" + sql);
        return DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{new java.sql.Date(new Date().getTime())});
    }

    public void afterCreateNewData(EventObject e) {
        TextEdit textEdit = (TextEdit)this.getControl("barcodetext");
        textEdit.setFocus(true);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"clearbtn"});
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "clearbtn": {
                TextEdit textEdit = (TextEdit)this.getControl("barcodetext");
                textEdit.setText("");
                break;
            }
        }
    }
}

