/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.barcode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.inventory.barcode.UpgradeParam;
import org.jbarcode.JBarcode;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.paint.EAN13TextPainter;
import org.jbarcode.paint.WidthCodedPainter;

public class FaInvenotryBarUpgradePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FaInvenotryBarUpgradePlugin.class);
    private static final String FAST_MODE = "fastmode";
    private static final String ORG = "org";
    private static final String REAL_CARD = "realcard";
    private static final String TYPE = "type";
    private static final String UPDATE_BTN = "updatebtn";
    private static final String OLD_UPDATE_BTN = "oldupdatebtn";
    private static final String CONFIRM_CALL_BACK_ID = "confirmCallBack";
    private static final int BATCH_NUM = 1000;
    private static final DBRoute DB_ROUTE = new DBRoute("fa");
    private static final String UPDATE_BARCODE = "update t_fa_card_real set fbarcode = ? where fmasterid = ?;";
    private static final String INSERT_GRADE_LOG_ENTRY = "insert into t_fa_barcode_upgrade_rec(fid, fentryid, fseq, frealcardid, foldbarcode, fnewbarcode) values (?, ?, ?, ?, ?, ?);";
    private static final String UPDATE_LOG_ERR_STATUS = "update t_fa_barcode_upgrade_log set fstatus = 'C', fenddate = ?, ferrmsg_tag = ? where fid = ?;";
    private static final String UPDATE_LOG_SUCCESS_STATUS = "update t_fa_barcode_upgrade_log set fstatus = 'B', fenddate = ? where fid = ?;";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{UPDATE_BTN, OLD_UPDATE_BTN});
        ((BasedataEdit)this.getControl(REAL_CARD)).addBeforeF7SelectListener(this::realCardF7Filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (FAST_MODE.equals(propName)) {
            boolean fastMode = (Boolean)this.getModel().getValue(FAST_MODE);
            if (fastMode) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f00\u542f\u9ad8\u6027\u80fd\u6a21\u5f0f\u540e\uff0c\u53ea\u4f1a\u6709\u4e00\u4e2a\u7f16\u7801\u89c4\u5219\u751f\u6548\uff0c\u8bf7\u4e0d\u8981\u5728\u7f16\u7801\u89c4\u5219\u4e2d\u53d6\u4e1a\u52a1\u5b57\u6bb5\u3002", (String)"FaInvenotryBarUpgradePlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u679c\u9009\u62e9\u4e86\u7ec4\u7ec7\uff0c\u8bf7\u4fdd\u8bc1\u7ec4\u7ec7\u5185\u53ea\u6709\u4e00\u4e2a\u53ef\u7528\u7684\u6761\u5f62\u7801\u7f16\u7801\u89c4\u5219\u3002\r\n\u5982\u679c\u672a\u9009\u62e9\u7ec4\u7ec7\uff0c\u8bf7\u4fdd\u8bc1\u5168\u96c6\u56e2\u53ea\u6709\u4e00\u4e2a\u53ef\u7528\u7684\u6761\u5f62\u7801\u7f16\u7801\u89c4\u5219\u3002", (String)"FaInvenotryBarUpgradePlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            }
        } else if (ORG.equals(propName)) {
            this.getModel().setValue(REAL_CARD, null);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (UPDATE_BTN.equals(key)) {
            boolean fastMode = (Boolean)this.getModel().getValue(FAST_MODE);
            String msg = fastMode ? ResManager.loadKDString((String)"\u60a8\u5df2\u5f00\u542f\u9ad8\u6027\u80fd\u6a21\u5f0f\uff0c\u8bf7\u786e\u4fdd\u6709\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"FaInvenotryBarUpgradePlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u60a8\u672a\u5f00\u542f\u9ad8\u6027\u80fd\u6a21\u5f0f\uff0c\u5347\u7ea7\u8fc7\u7a0b\u53ef\u80fd\u8f83\u6162\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FaInvenotryBarUpgradePlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CONFIRM_CALL_BACK_ID, (IFormPlugin)this));
        } else if (OLD_UPDATE_BTN.equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            QFilter qorg = null;
            if (org != null) {
                qorg = new QFilter("assetunit", "=", org.getPkValue());
            }
            this.upGradeAndExecuteSql(qorg);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (CONFIRM_CALL_BACK_ID.equals(callBackId) && MessageBoxResult.Yes == evt.getResult()) {
            QFilter filter = null;
            MulBasedataDynamicObjectCollection realCards = (MulBasedataDynamicObjectCollection)this.getModel().getValue(REAL_CARD);
            if (realCards == null || realCards.isEmpty()) {
                Object orgId;
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
                if (org != null && (orgId = org.getPkValue()) != null) {
                    filter = new QFilter("assetunit", "=", orgId);
                }
            } else {
                Object[] realCardIds = realCards.stream().map(v -> v.getLong("fbasedataid_id")).toArray();
                filter = new QFilter("id", "in", (Object)realCardIds);
            }
            this.upgradeAndExecuteSql(filter);
        }
    }

    private void upgradeAndExecuteSql(QFilter filter) {
        long logId = this.createNewUpgradeLog();
        logger.info("\u521b\u5efa\u6761\u5f62\u7801\u5347\u7ea7\u65e5\u5fd7\u6210\u529f\uff0c\u8fd4\u56de\u65e5\u5fd7id\uff1a{}", (Object)logId);
        try {
            this.upgrade(filter, logId);
            logger.info("\u6761\u5f62\u7801\u5347\u7ea7\u7a0b\u5e8f\u6267\u884c\u5b8c\u6bd5");
        }
        catch (Exception e) {
            logger.error("\u6761\u5f62\u7801\u5347\u7ea7\u7a0b\u5e8f\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String stackTrace = Fa.fetchStackTrace((Exception)e);
            Object[] param = new Object[]{new Date(), stackTrace, logId};
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)DB_ROUTE, (String)UPDATE_LOG_ERR_STATUS, (Object[])param);
                }
                catch (Exception e2) {
                    h.markRollback();
                    throw e2;
                }
            }
            throw e;
        }
        Object[] param = new Object[]{new Date(), logId};
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DB_ROUTE, (String)UPDATE_LOG_SUCCESS_STATUS, (Object[])param);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        logger.info(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u6570\u636e\u5b8c\u6210\u3002", (String)"FaInvenotryBarUpgradePlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u6570\u636e\u5b8c\u6210\u3002", (String)"FaInvenotryBarUpgradePlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
    }

    private long createNewUpgradeLog() {
        DynamicObject upgradeLog = BusinessDataServiceHelper.newDynamicObject((String)"fa_barcode_upgarde_log");
        upgradeLog.set("startdate", (Object)new Date());
        upgradeLog.set("operator_id", (Object)RequestContext.get().getCurrUserId());
        upgradeLog.set("status", (Object)"A");
        upgradeLog.set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
        long orgId = 0L;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            orgId = org.getLong("id");
        }
        ArrayList<Long> realCardIdList = new ArrayList(0);
        MulBasedataDynamicObjectCollection realCards = (MulBasedataDynamicObjectCollection)this.getModel().getValue(REAL_CARD);
        if (realCards != null && !realCards.isEmpty()) {
            realCardIdList = realCards.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        String type = (String)this.getModel().getValue(TYPE);
        boolean fastMode = (Boolean)this.getModel().getValue(FAST_MODE);
        UpgradeParam upgradeParam = new UpgradeParam(orgId, realCardIdList, type, fastMode);
        String upgradeParamJson = SerializationUtils.toJsonString((Object)upgradeParam);
        upgradeLog.set("upgradeparam_tag", (Object)upgradeParamJson);
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{upgradeLog});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return upgradeLog.getLong("id");
    }

    private void upgrade(QFilter filter, long logId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        filterList.add(new QFilter("isbak", "=", (Object)Boolean.FALSE));
        filterList.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.name()));
        if (filter != null) {
            filterList.add(filter);
        }
        String selectFields = Fa.comma((String[])new String[]{"masterid", "barcode"});
        DataSet realCardDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_real", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), null);
        HashMap<Long, String> batchCardMap = new HashMap<Long, String>(1000);
        DynamicObject realCardTemplate = null;
        String type = (String)this.getModel().getValue(TYPE);
        int logEntrySeq = 1;
        for (Row row : realCardDataSet) {
            String barCode = row.getString("barcode");
            if ("A".equals(type) && StringUtils.isNotEmpty((String)barCode)) continue;
            Long masterId = row.getLong("masterid");
            batchCardMap.put(masterId, barCode);
            if (realCardTemplate == null) {
                realCardTemplate = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)"fa_card_real");
                realCardTemplate.set("billnocoderule", (Object)"0");
                realCardTemplate.set("numberrule", (Object)"0");
                realCardTemplate.set("barcoderule", (Object)"1");
            }
            if (batchCardMap.size() < 1000) continue;
            this.upgradeBatch(batchCardMap, realCardTemplate, logId, logEntrySeq);
            logEntrySeq += batchCardMap.size();
            batchCardMap.clear();
        }
        if (!batchCardMap.isEmpty()) {
            this.upgradeBatch(batchCardMap, realCardTemplate, logId, logEntrySeq);
        }
    }

    private void upgradeBatch(Map<Long, String> batchCardMap, DynamicObject realCardTemplate, long logId, int logEntrySeq) {
        boolean fastMode = (Boolean)this.getModel().getValue(FAST_MODE);
        String[] batchBarCode4FastMode = null;
        Map<Object, DynamicObject> realCardMap = null;
        if (fastMode) {
            if (realCardTemplate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6765\u6279\u91cf\u53d6\u7f16\u7801\u7684\u5361\u7247\u4e3anull\u3002", (String)"FaInvenotryBarUpgradePlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            long assetUnitId = realCardTemplate.getLong(Fa.id((String)"assetunit"));
            batchBarCode4FastMode = kd.bos.servicehelper.coderule.CodeRuleServiceHelper.getBatchNumber((String)"fa_card_real", (DynamicObject)realCardTemplate, (String)String.valueOf(assetUnitId), (int)batchCardMap.size());
            if (batchBarCode4FastMode == null || batchBarCode4FastMode.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4ece\u7f16\u7801\u89c4\u5219\u670d\u52a1\u53d6\u5230\u5bf9\u5e94\u7684\u6761\u5f62\u7801\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"FaInvenotryBarUpgradePlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject[] realCardArr = BusinessDataServiceHelper.load((Object[])batchCardMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_card_real"));
            realCardMap = Arrays.stream(realCardArr).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        }
        ArrayList<Object[]> updateBarcodeParamList = new ArrayList<Object[]>(batchCardMap.size());
        ArrayList<Object[]> insertLogEntryParamList = new ArrayList<Object[]>(batchCardMap.size());
        long[] logEntryIds = DBServiceHelper.genLongIds((String)"t_fa_barcode_upgrade_rec", (int)batchCardMap.size());
        int logEntryIdIdx = 0;
        int index4FastMode = 0;
        for (Map.Entry<Long, String> entry : batchCardMap.entrySet()) {
            String newBarCode;
            Long masterId = entry.getKey();
            String oldBarcode = entry.getValue();
            if (fastMode && batchBarCode4FastMode != null) {
                newBarCode = batchBarCode4FastMode[index4FastMode++];
            } else {
                DynamicObject realCard = null;
                if (realCardMap != null) {
                    realCard = realCardMap.get(masterId);
                }
                if (realCard == null) continue;
                realCard.set("billnocoderule", (Object)"0");
                realCard.set("numberrule", (Object)"0");
                realCard.set("barcoderule", (Object)"1");
                long assetUnitId = realCard.getLong(Fa.id((String)"assetunit"));
                newBarCode = kd.bos.servicehelper.coderule.CodeRuleServiceHelper.getNumber((String)"fa_card_real", (DynamicObject)realCard, (String)String.valueOf(assetUnitId));
                if (StringUtils.isEmpty((String)newBarCode)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4ece\u7f16\u7801\u89c4\u5219\u670d\u52a1\u53d6\u5230\u5bf9\u5e94\u7684\u6761\u5f62\u7801\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5b58\u5728\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\u3002", (String)"FaInvenotryBarUpgradePlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
            }
            updateBarcodeParamList.add(new Object[]{newBarCode, masterId});
            insertLogEntryParamList.add(new Object[]{logId, logEntryIds[logEntryIdIdx++], logEntrySeq++, masterId, oldBarcode, newBarCode});
        }
        try (TXHandle h = TX.required();){
            try {
                if (updateBarcodeParamList.size() > 0) {
                    DB.executeBatch((DBRoute)DB_ROUTE, (String)UPDATE_BARCODE, updateBarcodeParamList);
                }
                if (insertLogEntryParamList.size() > 0) {
                    DB.executeBatch((DBRoute)DB_ROUTE, (String)INSERT_GRADE_LOG_ENTRY, insertLogEntryParamList);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                logger.info(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u6570\u636e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s\u3002", (String)"FaInvenotryBarUpgradePlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)e.getMessage());
                throw e;
            }
        }
    }

    private void realCardF7Filter(BeforeF7SelectEvent evt) {
        evt.addCustomQFilter(new QFilter("isbak", "=", (Object)Boolean.FALSE));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (org != null) {
            long orgId = org.getLong("id");
            evt.addCustomQFilter(new QFilter("assetunit", "=", (Object)orgId));
        }
    }

    private void upGradeAndExecuteSql(QFilter qorg) {
        DBRoute dbRoute = new DBRoute("fa");
        DynamicObject[] realCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)"id,BarCode,org", (QFilter[])new QFilter[]{qorg});
        JBarcode localJBarcode = new JBarcode((BarcodeEncoder)EAN13Encoder.getInstance(), WidthCodedPainter.getInstance(), EAN13TextPainter.getInstance());
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(realCards.length);
        String sql = "update T_FA_CARD_REAL set FBarCode = ? where fid = ?";
        try {
            for (DynamicObject realCard : realCards) {
                SqlParameter[] params = new SqlParameter[2];
                String barCode = realCard.getString("BarCode");
                if (barCode.length() == 13) {
                    if (barCode.indexOf("-") <= -1) continue;
                    barCode = this.getBarCode(realCard);
                    params[0] = new SqlParameter("FBarCode", -9, (Object)barCode);
                    params[1] = new SqlParameter("fid", -5, (Object)realCard.getLong("id"));
                    paramsList.add(params);
                    continue;
                }
                if (barCode.length() == 12) {
                    String check = localJBarcode.calcCheckSum(barCode);
                    barCode = barCode + check;
                    params[0] = new SqlParameter("FBarCode", -9, (Object)barCode);
                    params[1] = new SqlParameter("fid", -5, (Object)realCard.getLong("id"));
                    paramsList.add(params);
                    continue;
                }
                if (barCode.length() == 0) {
                    barCode = this.getBarCode(realCard);
                    if (barCode == null) continue;
                    params[0] = new SqlParameter("FBarCode", -9, (Object)barCode);
                    params[1] = new SqlParameter("fid", -5, (Object)realCard.getLong("id"));
                    paramsList.add(params);
                    continue;
                }
                logger.info(ResManager.loadKDString((String)"\u6761\u5f62\u7801\u7684\u957f\u5ea6\u4e3a0 13 12 \u4ee5\u5916\u7684\u60c5\u51b5\uff1a%1$s\u3002", (String)"FaInvenotryBarUpgradePlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)barCode);
            }
        }
        catch (Throwable e) {
            String err = String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u5931\u8d25\uff1a%s\u3002", (String)"FaInvenotryBarUpgradePlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), e.getMessage());
            logger.info(err);
        }
        try (TXHandle h = TX.required((String)((Object)((Object)this)).getClass().getName());){
            try {
                if (paramsList.size() > 0) {
                    DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                logger.info(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u6570\u636e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$s\u3002", (String)"FaInvenotryBarUpgradePlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)e.getMessage());
            }
        }
        logger.info(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u6570\u636e\u5b8c\u6210\u3002", (String)"FaInvenotryBarUpgradePlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5b9e\u7269\u5361\u7247\u6761\u5f62\u7801\u6570\u636e\u5b8c\u6210\u3002", (String)"FaInvenotryBarUpgradePlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
    }

    private String getBarCode(DynamicObject realCard) {
        realCard.getDynamicObjectType().registerProperty("billnocoderule", String.class, (Object)"0", false);
        realCard.getDynamicObjectType().registerProperty("numberrule", String.class, (Object)"0", false);
        realCard.getDynamicObjectType().registerProperty("barcoderule", String.class, (Object)"1", false);
        realCard.set("billnocoderule", (Object)"0");
        realCard.set("numberrule", (Object)"0");
        realCard.set("barcoderule", (Object)"1");
        DynamicObject org = realCard.getDynamicObject(ORG);
        if (org == null) {
            logger.info(realCard.getPkValue() + ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u7a7a", (String)"FaInvenotryBarUpgradePlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return null;
        }
        String orgId = "" + org.getPkValue();
        String barCode = CodeRuleServiceHelper.getNumber((String)"fa_card_real", (DynamicObject)realCard, (String)orgId);
        return barCode;
    }
}

