/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.invdiffer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.TypeConverUtil;
import kd.fi.fa.utils.FaF7DeptUtils;

public class FaInventoryDifferEditPlugin
extends AbstractBillPlugIn {
    private static final String INVENTORYDIFFERTOOL = "inventorydiffertool";
    private static final String INVENTORYDIFFERADD = "inventorydifferadd";
    private static final String BATCHFILLENTRY = "batchfillentry";
    private static final String FA_INVDIFFER_SCHEME_TASK = "fa_invdiffer_scheme_task";
    private static final String CALL_BACK_KEY_INVDIFFER_INFO = "call_back_key_invdiffer_info";
    private static final String BTN_CONFIRM = "btn_confirm";
    private static final String BAR_DEL = "bar_del";
    private static final String INVENTORY_RECORDS = "number,barcode,name,model,bookquantity,inventoryquantity,difference,inventoryuser,inventorystate,inventoryway,billstate,inventorytime,reason,inventschemeentry,inventorytask,billstatus,realCard";
    private static final String FIN_CARD_PROPERTIES = "originalval,currency";
    String[] lockStirng = new String[]{"inventscheme", "billno", "inventorylossamount", "org", "billstatus"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{INVENTORYDIFFERTOOL});
        this.addClickListeners(new String[]{BTN_CONFIRM});
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"09", (Long)orgId, (boolean)true);
        HashSet orgSet = new HashSet();
        orgSet.addAll(allToOrg);
        BasedataEdit inventschemeF7 = (BasedataEdit)this.getControl("inventscheme");
        inventschemeF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstate", "=", (Object)"A"));
            filters.add(new QFilter("entryentity.assetunit", "in", (Object)orgSet));
        });
        BasedataEdit changemode = (BasedataEdit)this.getView().getControl("changemode");
        changemode.addBeforeF7SelectListener(evt -> {
            IDataModel model = this.getModel();
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            if ("A".equals(model.getValue("inventorydiffer", evt.getRow()))) {
                filters.add(new QFilter("type", "=", (Object)"ADD"));
            } else if ("B".equals(model.getValue("inventorydiffer", evt.getRow()))) {
                filters.add(new QFilter("type", "=", (Object)"REDUCE"));
            }
        });
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        BasedataEdit deptF7 = (BasedataEdit)this.getControl("headusedept");
        deptF7.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fa_invdiffererentry");
            DynamicObject selectRow = (DynamicObject)entryEntity.get(evt.getRow());
            DynamicObject assetUnit = selectRow.getDynamicObject("assetunit");
            FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(evt -> {
            List orgs = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_invdiffer", (String)"47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", (Object)orgs);
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(qFilter);
        });
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (INVENTORYDIFFERADD.equals(itemKey)) {
            this.showInventoryDifferInfoForm();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setCurrency();
    }

    public void beforeBindData(EventObject e) {
        Object value = this.getModel().getValue("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DEL});
        if (value != null) {
            String s = String.valueOf(value);
            if ("D".equals(s) || "E".equals(s)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"inventoryhandle"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inventorycancle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"trackdown"});
                this.getView().setEnable(Boolean.FALSE, this.lockStirng);
                this.getView().setEnable(Boolean.FALSE, new String[]{INVENTORYDIFFERADD, BATCHFILLENTRY});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"trackdown"});
            }
            if ("A".equals(s)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inventoryhandle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inventorycancle"});
                this.getView().setVisible(Boolean.TRUE, new String[]{BAR_DEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"inventscheme", "billno", INVENTORYDIFFERADD, BATCHFILLENTRY});
            }
            if ("B".equals(s)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"inventoryhandle"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inventorycancle"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
        if (success) {
            if ("audit".equals(operateKey)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"inventoryhandle"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"inventorycancle"});
                this.getView().setEnable(Boolean.FALSE, this.lockStirng);
            }
            if ("unaudit".equals(operateKey) || "deletetarget".equals(operateKey)) {
                this.getView().updateView();
            }
        }
    }

    private void setCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long currency = this.getMainBookCurrencyByOrgId((Long)org.getPkValue());
            if (currency == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\u4e3b\u8d26\u7c3f\u7684\u5e01\u522b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ec4\u7ec7\u662f\u5426\u4e3a\u7a7a\u6216\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6709\u8bef\u3002", (String)"FaInventoryDifferEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("currency", (Object)currency);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u7ec4\u7ec7\u4e3b\u8d26\u7c3f\u7684\u5e01\u522b\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ec4\u7ec7\u662f\u5426\u4e3a\u7a7a\u6216\u76f8\u5173\u914d\u7f6e\u662f\u5426\u6709\u8bef\u3002", (String)"FaInventoryDifferEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private Long getMainBookCurrencyByOrgId(long orgId) {
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)orgId, (String)"basecurrency");
        if (mainBook == null) {
            return 0L;
        }
        return mainBook.getLong("basecurrency");
    }

    private void showInventoryDifferInfoForm() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(FA_INVDIFFER_SCHEME_TASK);
        param.getOpenStyle().setShowType(ShowType.Modal);
        Object org = this.getModel().getDataEntity().get("org.id");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"FaInventoryDifferEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long orgId = TypeConverUtil.ObjToLong((Object)org);
        Object inventscheme = this.getModel().getDataEntity().get("inventscheme.id");
        if (inventscheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u76d8\u70b9\u65b9\u6848\u201d\u3002", (String)"FaInventoryDifferEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long inventschemeId = TypeConverUtil.ObjToLong((Object)inventscheme);
        HashMap<String, Serializable> rsMap = new HashMap<String, Serializable>();
        rsMap.put("inventscheme", inventschemeId);
        rsMap.put("org", orgId);
        DynamicObjectCollection differerentryDyns = this.getModel().getDataEntity(true).getDynamicObjectCollection("fa_invdiffererentry");
        HashSet<Object> taskIds = new HashSet<Object>();
        for (DynamicObject dynamicObject : differerentryDyns) {
            if (dynamicObject.getDynamicObject("inventorytask") == null) continue;
            taskIds.add(dynamicObject.getDynamicObject("inventorytask").getPkValue());
        }
        rsMap.put("inventorytask", taskIds);
        param.setCustomParam("jsonstringschemetaskform", (Object)SerializationUtils.toJsonString(rsMap));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_KEY_INVDIFFER_INFO));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if (CALL_BACK_KEY_INVDIFFER_INFO.equals(key)) {
            this.setInvdiffererentry(evt);
        }
    }

    private void setInvdiffererentry(ClosedCallBackEvent evt) {
        List returnDatas = (List)evt.getReturnData();
        if (returnDatas == null) {
            return;
        }
        ArrayList<Map<String, Object>> allTasks = new ArrayList<Map<String, Object>>();
        for (Map data : returnDatas) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("billstate", "=", (Object)"C"));
            qFilters.add(new QFilter("inventorystate", "!=", (Object)"C"));
            qFilters.add(new QFilter("inventschemeentry", "=", data.get("inventscheme")));
            qFilters.add(new QFilter("inventorytask", "=", data.get("inventorytask")));
            DynamicObject[] inventoryTasks = BusinessDataServiceHelper.load((String)"fa_inventory_record", (String)INVENTORY_RECORDS, (QFilter[])qFilters.toArray(new QFilter[0]));
            Arrays.stream(inventoryTasks).forEach(r -> {
                HashMap<String, Object> rsMap = new HashMap<String, Object>();
                rsMap.put("dyn", r);
                rsMap.put("assetunit", data.get("assetunit"));
                allTasks.add(rsMap);
            });
        }
        this.fillInvdiffererentry(allTasks);
    }

    public void fillInvdiffererentry(List<Map<String, Object>> allTasks) {
        int differ;
        BigDecimal differquantity;
        BigDecimal inventoryquantity;
        BigDecimal bookquantity;
        DynamicObject dyn;
        int currencyInt = ((DynamicObject)this.getModel().getValue("currency")).getInt("amtprecision");
        this.getModel().deleteEntryData("fa_invdiffererentry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        Iterator<Map<String, Object>> iteratorTask = allTasks.iterator();
        while (iteratorTask.hasNext()) {
            Map<String, Object> next = iteratorTask.next();
            dyn = (DynamicObject)next.get("dyn");
            bookquantity = dyn.getBigDecimal("bookquantity");
            inventoryquantity = dyn.getBigDecimal("inventoryquantity");
            differquantity = inventoryquantity.subtract(bookquantity);
            differ = differquantity.compareTo(BigDecimal.ZERO);
            if (differ != 0) continue;
            iteratorTask.remove();
        }
        for (int i = 0; i < allTasks.size(); ++i) {
            setter.set("assetunit", allTasks.get(i).get("assetunit"), i);
            dyn = (DynamicObject)allTasks.get(i).get("dyn");
            setter.set("number", dyn.get("number"), i);
            setter.set("barcode", dyn.get("barcode"), i);
            setter.set("name", dyn.get("name"), i);
            setter.set("bookquantity", dyn.get("bookquantity"), i);
            setter.set("inventoryquantity", dyn.get("inventoryquantity"), i);
            bookquantity = dyn.getBigDecimal("bookquantity");
            inventoryquantity = dyn.getBigDecimal("inventoryquantity");
            differquantity = inventoryquantity.subtract(bookquantity).setScale(currencyInt, RoundingMode.HALF_UP);
            setter.set("differquantity", (Object)differquantity, i);
            setter.set("inventorytime", dyn.get("inventorytime"), i);
            setter.set("inventoryway", dyn.get("inventoryway"), i);
            differ = differquantity.compareTo(BigDecimal.ZERO);
            if (differ > 0) {
                setter.set("inventorydiffer", (Object)"A", i);
            } else if (differ < 0) {
                setter.set("inventorydiffer", (Object)"B", i);
            } else {
                setter.set("inventorydiffer", (Object)"C", i);
            }
            DynamicObject realCardDyn = dyn.getDynamicObject("realCard");
            if (realCardDyn != null) {
                setter.set("unit", realCardDyn.getDynamicObject("unit").getPkValue(), i);
                setter.set("storeplace", realCardDyn.getDynamicObject("storeplace").getPkValue(), i);
                setter.set("headusedept", realCardDyn.getDynamicObject("headusedept").getPkValue(), i);
                setter.set("realcard", realCardDyn.getPkValue(), i);
            }
            if (differ <= 0) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"unit", "storeplace", "headusedept"});
            }
            setter.set("inventoryrecord", dyn.getPkValue(), i);
            if (differ == -1 && realCardDyn != null) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("realcardmasterid", "=", realCardDyn.getPkValue()));
                qFilters.add(new QFilter("depreuse.default", "=", (Object)"1"));
                DynamicObject finCard = BusinessDataServiceHelper.loadSingle((String)"fa_card_fin", (String)FIN_CARD_PROPERTIES, (QFilter[])qFilters.toArray(new QFilter[0]));
                if (finCard != null) {
                    BigDecimal originalval = finCard.getBigDecimal("originalval");
                    BigDecimal differAmount = originalval.divide(bookquantity, currencyInt).multiply(differquantity).setScale(currencyInt, RoundingMode.HALF_UP);
                    setter.set("differamount", (Object)differAmount, i);
                }
            }
            int status = 0;
            if (differ == -1) {
                status = 3;
            } else if (differ == 1 && bookquantity.compareTo(BigDecimal.ZERO) > 0) {
                status = 2;
            } else if (differ == 1 && bookquantity.compareTo(BigDecimal.ZERO) < 0) {
                status = 1;
            }
            setter.set("inventorydifferstatus", (Object)status, i);
            setter.set("assetqtyleft", (Object)1, i);
            setter.set("inventorytask", dyn.getDynamicObject("inventorytask").getPkValue(), i);
        }
        if (setter.getCount() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u76d8\u70b9\u5dee\u5f02\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u672a\u5ba1\u6838\u7684\u76d8\u70b9\u8bb0\u5f55\u6216\u76d8\u70b9\u8bb0\u5f55\u4e2d\u65e0\u76d8\u70b9\u5dee\u5f02\u3002", (String)"FaInventoryDifferEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        model.batchCreateNewEntryRow("fa_invdiffererentry", setter);
        model.endInit();
        this.getView().updateView("fa_invdiffererentry");
        this.calInventoryamount();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        String s;
        String propName = e.getProperty().getName();
        if (propName.equals("org") || propName.equals("inventscheme")) {
            this.getModel().deleteEntryData("fa_invdiffererentry");
        }
        if ("org".equals(propName)) {
            this.setCurrency();
        } else if ("changemode".equals(propName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String inventoryDiffer = (String)this.getModel().getValue("inventorydiffer", rowIndex);
            DynamicObject changemodeDyn = (DynamicObject)this.getModel().getValue("changemode", rowIndex);
            if (changemodeDyn != null && "A".equals(inventoryDiffer) && !"ADD".equals(changemodeDyn.getString("type"))) {
                this.getModel().setValue("changemode", e.getChangeSet()[0].getOldValue(), rowIndex);
            } else if (changemodeDyn != null && "B".equals(inventoryDiffer) && !"REDUCE".equals(changemodeDyn.getString("type"))) {
                this.getModel().setValue("changemode", e.getChangeSet()[0].getOldValue(), rowIndex);
            }
        } else if ("billstatus".equals(propName) && "D".equals(s = String.valueOf(value = this.getModel().getValue("billstatus")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"inventoryhandle"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"inventorycancle"});
        }
    }

    private void calInventoryamount() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        int currencyInt = dataEntity.getDynamicObject("currency").getInt("amtprecision");
        DynamicObjectCollection invdiffers = dataEntity.getDynamicObjectCollection("fa_invdiffererentry");
        BigDecimal differAmount = new BigDecimal(0);
        for (DynamicObject invdifferDyn : invdiffers) {
            if (!"B".equals(invdifferDyn.getString("inventorydiffer"))) continue;
            differAmount = differAmount.add(invdifferDyn.getBigDecimal("differamount"));
        }
        this.getModel().setValue("inventorylossamount", (Object)differAmount.setScale(currencyInt).abs());
    }
}

