/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ClientMethod;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.lang.Lang;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.inventory.mobile.updaterecord.AbstractFaMobListPlugin;
import org.apache.log4j.Logger;

public class FaInventoryEgPlugin
extends AbstractFaMobListPlugin
implements RowClickEventListener {
    private static Logger log = Logger.getLogger(FaInventoryEgPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"scan", "selectpicture"});
    }

    public void beforeBindData(EventObject e) {
        Lang lang = RequestContext.get().getLang();
        Image image = (Image)this.getControl("imageap");
        if (Lang.zh_CN.equals((Object)lang) || Lang.zh_TW.equals((Object)lang)) {
            image.setUrl("/images/mobile/banner/rrzc_slt.png");
        } else {
            image.setUrl("/images/mobile/banner/rrzc_slt2.png");
        }
    }

    public void afterCreateNewData(EventObject e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String recordId = (String)showParameter.getCustomParam("recordid");
        String schemeId = (String)showParameter.getCustomParam("schemeid");
        String schemeName = (String)showParameter.getCustomParam("schemename");
        this.getPageCache().put("recordid", recordId);
        this.getPageCache().put("schemeid", schemeId);
        this.getPageCache().put("schemename", schemeName);
        log.info((Object)("\u76d8\u70b9\u65b9\u6848\u8bb0\u5f55id\uff1a" + recordId));
        this.getPageCache().put("insertorupdate", this.insertOrUpdate());
    }

    private String insertOrUpdate() {
        QFilter fuserid = new QFilter("userid", "=", (Object)ContextUtil.getUserId());
        DynamicObject eg = BusinessDataServiceHelper.loadSingle((String)"fa_table_firstinvent", (String)"showeg", (QFilter[])new QFilter[]{fuserid});
        if (eg == null) {
            return "0";
        }
        return "1";
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "scan": {
                boolean state = (Boolean)this.getModel().getValue("isshow");
                if (!this.updateEgTable(state)) {
                    log.info((Object)"\u6570\u636e\u5e93\u66f4\u65b0t_fa_showeg\u5931\u8d25");
                    return;
                }
                MobileFormView view = (MobileFormView)this.getView();
                view.callClientAppMethod(ClientMethod.ScanQRCode, null);
                break;
            }
            case "selectpicture": {
                this.selectItem();
                break;
            }
        }
    }

    private boolean updateEgTable(boolean state) {
        String operType = this.getPageCache().get("insertorupdate");
        String showeg = state ? "1" : "0";
        String sql = "";
        if ("0".equals(operType)) {
            long genLongId = DBServiceHelper.genLongIds((String)"fa_table_firstinvent", (int)1)[0];
            sql = "insert into t_fa_showeg(fid,fshoweg,fuserid) values (?,?,?) ";
            log.info((Object)("----------------\u66f4\u65b0\u8bed\u53e5sql\uff1a" + sql));
            return DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{genLongId, showeg, ContextUtil.getUserId()});
        }
        sql = "update t_fa_showeg set fshoweg = ? where fuserid = '" + ContextUtil.getUserId() + "'";
        log.info((Object)("----------------\u66f4\u65b0\u8bed\u53e5sql\uff1a" + sql));
        return DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{showeg});
    }

    private void selectItem() {
        IDataModel model = this.getModel();
        boolean state = (Boolean)model.getValue("isshow");
        Image picture = (Image)this.getView().getControl("selectpicture");
        if (state) {
            model.setValue("isshow", (Object)false);
            picture.setUrl("/icons/mobile/tab_bar/rrzc_wx.png");
        } else {
            model.setValue("isshow", (Object)true);
            picture.setUrl("/icons/mobile/tab_bar/rrzc_gx.png");
        }
    }
}

