/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.sql.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;

public class FaInventoryLossReasonPlugin
extends AbstractMobFormPlugin {
    private static Log log = LogFactory.getLog(FaInventoryLossReasonPlugin.class);
    private static String inventoryReportTable = "t_fa_inventory_record";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "submit"});
    }

    public void afterCreateNewData(EventObject e) {
        MobileFormShowParameter mobileFormShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String schemeId = (String)mobileFormShowParameter.getCustomParam("schemeid");
        String schemeName = (String)mobileFormShowParameter.getCustomParam("schemename");
        String recordId = (String)mobileFormShowParameter.getCustomParam("recordid");
        this.getPageCache().put("recordid", recordId);
        this.getPageCache().put("schemeid", schemeId);
        this.getPageCache().put("schemename", schemeName);
        QFilter qRecord = new QFilter("id", "=", (Object)Long.parseLong(recordId));
        String selectProperties = FaInventoryLossReasonPlugin.getSelectField();
        DynamicObject assetInventory = BusinessDataServiceHelper.loadSingle((String)"fa_inventory_record", (String)selectProperties, (QFilter[])new QFilter[]{qRecord});
        this.getLabel("assetname").setText(assetInventory.getString("realcard.assetname"));
        String picture = assetInventory.getString("realcard.picturefield");
        if (!StringUtils.isEmpty((String)picture)) {
            picture = ImageUtil.getImageTruePath((String)picture);
            this.getImage("assetimage").setUrl(picture);
        }
        log.info("\u5361\u7247\u56fe\u7247+++++++++++++" + ImageUtil.getImageTruePath((String)assetInventory.getString("realcard.picturefield")));
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "cancel": {
                break;
            }
            case "submit": {
                String recordId = this.getPageCache().get("recordid");
                String detailReason = (String)this.getModel().getValue("detailreason");
                log.info("\u76d8\u70b9\u8bb0\u5f55id:" + recordId);
                boolean isCheck = this.updateInventoryLoss(recordId, null, detailReason);
                log.info("\u76d8\u4e8f\u72b6\u6001,true \u6210\u529f\uff0cfalse \u5931\u8d25:" + isCheck);
                this.showBillForm("fa_mobile_inventloss", recordId, null, detailReason);
                break;
            }
        }
        this.getView().close();
    }

    private static String getSelectField() {
        StringBuilder fields = new StringBuilder();
        fields.append("realcard.assetname,").append("realcard.picturefield");
        return fields.toString();
    }

    private boolean updateInventoryLoss(String recordID, String lossReason, String detailReason) {
        String sql = "update " + inventoryReportTable + " set finventoryuser = ?, finventorystate = 'A',freason = ?,finventoryway = 'A',finventoryquantity = 0,finventorytime = ?,fdifference = 0-fbookquantity where finventorystate  = 'B' and fid = '" + recordID + "'";
        log.info("----------------\u66f4\u65b0\u8bed\u53e5sql\uff1a" + sql);
        return DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{ContextUtil.getUserId(), detailReason, new Date(new java.util.Date().getTime())});
    }

    private void showBillForm(String formId, String recordId, String lossReason, String detailReason) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", (Object)recordId);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        log.info("\u76d8\u70b9\u539f\u56e0\u8df3\u8f6c\u76d8\u4e8f\u9875\u9762---schemeid---" + this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        log.info("\u76d8\u70b9\u539f\u56e0\u8df3\u8f6c\u76d8\u4e8f\u9875\u9762---schemename---" + this.getPageCache().get("schemename"));
        showParameter.setCustomParam("lossreason", (Object)lossReason);
        showParameter.setCustomParam("detailreason", (Object)detailReason);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Label getLabel(String ctrlName) {
        return (Label)this.getView().getControl(ctrlName);
    }

    private Image getImage(String ctrlName) {
        return (Image)this.getView().getControl(ctrlName);
    }
}

