/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.InventMobileEnum;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;

public class FaInventoryMobileEntrustPlugin
extends AbstractMobListPlugin
implements RowClickEventListener,
SelectRowsEventListener,
MobileSearchTextChangeListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"consignation", "cancel"});
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
        MobileSearch serach = (MobileSearch)this.getControl("mobilesearchap");
        serach.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntryEntity();
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "consignation": {
                CardEntry control = (CardEntry)this.getControl("entryentity");
                int[] selectRows = control.getSelectRows();
                ArrayList<String> recordIds = new ArrayList<String>(16);
                if (0 == selectRows.length) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u59d4\u6258\u7684\u8d44\u4ea7\u3002", (String)"FaInventoryMobileEntrustPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                for (int selectRow : selectRows) {
                    String recordId = (String)this.getModel().getValue("recordid", selectRow);
                    recordIds.add(recordId);
                }
                this.showEntrustBillDetailForm("fa_mobile_selectentrust", recordIds);
                break;
            }
            case "cancel": {
                FaInventoryMobileEntrustPlugin.showFaInventoryBillMobForm(this.getView());
                break;
            }
        }
    }

    private void initEntryEntity() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        DataSet assetInventorys = FaInventMobUtil.queryMobileInventAll(ContextUtil.getUserId(), Boolean.FALSE, Boolean.TRUE);
        if (null != assetInventorys) {
            this.setEntryEntity(model, assetInventorys);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"complete"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fastcheck"});
        }
    }

    private void setEntryEntity(AbstractFormDataModel model, DataSet assetInventorys) {
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"asset_cardid"});
        int index = 0;
        for (Row assetInventory : assetInventorys) {
            String picture = assetInventory.getString("realcard.picturefield");
            if (!StringUtils.isEmpty((String)picture)) {
                picture = ImageUtil.getImageTruePath((String)assetInventory.getString("realcard.picturefield"));
            }
            if (null != assetInventory.getString("consignee.name")) {
                setter.set("consignor", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u59d4\u6258\uff1a%s", (String)"FaInventoryMobileEntrustPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetInventory.getString("consignee.name")), index);
            }
            setter.set("assetpicture", (Object)picture, index);
            setter.set("assetname", (Object)assetInventory.getString("realcard.assetname"), index);
            setter.set("assetnumber", (Object)assetInventory.getString("realcard.number"), index);
            setter.set("specification", (Object)assetInventory.getString("realcard.model"), index);
            setter.set("assetcategory", (Object)assetInventory.getString("realcard.assetcat.name"), index);
            setter.set("asset_cardid", (Object)assetInventory.getString("realcard.id"), index);
            setter.set("recordid", assetInventory.get("id"), index);
            String status = assetInventory.getString("inventorystate");
            BigDecimal difference = assetInventory.getBigDecimal("difference");
            if ("A".equals(status)) {
                if (difference.compareTo(BigDecimal.ZERO) >= 0) {
                    setter.set("completestate", (Object)InventMobileEnum.INVENTORYED.getName(), index);
                    setter.set("stateidentify", (Object)"A", index);
                } else {
                    setter.set("completestate", (Object)InventMobileEnum.INVENTORYLOSS.getName(), index);
                    setter.set("stateidentify", (Object)"B", index);
                }
            } else {
                setter.set("completestate", (Object)InventMobileEnum.WAITINVENTORY.getName(), index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void showEntrustBillDetailForm(String formId, List<String> recordIds) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        String records = SerializationUtils.toJsonString(recordIds);
        showParameter.setCustomParam("recordid", (Object)records);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showformdetail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private static void showFaInventoryBillMobForm(IFormView view) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("fa_mobile_inventpage");
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        String text = mobileSearchTextChangeEvent.getText();
        this.getModel().deleteEntryData("entryentity");
        this.getView().updateView("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        DataSet assetInventorys = FaInventMobUtil.queryMobileInventAll(ContextUtil.getUserId(), Boolean.FALSE, Boolean.TRUE);
        assetInventorys = assetInventorys.filter("realcard.assetname like '%" + text + "%' or realcard.number like '%" + text + "%'");
        if (null != assetInventorys) {
            this.setEntryEntity(model, assetInventorys);
        }
    }
}

