/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.InventMobileEnum;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;
import kd.fi.fa.inventory.mobile.updaterecord.AbstractFaMobListPlugin;

public class FaInventoryMobilePlugin
extends AbstractFaMobListPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"fastcheck", "complete", "inventory_entrust", "toinventorytask"});
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.inityEntity();
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "fastcheck": {
                MobileFormView view = (MobileFormView)this.getView();
                Long userId = ContextUtil.getUserId();
                String schemeId = this.getPageCache().get("schemeid");
                String schemeName = this.getPageCache().get("schemename");
                FaInventMobUtil.scanInventory(view, userId, null, schemeId, schemeName);
                break;
            }
            case "complete": {
                this.showMobList("fa_mobile", "fa_my_asset_template", null, null);
                break;
            }
            case "inventory_entrust": {
                HashMap<String, Object> paraMap = new HashMap<String, Object>(1);
                paraMap.put("entrust", Boolean.TRUE);
                this.showMob("fa_mobile_consignation", paraMap, null);
                break;
            }
            case "toinventorytask": {
                this.showMob("fa_mobile_invettask", null, null);
                break;
            }
        }
    }

    private void showMobList(String billFormId, String formId, Map<String, Object> paraMap, String caption) {
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId("fa");
        if (caption != null) {
            showParameter.setCaption(caption);
        }
        if (paraMap != null) {
            showParameter.setCustomParams(paraMap);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showMob(String formId, Map<String, Object> paraMap, String caption) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setAppId("fa");
        if (caption != null) {
            showParameter.setCaption(caption);
        }
        if (paraMap != null) {
            showParameter.setCustomParams(paraMap);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry) {
            String entryKey;
            CardEntry cardEntry = (CardEntry)source;
            switch (entryKey = cardEntry.getEntryKey()) {
                case "entryentity": {
                    int selectedIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                    String recordId = (String)this.getModel().getValue("recordid", selectedIndex);
                    Long realCardId = Long.parseLong((String)this.getModel().getValue("asset_cardid", selectedIndex));
                    String state = (String)this.getModel().getValue("stateidentify", selectedIndex);
                    if ("A".equals(state)) {
                        FaInventMobUtil.showBillForm(this.getView(), "fa_mobile_inventsuccess", recordId, null, null, null, null, null);
                        break;
                    }
                    if ("B".equals(state)) {
                        this.showLossBillForm("fa_mobile_inventloss", recordId);
                        break;
                    }
                    this.showBillDetailForm("fa_mobile_inventdetail", this.getModel().getValue("recordid", selectedIndex), realCardId);
                    break;
                }
            }
        }
    }

    private void inityEntity() {
        MobileFormShowParameter params = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Long taskid = (Long)params.getCustomParam("taskid");
        DataSet assetInventoryDs = FaInventMobUtil.queryMobileInventAll(ContextUtil.getUserId(), Boolean.TRUE, Boolean.TRUE);
        if (null != taskid) {
            assetInventoryDs = assetInventoryDs.filter("inventorytask.id =" + taskid.toString());
        }
        if (null != assetInventoryDs) {
            this.setEntryEntity(assetInventoryDs);
        }
    }

    private void setEntryEntity(DataSet assetInventorys) {
        int completeCnt = 0;
        int lossCnt = 0;
        int length = 0;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"asset_cardid"});
        int index = 0;
        for (Row assetInventory : assetInventorys) {
            BigDecimal difference;
            String status;
            String picture;
            ++length;
            if (null == assetInventory.get("id")) {
                picture = assetInventory.getString("cpicturefield");
                if (!StringUtils.isEmpty((String)picture)) {
                    picture = ImageUtil.getImageTruePath((String)assetInventory.getString("cpicturefield"));
                }
                setter.set("assetpicture", (Object)picture, index);
                setter.set("assetname", (Object)assetInventory.getString("cassetname"), index);
                setter.set("assetcategory", (Object)assetInventory.getString("cassetcategory"), index);
                setter.set("consignee", (Object)String.format(ResManager.loadKDString((String)"\u59d4\u6258\u81ea\uff1a%s", (String)"FaInventoryMobilePlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetInventory.getString("consignor.name")), index);
                setter.set("specification", (Object)assetInventory.getString("cmodel"), index);
                setter.set("recordid", assetInventory.get("recordid"), index);
                setter.set("asset_cardid", (Object)assetInventory.getString("crealcard"), index);
                ArrayList<String> keys = new ArrayList<String>(1);
                keys.add("consignor");
                FaInventoryMobilePlugin.setfieldVisible("entryentity", Boolean.FALSE, keys, this.getView(), index);
                status = assetInventory.getString("recordid.inventorystate");
                difference = assetInventory.getBigDecimal("recordid.difference");
            } else {
                picture = assetInventory.getString("realcard.picturefield");
                if (!StringUtils.isEmpty((String)picture)) {
                    picture = ImageUtil.getImageTruePath((String)assetInventory.getString("realcard.picturefield"));
                }
                if (null != assetInventory.getString("consignee.name")) {
                    setter.set("consignor", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u59d4\u6258\uff1a%s", (String)"FaInventoryMobilePlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetInventory.getString("consignee.name")), index);
                }
                setter.set("assetpicture", (Object)picture, index);
                setter.set("assetname", (Object)assetInventory.getString("realcard.assetname"), index);
                setter.set("assetnumber", (Object)assetInventory.getString("realcard.number"), index);
                setter.set("specification", (Object)assetInventory.getString("realcard.model"), index);
                setter.set("assetcategory", (Object)assetInventory.getString("realcard.assetcat.name"), index);
                setter.set("asset_cardid", (Object)assetInventory.getString("realcard.id"), index);
                setter.set("recordid", assetInventory.get("id"), index);
                status = assetInventory.getString("inventorystate");
                difference = assetInventory.getBigDecimal("difference");
            }
            if ("A".equals(status)) {
                if (difference.compareTo(BigDecimal.ZERO) >= 0) {
                    setter.set("completestate", (Object)InventMobileEnum.INVENTORYED.getName(), index);
                    setter.set("stateidentify", (Object)"A", index);
                    ++completeCnt;
                } else {
                    setter.set("completestate", (Object)InventMobileEnum.INVENTORYLOSS.getName(), index);
                    setter.set("stateidentify", (Object)"B", index);
                    ++lossCnt;
                    ++completeCnt;
                }
            } else {
                setter.set("completestate", (Object)InventMobileEnum.WAITINVENTORY.getName(), index);
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        this.setSchemePal(completeCnt, lossCnt, length);
    }

    private void setSchemePal(Integer completeCnt, Integer lossCnt, Integer length) {
        Label label = (Label)this.getControl("inventoryrate");
        if (0 == length) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventory_entrust"});
            return;
        }
        label.setText(completeCnt + "/" + length);
        Label allState = (Label)this.getControl("allstate");
        if (completeCnt.equals(length)) {
            if (lossCnt > 0) {
                LabelAp labelAp = new LabelAp();
                labelAp.setKey("allstate");
                labelAp.setForeColor("red");
                allState.setText(String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u4efb\u52a1\u5b8c\u6210\uff0c\u5176\u4e2d%s\u9879\u672a\u5b8c\u6210\u76d8\u70b9\u3002", (String)"FaInventoryMobilePlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), lossCnt));
                this.getView().updateControlMetadata(labelAp.getKey(), labelAp.createControl());
            } else if (completeCnt / length == 1) {
                allState.setText(ResManager.loadKDString((String)"\u76d8\u70b9\u5b8c\u6210", (String)"FaInventoryMobilePlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        } else {
            allState.setText(ResManager.loadKDString((String)"\u76d8\u70b9\u8fdb\u5ea6", (String)"FaInventoryMobilePlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (completeCnt.equals(length)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"complete"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fastcheck"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"inventory_entrust"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"complete"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fastcheck"});
        }
    }

    private void showBillDetailForm(String formId, Object recordId, Long realCardId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", recordId);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("realCardId", (Object)realCardId);
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showformdetail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showLossBillForm(String formId, String recordId) {
        QFilter qrecord = new QFilter("id", "=", (Object)Long.parseLong(recordId));
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"fa_inventory_record", (String)"reason", (QFilter[])new QFilter[]{qrecord});
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", (Object)recordId);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        showParameter.setCustomParam("detailreason", (Object)record.getString("reason"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private static void setfieldVisible(String entityName, Boolean vi, List<String> keys, IFormView view, int index) {
        ArrayList allfieldMap = new ArrayList(keys.size());
        for (String key : keys) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            fieldMap.put("k", key);
            fieldMap.put("vi", vi);
            fieldMap.put("r", new int[]{index});
            allfieldMap.add(fieldMap);
        }
        HashMap<String, Object> fieldMaps = new HashMap<String, Object>();
        fieldMaps.put("v", allfieldMap);
        fieldMaps.put("o", "126");
        Object[] field = new Object[]{fieldMaps};
        Object[] fieldArr = new Object[]{field};
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entityName, "visible", fieldArr);
    }
}

