/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;

public class FaInventoryMobileTaskPlugin
extends AbstractMobListPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntity();
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry;
        String entryKey;
        Object source = evt.getSource();
        if (source instanceof CardEntry && "entryentity".equals(entryKey = (cardEntry = (CardEntry)source).getEntryKey())) {
            int selectedIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Long taskId = Long.parseLong(this.getModel().getValue("taskid", selectedIndex).toString());
            FaInventoryMobileTaskPlugin.showInventBillForm(this.getView(), taskId);
        }
    }

    private void initEntity() {
        Set<Long> taskList = FaInventMobUtil.queryInventSchemeList(ContextUtil.getUserId());
        QFilter idFilter = new QFilter("id", "in", taskList);
        DynamicObject[] inventoryTasks = BusinessDataServiceHelper.load((String)"fa_inventory_task", (String)"id,number,name,inventorychecker,inventschemeid", (QFilter[])new QFilter[]{idFilter});
        if (inventoryTasks.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u76d8\u70b9\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u540d\u4e0b\u8d44\u4ea7\u90fd\u662f\u88ab\u59d4\u6258\u7684\u3002", (String)"FaInventoryMobileTaskPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        QFilter recordFilter = new QFilter("inventorytask.id", "in", taskList);
        DynamicObjectCollection inventoryRecord = QueryServiceHelper.query((String)"fa_inventory_record", (String)"inventoryquantity,bookquantity,inventorystate,inventorytask.id,difference", (QFilter[])new QFilter[]{recordFilter});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", inventoryTasks.length);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        for (int i = 0; i < inventoryTasks.length; ++i) {
            DynamicObject entry = (DynamicObject)entryentity.get(i);
            DynamicObject task = inventoryTasks[i];
            int completeCnt = 0;
            int lossCnt = 0;
            int length = 0;
            for (DynamicObject record : inventoryRecord) {
                String inventorystate = record.getString("inventorystate");
                long taskId = record.getLong("inventorytask.id");
                BigDecimal difference = record.getBigDecimal("difference");
                if (taskId != task.getLong("id")) continue;
                ++length;
                if (!"A".equals(inventorystate)) continue;
                if (difference.compareTo(BigDecimal.ZERO) >= 0) {
                    ++completeCnt;
                    continue;
                }
                ++lossCnt;
                ++completeCnt;
            }
            entry.set("taskid", (Object)task.getLong("id"));
            entry.set("tasknumber", (Object)task.getLong("number"));
            if (null != task.getDynamicObject("inventschemeid")) {
                entry.set("taskname", (Object)task.getDynamicObject("inventschemeid").getString("name"));
            }
            this.setSchemePal(completeCnt, lossCnt, length, entry);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void setSchemePal(Integer completeCnt, Integer lossCnt, Integer length, DynamicObject entry) {
        if (completeCnt.equals(length)) {
            if (lossCnt > 0) {
                entry.set("progresslab", (Object)String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u4efb\u52a1\u5b8c\u6210\uff0c\u5176\u4e2d%s\u9879\u672a\u5b8c\u6210\u76d8\u70b9\u3002", (String)"FaInventoryMobileTaskPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), lossCnt));
            } else if (completeCnt / length == 1) {
                entry.set("progresslab", (Object)ResManager.loadKDString((String)"\u76d8\u70b9\u5b8c\u6210", (String)"FaInventoryMobileTaskPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        } else {
            entry.set("progresslab", (Object)ResManager.loadKDString((String)"\u76d8\u70b9\u8fdb\u5ea6", (String)"FaInventoryMobileTaskPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        entry.set("progress", (Object)(completeCnt + "/" + length));
    }

    private static void showInventBillForm(IFormView thisFormView, Long taskId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("fa_mobile_inventpage");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("taskid", (Object)taskId);
        thisFormView.showForm((FormShowParameter)showParameter);
    }
}

