/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.text.SimpleDateFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.ImageUtil;

public class FaInventoryTemplateUtil {
    public static void updateRealCardShowInfo(IFormView view, Log log, Object recordId, Long realcardId) {
        if (null != recordId) {
            QFilter qRecord = new QFilter("id", "=", (Object)Long.parseLong(recordId.toString()));
            boolean isExist = QueryServiceHelper.exists((String)"fa_inventory_record", (QFilter[])new QFilter[]{qRecord});
            if (isExist) {
                FaInventoryTemplateUtil.updateByRecordId(view, log, recordId);
            } else {
                FaInventoryTemplateUtil.updateByCardId(view, log, realcardId);
            }
        } else {
            FaInventoryTemplateUtil.updateByCardId(view, log, realcardId);
        }
    }

    private static void updateByCardId(IFormView view, Log log, Long realcardId) {
        QFilter qCard = new QFilter("id", "=", (Object)realcardId);
        String selectProperties = FaInventoryTemplateUtil.getCardField();
        DynamicObject assetInventory = BusinessDataServiceHelper.loadSingle((String)"fa_card_real", (String)selectProperties, (QFilter[])new QFilter[]{qCard});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FaInventoryTemplateUtil.getLabel(view, "assetname").setText(assetInventory.getString("assetname"));
        FaInventoryTemplateUtil.getLabel(view, "assetnumber").setText(assetInventory.getString("number"));
        FaInventoryTemplateUtil.getLabel(view, "specification").setText(assetInventory.getString("model"));
        FaInventoryTemplateUtil.getLabel(view, "assetcategory").setText(assetInventory.getString("assetcat.name"));
        FaInventoryTemplateUtil.getLabel(view, "username").setText(assetInventory.getString("headuseperson.name"));
        if (assetInventory.getDate("realaccountdate") != null) {
            FaInventoryTemplateUtil.getLabel(view, "realaccountdate").setText(simpleDateFormat.format(assetInventory.getDate("realaccountdate")));
        } else {
            FaInventoryTemplateUtil.getLabel(view, "realaccountdate").setText("");
        }
        String picture = assetInventory.getString("picturefield");
        log.info("\u5361\u7247\u56fe\u7247+++++++++++++" + ImageUtil.getImageTruePath((String)picture));
        if (!StringUtils.isEmpty((String)picture)) {
            picture = ImageUtil.getImageTruePath((String)picture);
            FaInventoryTemplateUtil.getImage(view, "assetpicture").setUrl(picture);
        }
    }

    private static void updateByRecordId(IFormView view, Log log, Object recordId) {
        QFilter qRecord = new QFilter("id", "=", (Object)Long.parseLong(recordId.toString()));
        String selectProperties = FaInventoryTemplateUtil.getSelectField();
        DynamicObject assetInventory = BusinessDataServiceHelper.loadSingle((String)"fa_inventory_record", (String)selectProperties, (QFilter[])new QFilter[]{qRecord});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FaInventoryTemplateUtil.getLabel(view, "assetname").setText(assetInventory.getString("realcard.assetname"));
        FaInventoryTemplateUtil.getLabel(view, "assetnumber").setText(assetInventory.getString("realcard.number"));
        FaInventoryTemplateUtil.getLabel(view, "specification").setText(assetInventory.getString("realcard.model"));
        FaInventoryTemplateUtil.getLabel(view, "assetcategory").setText(assetInventory.getString("realcard.assetcat.name"));
        FaInventoryTemplateUtil.getLabel(view, "username").setText(assetInventory.getString("realcard.headuseperson.name"));
        if (assetInventory.getDate("realcard.realaccountdate") != null) {
            FaInventoryTemplateUtil.getLabel(view, "realaccountdate").setText(simpleDateFormat.format(assetInventory.getDate("realcard.realaccountdate")));
        } else {
            FaInventoryTemplateUtil.getLabel(view, "realaccountdate").setText("");
        }
        String picture = assetInventory.getString("realcard.picturefield");
        log.info("\u5361\u7247\u56fe\u7247+++++++++++++" + ImageUtil.getImageTruePath((String)picture));
        if (!StringUtils.isEmpty((String)picture)) {
            picture = ImageUtil.getImageTruePath((String)picture);
            FaInventoryTemplateUtil.getImage(view, "assetpicture").setUrl(picture);
        }
        if (view.getControl("lossreason") != null) {
            view.getModel().setValue("lossreason", (Object)assetInventory.getString("reason"));
        }
    }

    private static String getSelectField() {
        StringBuilder fields = new StringBuilder();
        fields.append("realcard.number,").append("realcard.billno,").append("realcard.id,").append("realcard.assetname,").append("realcard.picturefield,").append("realcard.model,").append("realcard.assetcat.name,").append("realcard.realaccountdate,").append("realcard.headuseperson.name,").append("difference,").append("reason,").append("inventorystate");
        return fields.toString();
    }

    private static String getCardField() {
        StringBuilder fields = new StringBuilder();
        fields.append("number,").append("id,").append("assetname,").append("picturefield,").append("model,").append("assetcat.name,").append("realaccountdate,").append("headuseperson.name");
        return fields.toString();
    }

    private static Label getLabel(IFormView view, String ctrlName) {
        return (Label)view.getControl(ctrlName);
    }

    private static Image getImage(IFormView view, String ctrlName) {
        return (Image)view.getControl(ctrlName);
    }
}

