/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.inventory.report.TaskEntry;
import kd.fi.fa.utils.FaInventoryUtils;
import org.apache.commons.beanutils.BeanUtils;

public class FaInventoryReportPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(FaInventoryReportPlugin.class);
    private static final String algoXalgoKey = "kd.fi.fa.inventory.report.FaAssetInverntoryPlugin";
    private static final int defaultLength = 5;

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar toolBar = (Toolbar)this.getView().getControl("toolbar");
        toolBar.addItemClickListener((ItemClickListener)this);
        Toolbar toolBar2 = (Toolbar)this.getView().getControl("toolbarap");
        toolBar2.addItemClickListener((ItemClickListener)this);
        this.filterCreateOrg();
        this.filterInventoryScheme();
    }

    private void filterCreateOrg() {
        BasedataEdit createorg = (BasedataEdit)this.getView().getControl("q_createorg");
        createorg.addBeforeF7SelectListener(listener -> {
            HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
            List filters = ((ListShowParameter)listener.getFormShowParameter()).getListFilterParameter().getQFilters();
            if (!userHasPermOrgs.hasAllOrgPerm()) {
                List orgIds = userHasPermOrgs.getHasPermOrgs();
                filters.add(new QFilter("id", "in", (Object)orgIds));
            }
        });
    }

    private void filterInventoryScheme() {
        BasedataEdit inventoryscheme = (BasedataEdit)this.getView().getControl("q_inventoryschemeid");
        inventoryscheme.addBeforeF7SelectListener(listener -> {
            List filters = ((ListShowParameter)listener.getFormShowParameter()).getListFilterParameter().getQFilters();
            Long orgId = (Long)this.getModel().getValue("q_createorg_id");
            if (orgId != null) {
                filters.add(new QFilter("createorg", "in", (Object)orgId));
            } else {
                HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)ContextUtil.getUserId());
                if (!userHasPermOrgs.hasAllOrgPerm()) {
                    List orgIds = userHasPermOrgs.getHasPermOrgs();
                    filters.add(new QFilter("createorg", "in", (Object)orgIds));
                }
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String keyname = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)keyname, (CharSequence)"viewall")) {
            String schemeentrys = this.getPageCache().get("schemeentrys");
            if (Objects.nonNull(schemeentrys)) {
                HashMap schemeEntrys = (HashMap)SerializationUtils.fromJsonString((String)schemeentrys, HashMap.class);
                this.initValue(schemeEntrys);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)keyname, (CharSequence)"refreshrp")) {
            DynamicObject tempSchemeId = (DynamicObject)this.getModel().getValue("q_inventoryschemeid");
            if (tempSchemeId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76d8\u70b9\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"FaInventoryReportPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().getFormShowParameter().setCustomParam("schemeId", null);
            this.getPageCache().put("refreshscheme", tempSchemeId.getString("id"));
            DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingle((Object)tempSchemeId.getString("id"), (String)"fa_inventscheme_new");
            this.initInventoryScheme(schemeDyn.getLong("createorg.id"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.hasInventoryScheme()) {
            Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
            if (schemeId == null) {
                long orgId = RequestContext.get().getOrgId();
                this.initInventoryScheme(orgId);
            } else {
                DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"fa_inventscheme_new");
                this.initInventoryScheme(schemeDyn.getLong("createorg.id"));
            }
        }
    }

    private void initInventoryScheme(Long orgId) {
        List orgIds;
        DynamicObjectCollection allSchemes;
        List<Long> allSchemeids;
        String hasPermOrgIdsObj;
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"fa_inventscheme_new", (String)"id", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)orgId)});
        List<Long> schemeids = schemes.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        HashMap<String, ArrayList<TaskEntry>> schemeEntrys = this.getSchemeEntrys(schemeids);
        if (schemeEntrys.size() <= 0 && null != (hasPermOrgIdsObj = this.getPageCache().get("hasPermOrgIds")) && (schemeEntrys = this.getSchemeEntrys(allSchemeids = (allSchemes = QueryServiceHelper.query((String)"fa_inventscheme_new", (String)"id", (QFilter[])new QFilter[]{new QFilter("createorg", "in", (Object)(orgIds = (List)SerializationUtils.deSerializeFromBase64((String)hasPermOrgIdsObj.toString())))})).stream().map(v -> v.getLong("id")).collect(Collectors.toList()))).size() <= 0) {
            FaInventoryUtils.setColumnVisible(this.getView(), new HashSet<String>(2));
            this.getModel().setValue("q_inventoryschemeid", null);
            return;
        }
        this.getPageCache().put("schemeentrys", SerializationUtils.toJsonString(schemeEntrys));
        this.initInventoryScheme(schemeEntrys);
        this.initValue(schemeEntrys);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (propName.equals("q_inventoryschemeid")) {
            String schemeentrys = this.getPageCache().get("schemeentrys");
            HashMap schemeEntrys = (HashMap)SerializationUtils.fromJsonString((String)schemeentrys, HashMap.class);
            this.initValue(schemeEntrys);
        }
        if (propName.equals("q_createorg")) {
            DynamicObject scheme = e.getChangeSet()[0].getNewValue() == null ? (DynamicObject)e.getChangeSet()[0].getOldValue() : (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getPageCache().put("refreshscheme", null);
            this.getView().getFormShowParameter().setCustomParam("schemeId", null);
            this.initInventoryScheme(scheme.getLong("id"));
        }
    }

    private void initValue(HashMap<String, ArrayList<TaskEntry>> schemeEntrys) {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("q_inventoryschemeid");
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u76d8\u70b9\u65b9\u6848\u3002", (String)"FaInventoryReportPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        String schemeId = String.valueOf(scheme.getPkValue());
        ArrayList<TaskEntry> schemeEntry = schemeEntrys.get(schemeId);
        Map<String, TaskEntry> rowEntrys = this.getTask_Records(schemeId);
        if (schemeEntry != null) {
            schemeEntry = this.fillEntry(rowEntrys, schemeEntry);
            this.fillCntAndRate(schemeEntry);
        }
    }

    private ArrayList<TaskEntry> fillEntry(Map<String, TaskEntry> results, ArrayList<TaskEntry> schemeEntry) {
        ArrayList<TaskEntry> schemeEntry2 = new ArrayList<TaskEntry>();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map<String, Map<String, Object>> baseEntityIdMap = FaInventoryUtils.getBaseEntityIdMap();
        HashMap<String, Map<Long, String>> resultMap = new HashMap<String, Map<Long, String>>(16);
        HashMap<String, String> baseNameMap = new HashMap<String, String>(baseEntityIdMap.size(), 1.0f);
        HashMap<String, Set<Long>> queryMap = new HashMap<String, Set<Long>>(baseEntityIdMap.size(), 1.0f);
        for (String s : baseEntityIdMap.keySet()) {
            queryMap.put(s, new HashSet());
        }
        for (int i = 0; i < schemeEntry.size(); ++i) {
            TaskEntry taskEntry = this.getRow(schemeEntry.get(i));
            Map<String, Set<Long>> baseDataMap = taskEntry.getBaseDataMap();
            if (null == baseDataMap) continue;
            for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
                Set set = (Set)queryMap.get(entry.getKey());
                set.addAll((Collection)entry.getValue());
                queryMap.put(entry.getKey(), set);
            }
        }
        FaInventoryUtils.setResultMapValue(queryMap, baseEntityIdMap, resultMap);
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("number", new Object[0]);
        vs.addField("accounting", new Object[0]);
        vs.addField("chargeperson", new Object[0]);
        vs.addField("inventorypercent", new Object[0]);
        vs.addField("papernumber", new Object[0]);
        vs.addField("realnumber", new Object[0]);
        vs.addField("lossnumber", new Object[0]);
        vs.addField("profitnumber", new Object[0]);
        vs.addField("inventorytaskid", new Object[0]);
        vs.addField("operationcolumn", new Object[0]);
        int k = 0;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        HashSet<String> columnNames = new HashSet<String>(2);
        for (Map.Entry<String, Map<String, Object>> entry : baseEntityIdMap.entrySet()) {
            String columnName = "entrytext" + k;
            vs.addField(columnName, new Object[0]);
            baseNameMap.put(entry.getKey(), columnName);
            Map<String, Object> map = entry.getValue();
            if (null == map.get("displayName")) continue;
            entryGrid.setColumnProperty(columnName, "header", map.get("displayName"));
            if (++k <= 10) continue;
            break;
        }
        int n = 0;
        int n2 = 0;
        int length = schemeEntry.size();
        for (int i = 0; i < length; ++i) {
            TaskEntry row = this.getRow(schemeEntry.get(i));
            TaskEntry result = results.get(row.getTaskid());
            if (result != null) {
                row.setRealnumber(result.getRealnumber());
                row.setBookquantity(result.getBookquantity());
                row.setLossnumber(result.getLossnumber());
                row.setProfitnumber(result.getProfitnumber());
                row.setSchemeid(result.getSchemeid());
                row.setTaskid(result.getTaskid());
                row.setHasInvent(result.getHasInvent());
                row.setTotal(result.getTotal());
            }
            vs.set("number", (Object)row.getNumber(), i);
            vs.set("accounting", (Object)row.getAssetunit(), i);
            vs.set("chargeperson", (Object)row.getChargeperson(), i);
            if ("A".equals(row.getStatus())) {
                vs.set("inventorypercent", (Object)row.getInventorypercent(), i);
                vs.set("papernumber", (Object)row.getBookquantity(), i);
                vs.set("realnumber", (Object)row.getRealnumber(), i);
                vs.set("lossnumber", (Object)row.getLossnumber(), i);
                vs.set("profitnumber", (Object)row.getProfitnumber(), i);
            } else if ("B".equals(row.getStatus())) {
                vs.set("inventorypercent", (Object)row.getInventorypercent(), i);
            } else {
                if (row.getBookquantity().compareTo(BigDecimal.ZERO) == 0) {
                    vs.set("inventorypercent", (Object)row.getInventorypercent(), i);
                }
                row.setInventorypercent(FaInventoryUtils.getProgressRate(row.getHasInvent(), row.getTotal()));
                vs.set("inventorypercent", (Object)row.getInventorypercent(), i);
                logger.info(row.getTaskid() + "---" + row.getAssetunit() + "---" + row.getChargeperson() + ":" + row.getBookquantity());
                logger.info("\u8fdb\u5ea6\uff1a" + FaInventoryUtils.getProgressRate(row.getHasInvent(), row.getTotal()));
            }
            vs.set("papernumber", (Object)row.getBookquantity(), i);
            vs.set("realnumber", (Object)row.getRealnumber(), i);
            vs.set("lossnumber", (Object)row.getLossnumber(), i);
            vs.set("profitnumber", (Object)row.getProfitnumber(), i);
            vs.set("inventorytaskid", (Object)row.getTaskid(), i);
            Map<String, Set<Long>> baseDataMap = row.getBaseDataMap();
            if (null != baseDataMap) {
                for (Map.Entry<String, Set<Long>> entry : baseDataMap.entrySet()) {
                    HashSet ids = new HashSet(entry.getValue());
                    ArrayList<String> names = new ArrayList<String>(ids.size());
                    Map idAndNameMap = (Map)resultMap.get(entry.getKey());
                    for (Object id : ids) {
                        Long idLong = 0L;
                        idLong = id instanceof Integer ? Long.valueOf(((Integer)id).longValue()) : (Long)id;
                        names.add((String)idAndNameMap.get(idLong));
                    }
                    vs.set((String)baseNameMap.get(entry.getKey()), (Object)FaInventoryUtils.getAllNamesString(names), i);
                    columnNames.add((String)baseNameMap.get(entry.getKey()));
                }
            }
            vs.set("operationcolumn", (Object)ResManager.loadKDString((String)"\u76d8\u70b9\u8bb0\u5f55", (String)"FaInventoryReportPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), i);
            schemeEntry2.add(row);
        }
        FaInventoryUtils.setColumnVisible(this.getView(), columnNames);
        this.getPageCache().put("alltotal", n + "");
        this.getPageCache().put("allhasinvent", n2 + "");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"viewall"});
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        return schemeEntry2;
    }

    private TaskEntry getRow(Object taskEntry) {
        TaskEntry row = new TaskEntry();
        if (taskEntry instanceof HashMap) {
            try {
                Map taskEntryMap = (Map)taskEntry;
                BeanUtils.populate((Object)row, (Map)taskEntryMap);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else {
            row = (TaskEntry)taskEntry;
        }
        return row;
    }

    private Map<String, TaskEntry> getTask_Records(String schemeId) {
        QFilter a1 = new QFilter("inventschemeentry", "in", (Object)Long.parseLong(schemeId));
        DataSet result = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_inventory_record", (String)this.getSelectFields(), (QFilter[])new QFilter[]{a1}, null);
        if (result == null) {
            return new HashMap<String, TaskEntry>(0);
        }
        List<String> allFields = this.getFields(result);
        allFields.add("case when difference >= 0 then 0 else difference end as lossnumber");
        allFields.add("case when difference <= 0 then 0 else difference end as profitnumber");
        result = result.select(allFields.toArray(new String[0]));
        Map<String, TaskEntry> reportEntrys = this.initRowEntrys(result);
        return reportEntrys;
    }

    private Map<String, TaskEntry> initRowEntrys(DataSet result) {
        HashMap<String, TaskEntry> reportEntrys = new HashMap<String, TaskEntry>();
        while (result.hasNext()) {
            TaskEntry reportEntry;
            Row row = result.next();
            Integer precision = row.getInteger("unit.precision");
            BigDecimal inventoryquantity = row.getBigDecimal("inventoryquantity").setScale((int)precision, RoundingMode.HALF_UP);
            BigDecimal bookquantity = row.getBigDecimal("bookquantity").setScale((int)precision, RoundingMode.HALF_UP);
            BigDecimal lossnumber = row.getBigDecimal("lossnumber").setScale((int)precision, RoundingMode.HALF_UP).abs();
            BigDecimal profitnumber = row.getBigDecimal("profitnumber").setScale((int)precision, RoundingMode.HALF_UP).abs();
            String state = row.getString("inventorystate");
            if (reportEntrys.containsKey(row.getString("inventorytask"))) {
                reportEntry = (TaskEntry)reportEntrys.get(row.getString("inventorytask"));
                reportEntry.setRealnumber(reportEntry.getRealnumber().add(inventoryquantity));
                reportEntry.setBookquantity(reportEntry.getBookquantity().add(bookquantity));
                reportEntry.setLossnumber(reportEntry.getLossnumber().add(lossnumber));
                reportEntry.setProfitnumber(reportEntry.getProfitnumber().add(profitnumber));
                if ("A".equals(state) || "C".equals(state)) {
                    reportEntry.setHasInvent(reportEntry.getHasInvent() + 1);
                }
                reportEntry.setTotal(reportEntry.getTotal() + 1);
                continue;
            }
            reportEntry = new TaskEntry();
            reportEntry.setRealnumber(inventoryquantity);
            reportEntry.setBookquantity(bookquantity);
            reportEntry.setLossnumber(lossnumber);
            reportEntry.setProfitnumber(profitnumber);
            reportEntry.setSchemeid(row.getString("inventschemeentry"));
            reportEntry.setTaskid(row.getString("inventorytask"));
            reportEntry.setInventorypercent(0);
            if ("A".equals(state) || "C".equals(state)) {
                reportEntry.setHasInvent(1);
            } else {
                reportEntry.setHasInvent(0);
            }
            reportEntry.setTotal(reportEntry.getTotal() + 1);
            reportEntrys.put(row.getString("inventorytask"), reportEntry);
        }
        return reportEntrys;
    }

    private int getPercentRate(int hasInvent, int total) {
        if (total == 0) {
            return 0;
        }
        BigDecimal percent = new BigDecimal(0);
        percent = new BigDecimal(hasInvent).divide(new BigDecimal(total), 1);
        return percent.intValue();
    }

    private List<String> getFields(DataSet queryDs) {
        if (queryDs == null) {
            return null;
        }
        RowMeta rowMeta = queryDs.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> selFields = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            selFields.add(field.getAlias());
        }
        return selFields;
    }

    private void fillCntAndRate(ArrayList<TaskEntry> schemeEntry) {
        int countPaper = 0;
        int countReal = 0;
        int countLoss = 0;
        int countProfit = 0;
        int length = schemeEntry.size();
        boolean percent = false;
        int hasInvent = 0;
        int total = 0;
        for (int i = 0; i < length; ++i) {
            TaskEntry row = this.getRow(schemeEntry.get(i));
            countPaper += row.getBookquantity().intValue();
            countReal += row.getRealnumber().intValue();
            countLoss += row.getLossnumber().intValue();
            countProfit += row.getProfitnumber().intValue();
            hasInvent += row.getHasInvent();
            total += row.getTotal();
        }
        Label label = (Label)this.getView().getControl("papercnt");
        label.setText(String.valueOf(countPaper));
        Label labelReal = (Label)this.getView().getControl("realcnt");
        labelReal.setText(String.valueOf(countReal));
        Label labelLoss = (Label)this.getView().getControl("losscnt");
        labelLoss.setText(String.valueOf(countLoss));
        Label labelProfit = (Label)this.getView().getControl("profitcnt");
        labelProfit.setText(String.valueOf(countProfit));
        ((ProgressBar)this.getControl("inventoryrate")).setPercent(FaInventoryUtils.getProgressRate(hasInvent, total));
    }

    private void initInventoryScheme(HashMap<String, ArrayList<TaskEntry>> schemeEntrys) {
        IDataModel model = this.getModel();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        BasedataEdit schemeBd = (BasedataEdit)this.getControl("q_inventoryschemeid");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        List<Long> ids = this.getAllSchemeId(schemeEntrys);
        this.getPageCache().put("schemeid", SerializationUtils.toJsonString(ids));
        list.add(new QFilter("id", "in", ids));
        schemeBd.setQFilters(list);
        if (schemeId == null) {
            schemeId = ids.get(ids.size() - 1);
        }
        model.setValue("q_inventoryschemeid", (Object)schemeId);
        DynamicObject schemeDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"fa_inventscheme_new");
        model.setValue("q_createorg", schemeDyn.get("createorg"));
        String refresh = this.getPageCache().get("refreshscheme");
        if (refresh != null) {
            model.setValue("q_inventoryschemeid", (Object)refresh);
        }
    }

    private HashMap<String, ArrayList<TaskEntry>> getSchemeEntrys(List<Long> schemeIds) {
        DynamicObject[] inventoryTasks;
        LinkedHashMap<String, ArrayList<TaskEntry>> schemeEntrys = new LinkedHashMap<String, ArrayList<TaskEntry>>();
        for (DynamicObject inventoryTask : inventoryTasks = BusinessDataServiceHelper.load((String)"fa_inventory_task", (String)"inventsscopeid.inventschemeentry,inventsscopeid.assetunit.name,inventperson.name,status,splitfieldvalue,number", (QFilter[])new QFilter[]{new QFilter("inventschemeid", "in", schemeIds)}, (String)"inventsscopeid.inventschemeentry.createtime")) {
            ArrayList<Object> list;
            String id;
            String splitFieldStr;
            TaskEntry taskEntry = new TaskEntry();
            DynamicObject inventscheme = inventoryTask.getDynamicObject("inventsscopeid.inventschemeentry");
            if (inventscheme == null) continue;
            taskEntry.setNumber(inventoryTask.getString("number"));
            taskEntry.setSchemeid(String.valueOf(inventscheme.getPkValue()));
            taskEntry.setTaskid(String.valueOf(inventoryTask.getPkValue()));
            taskEntry.setAssetunit(inventoryTask.getString("inventsscopeid.assetunit.name"));
            taskEntry.setChargeperson(inventoryTask.getString("inventperson.name"));
            taskEntry.setRealnumber(BigDecimal.ZERO);
            taskEntry.setBookquantity(BigDecimal.ZERO);
            taskEntry.setLossnumber(BigDecimal.ZERO);
            taskEntry.setProfitnumber(BigDecimal.ZERO);
            taskEntry.setHasInvent(0);
            taskEntry.setTotal(0);
            taskEntry.setStatus(inventoryTask.getString("status"));
            Object splitFieldObj = inventoryTask.get("splitfieldvalue");
            if (null != splitFieldObj && StringUtils.isNotEmpty((CharSequence)(splitFieldStr = splitFieldObj.toString()))) {
                taskEntry.setBaseDataMap(FaInventoryUtils.transferSplitFieldValue(splitFieldStr));
            }
            if (schemeEntrys.containsKey(id = String.valueOf(inventscheme.getPkValue()))) {
                list = schemeEntrys.get(id);
                list.add(taskEntry);
                schemeEntrys.put(id, list);
                continue;
            }
            list = new ArrayList();
            list.add(taskEntry);
            schemeEntrys.put(id, list);
        }
        return schemeEntrys;
    }

    private boolean hasInventoryScheme() {
        String appId = AppMetadataCache.getAppInfo((String)"fa").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        this.getPageCache().put("hasPermOrgIds", SerializationUtils.serializeToBase64((Object)orgIds));
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u627e\u5230\u53ef\u8bbf\u95ee\u7684\u76d8\u70b9\u65b9\u6848\u3002", (String)"FaInventoryReportPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public List<Long> getAllSchemeId(HashMap<String, ArrayList<TaskEntry>> inventoryScheme) {
        LinkedList<Long> ids = new LinkedList<Long>();
        for (String key : inventoryScheme.keySet()) {
            ids.add(Long.parseLong(key));
        }
        return ids;
    }

    private String getSelectFields() {
        return "id,inventoryquantity,bookquantity,inventorystate,difference,inventschemeentry,inventorytask,unit.precision";
    }

    private void viewRecord(HyperLinkClickEvent evt) {
        DynamicObject inventSchema;
        int selectRow = evt.getRowIndex();
        String taskid = this.getModel().getEntryRowEntity("entryentity", selectRow).getString("inventorytaskid");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setCustomParam("inventorytaskid", (Object)Long.parseLong(taskid));
        DynamicObject task = QueryServiceHelper.queryOne((String)"fa_inventory_task", (String)"inventsscopeid.assetunit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(taskid))});
        String assetUnitId = String.valueOf(task.getLong("inventsscopeid.assetunit"));
        if (assetUnitId != null) {
            parameter.setCustomParam("inventassetunitid", (Object)assetUnitId);
        }
        if ((inventSchema = (DynamicObject)this.getModel().getValue("q_inventoryschemeid")) != null) {
            String inventSchemaId = String.valueOf(inventSchema.getPkValue());
            parameter.setCustomParam("inventschemaid", (Object)inventSchemaId);
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setBillFormId("fa_inventory_record");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        if ("entryentity".equals(entryname)) {
            this.viewRecord(evt);
        }
    }
}

