/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.split;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaFormCurPeriodBizUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class FaSplitCardBillListPlugin
extends AbstractListPlugin {
    private static final String IS_CLICK_ORG = "isClickOrg";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!FaUtils.isF7((IFormView)this.getView())) {
            HyperLinkClickEvent hyperClick = args.getHyperLinkClickEvent();
            int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
            args.setCancel(true);
            if ("aft_realcard_number".equals(hyperClick.getFieldName())) {
                String cardPk = FaSplitCardBillListPlugin.getRowRealCardNo(rowIndex, this.getView());
                FaUtils.showTabForm((String)"fa_card_fin", (String)ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247", (String)"FaSplitCardBillListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), (Object)cardPk, (IFormView)this.getView());
            } else {
                args.setCancel(false);
            }
        }
    }

    public static String getRowRealCardNo(int rowIndex, IFormView view) {
        ListSelectedRow selectedRow = ((IListView)view).getCurrentListAllRowCollection().get(rowIndex);
        Object billPk = selectedRow.getPrimaryKeyValue();
        Object subEntryPk = selectedRow.getSubEntryPrimaryKeyValue();
        QFilter pkFilter = new QFilter("id", "=", billPk);
        QFilter subFilter = new QFilter("assetsplitentry.subassetsplitentry.ID", "=", subEntryPk);
        QFilter[] filters = new QFilter[]{pkFilter, subFilter};
        String finField = Fa.join((String)".", (String[])new String[]{"assetsplitentry", "subassetsplitentry", "aft_fincard"});
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fa_assetsplitbill", (String)(finField + " as cardid"), (QFilter[])filters);
        if (dys == null || dys.size() == 0) {
            return "";
        }
        return ((DynamicObject)dys.get(0)).getString("cardid");
    }

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        FaFormPermissionUtil.filterContainerInitV2(filtercontainerinitargs, this.getPageCache(), this.getView().getPageId());
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        Object sFilter = paramMap.get("filter");
        QFilter filters = null;
        QFilter[] filters2 = null;
        if (sFilter != null) {
            filters = QFilter.fromSerializedString((String)(sFilter + ""));
            filters2 = filters.recombine();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (FilterColumn listFilter : listFilterColumns) {
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String fieldName = commFilter.getFieldName();
                if (!"splitdate".equals(fieldName)) continue;
                List splitDateDefValues = Stream.of(filters2).filter(v -> "splitdate".equals(v.getProperty())).map(v -> df.format((Date)v.getValue())).collect(Collectors.toList());
                commFilter.setDefaultValues(splitDateDefValues);
            }
        }
        for (FilterColumn listFilter : listFilterColumns) {
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            String fieldName = commFilter.getFieldName();
            if (!"org.id".equals(fieldName) && !"org.number".equals(fieldName) && !"org.name".equals(fieldName)) continue;
            String defaultOrgid = "";
            String orgFilterObjId = (String)paramMap.get("org");
            if (orgFilterObjId != null) {
                defaultOrgid = orgFilterObjId;
                commFilter.setDefaultValue(defaultOrgid);
                this.getPageCache().put("org", defaultOrgid);
                continue;
            }
            String billFormID = ((FilterContainer)filtercontainerinitargs.getFilterContainerInitEvent().getSource()).getEntityId();
            List comboItems = FaPermissionUtils.getAllEnableBookAndPermissionOrgsCombosV2((String)this.getView().getPageId(), (String)billFormID);
            commFilter.setComboItems(comboItems);
            if (null == comboItems || comboItems.size() <= 0) continue;
            defaultOrgid = this.getDefaultId(comboItems);
            this.getPageCache().put("org", defaultOrgid);
            if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(IS_CLICK_ORG))) continue;
            commFilter.setDefaultValue(defaultOrgid);
            commFilter.setDefValue(defaultOrgid);
            if (sFilter == null) continue;
            String transOrg = Stream.of(filters2).filter(v -> v.getProperty().equalsIgnoreCase("org")).map(v -> v.getValue()).map(Object::toString).reduce("", String::concat);
            commFilter.setDefaultValue(transOrg);
        }
    }

    private String getDefaultId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("org.id".equals(field) || "org.number".equals(field) || "org.name".equals(field)) {
            List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_assetsplitbill");
            e.getQfilters().add(new QFilter("id", "in", (Object)orgIds));
        } else if ("split_realcard.number".equals(field)) {
            List qFilters = e.getQfilters();
            List assetUnits = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_assetsplitbill");
            qFilters.add(new QFilter("assetunit", "in", (Object)assetUnits));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object sFilter = this.getView().getFormShowParameter().getCustomParams().get("filter");
        if (sFilter != null) {
            e.getQFilters().add(QFilter.fromSerializedString((String)(sFilter + "")));
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        Object pkValue;
        DynamicObject[] queryValues = e.getQueryValues();
        this.setAutoCarryIsFalse(queryValues);
        DataEntityPropertyCollection properties = queryValues[0].getDataEntityType().getProperties();
        if (properties.containsKey((Object)"assetsplitentry")) {
            return;
        }
        HashSet<Object> splitCardPks = new HashSet<Object>(queryValues.length);
        for (DynamicObject queryValue : queryValues) {
            splitCardPks.add(queryValue.getPkValue());
        }
        String field = Fa.comma((String[])new String[]{"splittype", "assetsplitentry", "subassetsplitentry", "aft_assetamount", "aft_originalval"});
        DynamicObject[] exportData = BusinessDataServiceHelper.load((String)"fa_assetsplitbill", (String)field, (QFilter[])new QFilter[]{new QFilter("id", "in", splitCardPks)});
        HashMap<Object, String> splitBillIdAndSplitRate = new HashMap<Object, String>(exportData.length);
        for (DynamicObject splitBill : exportData) {
            pkValue = splitBill.getPkValue();
            String splitType = splitBill.getString("splittype");
            DynamicObject befSplitEntry = (DynamicObject)splitBill.getDynamicObjectCollection("assetsplitentry").get(0);
            DynamicObjectCollection aftSplitEntry = befSplitEntry.getDynamicObjectCollection("subassetsplitentry");
            String valuesFiled = "A".equals(splitType) ? "aft_assetamount" : "aft_originalval";
            StringBuilder splitRate = new StringBuilder();
            for (DynamicObject aftSplit : aftSplitEntry) {
                BigDecimal value = aftSplit.getBigDecimal(valuesFiled);
                String childRate = value.stripTrailingZeros().toPlainString();
                splitRate.append(":").append(childRate);
            }
            splitBillIdAndSplitRate.put(pkValue, splitRate.substring(1));
        }
        for (DynamicObject queryValue : queryValues) {
            pkValue = queryValue.getPkValue();
            String splitRate = (String)splitBillIdAndSplitRate.get(pkValue);
            queryValue.set("splitrate", (Object)splitRate);
        }
    }

    private void setAutoCarryIsFalse(DynamicObject[] queryValues) {
        for (DynamicObject queryValue : queryValues) {
            DataEntityPropertyCollection properties = queryValue.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                if (!name.equals("isautocarry")) continue;
                queryValue.set("isautocarry", (Object)Boolean.FALSE);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if ("new".equals(operationKey)) {
            if (FaBillParamUtils.getBooleanValue(null, null, null, (String)"SplitGuideSwitch")) {
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fa_splitcardguide"));
            showParameter.setFormId("fa_splitcardguide");
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setHasRight(true);
            showParameter.setCustomParam("SplitBillPageId", (Object)this.getView().getPageId());
            this.getView().showForm(showParameter);
            evt.setCancel(true);
        } else if ("submit".equals(operationKey)) {
            FaFormCurPeriodBizUtils.showGuideConfirm4List(evt, this.getView(), "fa_assetsplitbill", (IFormPlugin)this);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        FaFormCurPeriodBizUtils.guideConfirmCallBack(messageBoxClosedEvent, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"fa_splitcardguide") && returnData != null) {
            this.getPageCache().put("fa_splitcardguide", SerializationUtils.serializeToBase64((Object)returnData));
            this.getView().invokeOperation("new");
        }
    }
}

