/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.split;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.utils.StringUtils;

public class FaSplitScaleEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_SPLITSCALE = "splitscale_tag";
    private static int arrayListSize = 10;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeBindData(EventObject e) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setInitData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTNOK.equalsIgnoreCase(ctlSource.getKey())) {
            List<BigDecimal> scaleData = this.getSetData();
            if (scaleData.size() > 0) {
                this.setReturnData();
            }
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private void setInitData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String splitType = (String)formShowParameter.getCustomParam("splittype");
        this.getModel().setValue("splittype", (Object)splitType);
        if (formShowParameter.getCustomParam("splitqty") != null) {
            long splitQty = Long.parseLong(formShowParameter.getCustomParam("splitqty").toString());
            this.getModel().setValue("splitqty", (Object)splitQty);
        }
    }

    private List<BigDecimal> getSetData() {
        String[] scaleArr;
        IDataModel model = this.getModel();
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(arrayListSize);
        String splitScaleStr = model.getValue(KEY_SPLITSCALE).toString().trim();
        if (StringUtils.isEmpty((String)splitScaleStr)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitScaleEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return result;
        }
        splitScaleStr = splitScaleStr.replace("\uff1a", ":").trim();
        for (String scaleStr : scaleArr = splitScaleStr.split(":")) {
            if (StringUtils.isEmpty((String)scaleStr) || !this.isValidBigDecimal(scaleStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6bd4\u4f8b\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"FaSplitScaleEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return new ArrayList<BigDecimal>();
            }
            BigDecimal scale = new BigDecimal(scaleStr);
            if (scale.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6bd4\u4f8b\u503c\u5b58\u5728\u8d1f\u6570\u3002", (String)"FaSplitScaleEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return new ArrayList<BigDecimal>();
            }
            result.add(scale);
        }
        long splitQty = Long.parseLong(model.getValue("splitqty").toString());
        if ((long)result.size() != splitQty) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6570\u91cf\u548c\u62c6\u5206\u6bd4\u4f8b\u6570\u91cf\u4e0d\u4e00\u81f4\u3002", (String)"FaSplitScaleEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return new ArrayList<BigDecimal>();
        }
        return result;
    }

    private void setReturnData() {
        IDataModel model = this.getModel();
        String splitScaleStr = model.getValue(KEY_SPLITSCALE).toString();
        String result = this.formatResult(splitScaleStr);
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }

    String formatResult(String str) {
        String splitScaleStr = str.replace("\uff1a", ":").trim();
        String[] scaleArr = splitScaleStr.split(":");
        List scaleList = Arrays.asList(scaleArr).stream().filter(scale -> !StringUtils.isEmpty((String)scale)).collect(Collectors.toList());
        String result = String.join((CharSequence)":", scaleList);
        return result;
    }

    boolean isValidBigDecimal(String str) {
        try {
            BigDecimal v = new BigDecimal(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

