/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaFinCardUtil;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.common.util.Fa;

public class AddUpYearDepreUtils {
    private static final Log logger = LogFactory.getLog(AddUpYearDepreUtils.class);

    public static void handleAddupYeardepreListField(DynamicObjectCollection rows, String formId) {
        if (rows.isEmpty() || formId == null || "".equals(formId)) {
            return;
        }
        HashMap<Long, DynamicObject> finCardId2DynObjMap = new HashMap<Long, DynamicObject>(rows.size());
        boolean isNotHaveAddupyeardepreField = Boolean.FALSE;
        if ("fa_card_fin".equals(formId)) {
            DynamicObject dynamicObject = (DynamicObject)rows.get(0);
            isNotHaveAddupyeardepreField = !dynamicObject.containsProperty("addupyeardepre");
            for (DynamicObject row : rows) {
                finCardId2DynObjMap.put((Long)row.getPkValue(), row);
            }
        } else if ("fa_asset_card".equals(formId)) {
            ArrayList<DynamicObject> assetCardFinList = new ArrayList<DynamicObject>(16);
            for (DynamicObject FaAssetCardRow : rows) {
                DynamicObject finCard = FaAssetCardRow.getDynamicObject(Fa.dot((String[])new String[]{"finentry", "fincard"}));
                if (Objects.isNull(finCard)) continue;
                assetCardFinList.add(finCard);
                finCardId2DynObjMap.put((Long)finCard.getPkValue(), FaAssetCardRow);
            }
            if (assetCardFinList.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)assetCardFinList.get(0);
                isNotHaveAddupyeardepreField = !dynamicObject.containsProperty("addupyeardepre");
            }
        } else {
            logger.info("\u672a\u77e5\u7684\u5355\u636e, \u6682\u4e0d\u5904\u7406\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u5b57\u6bb5");
            return;
        }
        if (isNotHaveAddupyeardepreField) {
            logger.info("\u5305\u542b\u3010\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u3011\u5b57\u6bb5, \u5219\u4e0d\u505a\u7279\u6b8a\u5904\u7406");
            return;
        }
        List<Long> addupyeardepreSetZeroFinCardIdList = AddUpYearDepreUtils.getAddupyeardepreSetZeroFinCardIdList(finCardId2DynObjMap);
        for (Long findCardId : addupyeardepreSetZeroFinCardIdList) {
            DynamicObject dynamicObject = (DynamicObject)finCardId2DynObjMap.get(findCardId);
            if (Objects.isNull(dynamicObject)) continue;
            if ("fa_card_fin".equals(formId)) {
                dynamicObject.set("addupyeardepre", (Object)BigDecimal.ZERO);
            }
            if (!"fa_asset_card".equals(formId)) continue;
            dynamicObject.set(Fa.dot((String[])new String[]{"finentry", "fin_addupyeardepre"}), (Object)BigDecimal.ZERO);
        }
    }

    public static List<Long> getAddupyeardepreSetZeroFinCardIdList(Map<Long, DynamicObject> id2FinCardMap) {
        String selectFields = String.join((CharSequence)",", "id", "assetbook", "endperiod", "bizperiod", "period");
        DynamicObjectCollection finCardDynObjList = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])new QFilter("id", "in", id2FinCardMap.keySet()).toArray());
        Map<Long, DynamicObject> assetBookId2AssetBookMap = AddUpYearDepreUtils.getAssetBookId2AssetBookMap(finCardDynObjList);
        ArrayList<Long> addupyeardepreSetZeroFinCardIdList = new ArrayList<Long>(finCardDynObjList.size());
        for (DynamicObject finCard : finCardDynObjList) {
            DynamicObject assetBookDynObj;
            long endPeriodId = finCard.getLong("endperiod");
            if (99999999999L != endPeriodId || Objects.isNull(assetBookDynObj = assetBookId2AssetBookMap.get(finCard.getLong("assetbook")))) continue;
            long assetBookStartPeriod = (Long)assetBookDynObj.getDynamicObject("startperiod").getPkValue();
            long assetBookCurPeriodId = (Long)assetBookDynObj.getDynamicObject("curperiod").getPkValue();
            Long finCardId = (Long)finCard.get("id");
            Long bizPeriodId = finCard.getLong("bizperiod");
            long finCardPeriodId = finCard.getLong("period");
            boolean isSetAddUpYearDepreZero = AddUpYearDepreUtils.isSetAddUpYearDepreZero(bizPeriodId, endPeriodId, assetBookStartPeriod, assetBookCurPeriodId, finCardPeriodId);
            if (!isSetAddUpYearDepreZero) continue;
            addupyeardepreSetZeroFinCardIdList.add(finCardId);
        }
        return addupyeardepreSetZeroFinCardIdList;
    }

    public static boolean isSetAddUpYearDepreZero(Long bizPeriodId, Long endPeriodId, Long assetBookStartPeriod, Long periodId, Long finCardPeriodId) {
        int bizPeriodYear;
        if (FaFinCardUtil.isInitFinCard((long)finCardPeriodId) && bizPeriodId == 0L) {
            bizPeriodId = assetBookStartPeriod;
        }
        if (bizPeriodId >= periodId) {
            return Boolean.FALSE;
        }
        int currentPeriodYear = PeriodUtil.getYearByPeriodId((Object)periodId);
        if (currentPeriodYear != (bizPeriodYear = PeriodUtil.getYearByPeriodId((Object)bizPeriodId))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Map<Long, DynamicObject> getAssetBookId2AssetBookMap(DynamicObjectCollection finCardDynObjList) {
        HashSet<Long> assetBookIdSet = new HashSet<Long>(16);
        for (DynamicObject finCard : finCardDynObjList) {
            assetBookIdSet.add(finCard.getLong("assetbook"));
        }
        QFilter fAssetBookId = new QFilter("id", "in", assetBookIdSet);
        String selectProperties = String.join((CharSequence)",", "id", "curperiod", "startperiod");
        Map assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectProperties, (QFilter[])new QFilter[]{fAssetBookId});
        HashMap<Long, DynamicObject> assetBookId2AssetBookMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject assetBookDynObj : assetBooksMap.values()) {
            Long assetBookId = (Long)assetBookDynObj.getPkValue();
            assetBookId2AssetBookMap.put(assetBookId, assetBookDynObj);
        }
        return assetBookId2AssetBookMap;
    }
}

