/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FaAssetTypeUtils {
    private static final long EMPTYID = -9999999L;

    public static Map<Long, Long> getAssetTypeMap(DynamicObject[] categroyArr) {
        if (categroyArr == null || categroyArr.length == 0) {
            categroyArr = BusinessDataServiceHelper.load((String)"fa_assetcategory", (String)"id,parent", null);
        }
        HashMap<Long, Long> assetTypeMap = new HashMap<Long, Long>(categroyArr.length);
        int length = categroyArr.length;
        for (int i = 0; i < length; ++i) {
            Long id = categroyArr[i].getLong("id");
            Long parent = categroyArr[i].getLong("parent.id");
            if (parent == null || parent == 0L) {
                parent = 0L;
            }
            assetTypeMap.put(id, parent);
        }
        return assetTypeMap;
    }

    public static Map<Long, List<Long>> getSubAssetTypeMap() {
        return FaAssetTypeUtils.getSubAssetTypeMap(null);
    }

    public static Map<Long, List<Long>> getSubAssetTypeMap(DynamicObject[] categroys) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        Map<Long, Long> assetTypeMap = FaAssetTypeUtils.getAssetTypeMap(categroys);
        for (Map.Entry<Long, Long> entry : assetTypeMap.entrySet()) {
            ArrayList<Long> childs;
            Long curKey = entry.getValue();
            Long curValue = entry.getKey();
            if (curKey == 0L) {
                curKey = curValue;
            }
            if (result.containsKey(curKey)) {
                ((List)result.get(curKey)).add(curValue);
            } else {
                childs = new ArrayList<Long>();
                childs.add(curValue);
                result.put(curKey, childs);
            }
            if (!result.containsKey(curValue)) {
                childs = new ArrayList();
                childs.add(curValue);
                result.put(curValue, childs);
                continue;
            }
            if (((List)result.get(curValue)).contains(curValue)) continue;
            ((List)result.get(curValue)).add(curValue);
        }
        return result;
    }

    public static List<Long> getAllSubAssetTypes(List<Long> ids) {
        return FaAssetTypeUtils.getAllSubAssetTypes(null, ids);
    }

    public static List<Long> getAllSubAssetTypes(DynamicObject[] categroys, List<Long> ids) {
        ArrayList<Long> result = new ArrayList<Long>();
        Map<Long, List<Long>> subAssetTypeMap = FaAssetTypeUtils.getSubAssetTypeMap(categroys);
        for (Long id : ids) {
            if (!subAssetTypeMap.containsKey(id)) continue;
            List<Long> curAllSubChilds = FaAssetTypeUtils.getAllSubAssetTypes(subAssetTypeMap, id);
            result.addAll(curAllSubChilds);
        }
        return result;
    }

    public static List<Long> getAllSubAssetTypes(Map<Long, List<Long>> assetTypes, Long id) {
        List<Long> result = new ArrayList<Long>();
        LinkedList<Long> queue = new LinkedList<Long>();
        result.add(id);
        List<Long> firstChilds = assetTypes.get(id);
        if (firstChilds == null) {
            return result;
        }
        queue.addAll(firstChilds);
        result.addAll(firstChilds);
        while (!queue.isEmpty()) {
            Long curId = (Long)queue.poll();
            List<Long> curChilds = assetTypes.get(curId);
            if ((curChilds = FaAssetTypeUtils.removeParent(curChilds, curId)) == null) continue;
            queue.addAll(curChilds);
            result.addAll(curChilds);
        }
        result = result.stream().distinct().collect(Collectors.toList());
        return result;
    }

    static List<Long> removeParent(List<Long> childs, Long parentId) {
        if (childs == null || childs.size() == 0) {
            return new ArrayList<Long>();
        }
        return childs.stream().filter(id -> !id.equals(parentId)).collect(Collectors.toList());
    }
}

