/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.HashSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class FaChangeBillUtils {
    private static Log log = LogFactory.getLog(FaChangeBillUtils.class);

    public static Tuple<IDataEntityProperty, Boolean> parseField(String fieldDisplayName) {
        boolean isRealProp = false;
        MainEntityType realType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        MainEntityType finType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
        IDataEntityProperty prop = FaChangeBillUtils.getPropertyByDisplayName(realType, fieldDisplayName);
        if (prop != null) {
            isRealProp = true;
        } else {
            prop = FaChangeBillUtils.getPropertyByDisplayName(finType, fieldDisplayName);
        }
        if (prop == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u5361\u7247\u4e0d\u5b58\u5728\u540d\u4e3a\u3010%s\u3011\u7684\u5b57\u6bb5\u3002", (String)"FaChangeBillUtils_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), fieldDisplayName));
        }
        return new Tuple((Object)prop, (Object)isRealProp);
    }

    private static IDataEntityProperty getPropertyByDisplayName(MainEntityType type, String fieldDisplayName) {
        DataEntityPropertyCollection properties = type.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop.getDisplayName() != null && fieldDisplayName.equals(type.getExtendName() + "." + prop.getName())) {
                return prop;
            }
            if (prop.getDisplayName() == null || !fieldDisplayName.equals(prop.getDisplayName().getLocaleValue())) continue;
            return prop;
        }
        return null;
    }

    public static Tuple<IDataEntityProperty, Boolean> parseField(String fieldDisplayName, DynamicObject changeType) {
        Long changeTypeId = changeType.getLong("id");
        String cacheKey = "fa_change_type_" + changeTypeId + "_" + fieldDisplayName;
        log.info("fieldDisplayName : {}; changeType : {}", (Object)fieldDisplayName, (Object)changeType);
        return (Tuple)ThreadCache.get((Object)cacheKey, () -> {
            boolean isRealProp = false;
            DynamicObjectCollection changeTypeEntryList = changeType.getDynamicObjectCollection("changetypeentry");
            HashSet changeItemIdSet = new HashSet(changeTypeEntryList.size());
            changeTypeEntryList.stream().forEach(t -> changeItemIdSet.add(t.getDynamicObject("changeitem").getLong("id")));
            DynamicObjectCollection changeItemList = QueryServiceHelper.query((String)"fa_change_item", (String)Fa.comma((String[])new String[]{"topic", "name", "number"}), (QFilter[])new QFilter[]{new QFilter("id", "in", changeItemIdSet)});
            for (DynamicObject changeItem : changeItemList) {
                String topic = changeItem.getString("topic");
                String number = changeItem.getString("number");
                String name = changeItem.getString("name");
                if (!fieldDisplayName.equals(name) && !fieldDisplayName.equals(topic + "." + number) && !fieldDisplayName.equals(number)) continue;
                isRealProp = "fa_card_real".equals(topic);
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)(isRealProp ? "fa_card_real" : "fa_card_fin"));
            IDataEntityProperty prop = FaChangeBillUtils.getPropertyByDisplayName(entityType, fieldDisplayName);
            if (prop == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u3010%1$s\u3011\u4e0d\u5b58\u5728\u540d\u4e3a\u3010%2$s\u3011\u7684\u5b57\u6bb5\u3002", (String)"FaChangeBillUtils_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), entityType.getName(), fieldDisplayName));
            }
            return new Tuple((Object)prop, (Object)isRealProp);
        });
    }
}

