/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;

public class FaF7CostCenterUtils {
    private static final String ORG = "accountorg";

    public static void beforeCostCenterSelect(BeforeF7SelectEvent evt, DynamicObject org) {
        boolean departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharing((DynamicObject)org);
        if (!departSharing) {
            List customQFilters = evt.getCustomQFilters();
            customQFilters.add(new QFilter(ORG, "=", org.getPkValue()));
        }
    }

    public static boolean checkCostCenterHasValidator4Org(long orgId, long costCenterId) {
        boolean departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharingByOrgId((long)orgId);
        if (departSharing) {
            return true;
        }
        Set costCenterIds = (Set)ThreadCache.get((Object)("org_costCenter" + orgId), () -> {
            DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{new QFilter(ORG, "=", (Object)orgId), new QFilter("enable", "=", (Object)true)});
            return costCenters.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        }, (boolean)true);
        return costCenterIds.contains(costCenterId);
    }
}

