/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;

public class FaFabulousOperation {
    public static final String URL = "/icons/pc/state/praised.png";

    public static Map<Long, Integer> getFabulous(List<Long> tagetUserID, String formid, boolean isTodyDay, boolean isAll) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        QFilter tagetUserFilter = new QFilter("bythumbupuser", "in", tagetUserID);
        if (StringUtils.isNotBlank((CharSequence)formid)) {
            QFilter formidFilter = new QFilter("sourcebillnumber", "=", (Object)formid);
            qfilters.add(formidFilter);
        }
        qfilters.add(tagetUserFilter);
        FaFabulousOperation.processDateFilter(isTodyDay, qfilters);
        FaFabulousOperation.processPersonFabulous(isAll, qfilters);
        return FaFabulousOperation.getData(qfilters, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Integer> getData(List<QFilter> filters, String order, int top) {
        DataSet dataSet = null;
        DataSet result = null;
        DataSet orderResult = null;
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"gl.getFabulous", (String)"gl_fabulous", (String)"id,bythumbupuser", (QFilter[])filters.toArray(new QFilter[0]), null);
            GroupbyDataSet groupByDataSet = dataSet.groupBy(new String[]{"bythumbupuser"});
            groupByDataSet.count();
            result = groupByDataSet.finish();
            orderResult = "DESC".equalsIgnoreCase(order) ? result.orderBy(new String[]{"count desc"}) : ("ASC".equalsIgnoreCase(order) ? result.orderBy(new String[]{"count"}) : result);
            Iterator iterator = orderResult.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                map.put(row.getLong("bythumbupuser"), row.getInteger("count"));
                if (top <= 0 || ++count <= top) continue;
                break;
            }
        }
        finally {
            if (orderResult != null) {
                orderResult.close();
            }
            if (result != null) {
                result.close();
            }
            if (dataSet != null) {
                dataSet.close();
            }
        }
        return map;
    }

    public static Map<Long, Integer> getFabulousTop(String formid, boolean isTodyDay, boolean isAll, String order, int top) throws Exception {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        QFilter formidFilter = new QFilter("sourcebillnumber", "=", (Object)formid);
        qfilters.add(formidFilter);
        FaFabulousOperation.processDateFilter(isTodyDay, qfilters);
        FaFabulousOperation.processPersonFabulous(isAll, qfilters);
        return FaFabulousOperation.getData(qfilters, order, top);
    }

    public static void processDateFilter(boolean isTodyDay, List<QFilter> qfilters) {
        if (isTodyDay) {
            qfilters.add(new QFilter("createdate", "=", (Object)DateUtil.getDateFormat((Date)new Date(), (boolean)true)));
        }
    }

    public static void processPersonFabulous(boolean isAll, List<QFilter> qfilters) {
        if (!isAll) {
            qfilters.add(new QFilter("thumbupuser", "=", (Object)ContextUtil.getUserId()));
        }
    }

    public static int getFabulousOne(Long targetUserId, String formid, boolean isTodyDay, boolean isAll) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(targetUserId);
        Map<Long, Integer> map = FaFabulousOperation.getFabulous(idList, formid, isTodyDay, isAll);
        return map.get(targetUserId) == null ? 0 : map.get(targetUserId);
    }

    public static boolean isThumbUp(long targetUserId, String formid) {
        return FaFabulousOperation.getFabulousOne(targetUserId, formid, true, false) < 1;
    }

    public static boolean isCanThumbUp(long targetUserId, String formid) {
        long userid = ContextUtil.getUserId();
        return targetUserId == 0L || targetUserId == userid ? false : FaFabulousOperation.isThumbUp(targetUserId, formid);
    }

    public static Object[] createFabulous(long targetUserId, String formid) {
        DynamicObject fabulous = BusinessDataServiceHelper.newDynamicObject((String)"gl_fabulous");
        Long userid = ContextUtil.getUserId();
        fabulous.set("bythumbupuser", (Object)targetUserId);
        fabulous.set("thumbupuser", (Object)userid);
        fabulous.set("sourcebillnumber", (Object)formid);
        fabulous.set("createdate", (Object)DateUtil.getDateFormat((Date)new Date(), (boolean)true));
        return BusinessDataWriter.save((IDataEntityType)fabulous.getDataEntityType(), (Object[])new Object[]{fabulous});
    }
}

