/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.TypeConverUtil;

public class FaQFilter {
    private static final String PARAM = "realCardF7EnableLookAtDoingBusiness";
    private static final List<String> canSelectLeaseCardBills = Arrays.asList("fa_asset_devalue", "fa_depreadjustbill", "fa_change_dept");

    private FaQFilter() {
    }

    public static void realCardQFilter(IDataModel model, BeforeF7SelectEvent e) {
        Long orgId;
        String name = model.getDataEntityType().getName();
        ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
        ListFilterParameter filterParam = showParam.getListFilterParameter();
        List qFilters = filterParam.getQFilters();
        switch (name) {
            case "fa_asset_requisition": {
                orgId = FaQFilter.assetRequisitionQFilter(model, qFilters);
                break;
            }
            case "fa_dispatch": {
                orgId = FaQFilter.dispatchQFilter(model, qFilters);
                break;
            }
            case "fa_clearapplybill": {
                orgId = FaQFilter.clearApplyQFilter(model, qFilters);
                break;
            }
            case "fa_clearbill": {
                orgId = FaQFilter.clearBillQFilter(model, qFilters);
                break;
            }
            case "fa_asset_devalue": {
                orgId = FaQFilter.assetDevalueQFilter(model, qFilters);
                break;
            }
            case "fa_assetsplitbill": {
                orgId = FaQFilter.splitCardQFilter(model, qFilters);
                break;
            }
            case "fa_depreadjustbill": {
                orgId = FaQFilter.depreAdjustQFilter(model, qFilters);
                break;
            }
            case "fa_mergebill": {
                orgId = FaQFilter.mergeBillQFilter(model, qFilters);
                break;
            }
            case "fa_engineeringbill": {
                orgId = FaQFilter.engineeringBillQFilter(model, qFilters);
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u6682\u4e0d\u652f\u6301\u5b9e\u7269\u5361\u7247\u8fc7\u6ee4\u3002", (String)"FaQFilter_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
        FaQFilter.realCardF7CommonFilter(qFilters, orgId, name);
    }

    public static void realCardF7CommonFilter(List<QFilter> qFilters, Long orgId, String entryName) {
        qFilters.add(new QFilter("isbak", "=", (Object)Boolean.FALSE));
        qFilters.add(new QFilter("justrealcard", "=", (Object)Boolean.FALSE));
        if (!canSelectLeaseCardBills.contains(entryName)) {
            qFilters.add(new QFilter("sourceflag", "not in", Arrays.asList(SourceFlagEnum.LEASECONTRACT.name(), SourceFlagEnum.INITLEASECONTRACT.name())));
        }
        qFilters.add(FaQFilter.getRealCardBizStatusQFilter(orgId, entryName));
    }

    private static Long assetRequisitionQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "entryentity", "real_card");
        DynamicObject assetOrg = (DynamicObject)model.getValue("assetorg");
        long orgId = assetOrg.getLong("id");
        qFilters.add(new QFilter("assetunit", "=", (Object)orgId));
        qFilters.add(new QFilter("isstoraged", "=", (Object)true));
        qFilters.add(new QFilter("sourceflag", "!=", (Object)SourceFlagEnum.DATAASSET.name()));
        return orgId;
    }

    private static Long dispatchQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "dispatchentry", "realcard");
        DynamicObject assetUnit = (DynamicObject)model.getValue("assetunit");
        if (assetUnit != null) {
            qFilters.add(new QFilter("assetunit", "=", (Object)Long.parseLong(String.valueOf(assetUnit.getPkValue()))));
        }
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long clearApplyQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "clrapplybill_entry", "realcard");
        DynamicObject assetUnit = (DynamicObject)model.getValue("assetunit");
        if (assetUnit != null) {
            qFilters.add(new QFilter("assetunit", "=", (Object)TypeConverUtil.ObjToLong((Object)assetUnit.getPkValue())));
        }
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long clearBillQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "detail_entry", "realcard");
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long assetDevalueQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "changebillentry", "realcard");
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long splitCardQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "assetsplitentry", "realcard");
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long depreAdjustQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "entryentity", "realcard");
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long mergeBillQFilter(IDataModel model, List<QFilter> qFilters) {
        DynamicObject mergeBill = model.getDataEntity();
        Long orgId = mergeBill.getLong(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static Long engineeringBillQFilter(IDataModel model, List<QFilter> qFilters) {
        FaQFilter.excludeBillExistsCardIds(model, qFilters, "assetsentrychange", "realcardid");
        long orgId = (Long)model.getValue(Fa.id((String)"org"));
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        return orgId;
    }

    private static void excludeBillExistsCardIds(IDataModel model, List<QFilter> qFilters, String entryKey, String cardField) {
        DynamicObjectCollection entryEntity = model.getDataEntity(true).getDynamicObjectCollection(entryKey);
        if (entryEntity == null) {
            return;
        }
        Set cardIds = entryEntity.stream().filter(v -> v.get(cardField) != null).map(v -> v.get(Fa.id((String)cardField))).collect(Collectors.toSet());
        if (!cardIds.isEmpty()) {
            qFilters.add(new QFilter("id", "not in", cardIds));
        }
    }

    public static QFilter getRealCardBizStatusQFilter(Long orgId, String entityName) {
        boolean hasOpen = FaBillParamUtils.getBooleanValue((Long)orgId, null, (String)entityName, (String)PARAM);
        if (hasOpen) {
            return new QFilter("bizstatus", "not in", (Object)new String[]{BizStatusEnum.ADD.name(), BizStatusEnum.DELETE.name()});
        }
        return new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY.name());
    }
}

