/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.util.StringUtils;

public class FaRealCardFieldUtil {
    private Map<String, String> nameTypeMap = new HashMap<String, String>(50);

    public List<String> getStandardList() {
        ArrayList<String> permitList = new ArrayList<String>();
        permitList.add("assetcat");
        permitList.add("storeplacegroup");
        return permitList;
    }

    public FaRealCardFieldUtil() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        Map fieldsMap = mainType.getFields();
        for (Map.Entry property : fieldsMap.entrySet()) {
            DynamicProperty prop = (DynamicProperty)property.getValue();
            String type = prop.getClass().toString();
            String name = prop.getName();
            this.nameTypeMap.put(name, type);
        }
    }

    public boolean check(String name, String type) {
        if (this.getStandardList().contains(name)) {
            return true;
        }
        if (this.nameTypeMap.containsKey(name)) {
            String realCardType = this.nameTypeMap.get(name);
            return !realCardType.equals(type);
        }
        return true;
    }

    public String getPropName(String dimension) {
        if (StringUtils.isEmpty((String)dimension)) {
            return null;
        }
        Set<String> keys = this.nameTypeMap.keySet();
        for (String key : keys) {
            if (!dimension.contains(key)) continue;
            return key;
        }
        return null;
    }
}

