/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.ContextUtil;

public class FapHomeUtil {
    private static final String HOVER_ASSETNAME = "hov_assetname";
    private static final String HOVER_NUMBER = "hov_number";
    private static final String HOVER_MODEL = "hov_model";
    private static final String HOVER_TIME = "hov_time";
    private static final String ASSET_NAME = "assetname";
    private static final String ASSET_IMG = "assetimg";
    private static final String ASSET_ID = "realcardid";
    private static final String ASSET_STATUS = "cardstatus";
    private static final String ASSET_UNIT = "assetunit";
    private static final String ASSET_STOREPLACE = "storeplace";

    public static void loadData(IDataModel dataModel) {
        List<QFilter> qFilters = FapHomeUtil.getQfilters();
        DynamicObjectCollection loadsCollection = QueryServiceHelper.query((String)"fa_card_real", (String)"id,assetunit,storeplace,number,assetname,model,picturefield,bizstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        DynamicObject[] loads = (DynamicObject[])loadsCollection.toArray((Object[])new DynamicObject[0]);
        LinkedList realcardIds = new LinkedList();
        Stream.of(loads).forEach(load -> realcardIds.add(load.get("id")));
        QFilter qCardId = new QFilter("entryentity.real_card", "in", realcardIds);
        Map reqsMap = BusinessDataServiceHelper.loadFromCache((String)"fa_asset_requisition", (String)"auditdate,entryentity.real_card", (QFilter[])new QFilter[]{qCardId});
        DynamicObject[] reqs = new DynamicObject[reqsMap.size()];
        int i = 0;
        for (Map.Entry entryItem : reqsMap.entrySet()) {
            reqs[i++] = (DynamicObject)entryItem.getValue();
        }
        HashMap<Long, String> id_auditdates = new HashMap<Long, String>();
        String formatStr = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        for (DynamicObject req : reqs) {
            DynamicObjectCollection entryentitys = req.getDynamicObjectCollection("entryentity");
            Date auditdate = req.getDate("auditdate");
            entryentitys.stream().forEach(entry -> {
                String dateString = "";
                if (auditdate != null) {
                    dateString = sdf.format(auditdate);
                }
                id_auditdates.put((Long)entry.getDynamicObject("real_card").getPkValue(), dateString);
            });
        }
        FapHomeUtil.setEntry(loads, id_auditdates, dataModel);
    }

    public static void setEntry(DynamicObject[] loads, HashMap<Long, String> id_auditdates, IDataModel dataModel) {
        dataModel.deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(HOVER_ASSETNAME, new Object[0]);
        vs.addField(HOVER_NUMBER, new Object[0]);
        vs.addField(HOVER_MODEL, new Object[0]);
        vs.addField(HOVER_TIME, new Object[0]);
        vs.addField(ASSET_NAME, new Object[0]);
        vs.addField(ASSET_IMG, new Object[0]);
        vs.addField(ASSET_ID, new Object[0]);
        vs.addField(ASSET_STATUS, new Object[0]);
        vs.addField(ASSET_UNIT, new Object[0]);
        vs.addField(ASSET_STOREPLACE, new Object[0]);
        int length = loads.length;
        for (int i = 0; i < length; ++i) {
            String picturefield = loads[i].getString("picturefield");
            if (StringUtils.isEmpty((String)picturefield)) {
                String rootUrl = UrlService.getDomainContextUrl();
                if (rootUrl.endsWith("/")) {
                    rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
                }
                picturefield = rootUrl + "/images/pc/other/rrzc_mrtp.png";
            }
            if (loads[i].get(ASSET_UNIT) == null || loads[i].get(ASSET_STOREPLACE) == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a%s\u7684\u5361\u7247\u627e\u4e0d\u5230\u8d44\u4ea7\u7ec4\u7ec7\u6216\u5b58\u653e\u5730\u70b9\u3002", (String)"FapHomeUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), loads[i].getString("number")));
            }
            vs.addRow(new Object[]{loads[i].getString(ASSET_NAME), loads[i].get("number"), loads[i].getString("model"), id_auditdates.get((Long)loads[i].get("id")), loads[i].getString(ASSET_NAME), picturefield, loads[i].getString("id"), loads[i].getString("bizstatus"), loads[i].get(ASSET_UNIT), loads[i].get(ASSET_STOREPLACE)});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
    }

    private static List<QFilter> getQfilters() {
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter("headuseperson", "=", (Object)ContextUtil.getUserId()));
        qFilters.add(new QFilter("isbak", "=", (Object)false));
        qFilters.add(new QFilter("isstoraged", "=", (Object)false));
        qFilters.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return qFilters;
    }
}

