/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.business.utils.FaAssertOrgUtil;
import kd.fi.fa.business.utils.FaUserUtils;
import org.apache.log4j.Logger;

public class FapUtils {
    private static Logger log = Logger.getLogger(FapUtils.class);
    private static final String SUB_CNT = "subcnt";
    private static final String GET_CNT = "getcnt";

    public static Map<String, Integer> getAssetApplyCount(String[] ALL_CNT, String algoKey, String entityKey, QFilter[] qfilters) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(ALL_CNT.length);
        for (String cnt : ALL_CNT) {
            result.put(cnt, 0);
        }
        String selectField = "id,billstatus";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityKey, (String)selectField, (QFilter[])qfilters, null).groupBy(new String[]{"billstatus"}).count().finish();){
            for (Row row : dataSet) {
                String status = row.getString("billstatus");
                Integer count = row.getInteger("count");
                if ("B".equals(status)) {
                    result.put(ALL_CNT[0], count);
                    continue;
                }
                result.put(ALL_CNT[1], count);
            }
        }
        return result;
    }

    public static int findFaAssetApplyByApplyerIdAndBillStatus(Object ApplyerPkid, BillStatus billStatus, BillStatus b) {
        int cnt = 0;
        String sql = "select sum(A.fnumber) fnumber from t_fa_apply_asseet_detail A left join t_fa_asset_apply B on A.fid = B.fid where B.fapplyusername = '" + ApplyerPkid + "' and B.fbillstatus in ('" + billStatus.toString() + "','" + b.toString() + "')";
        DataSet ds = DB.queryDataSet((String)"kd.fi.fa.utils.FapUtils.findFaAssetTransferByApplyerIdAndBizStatus", (DBRoute)DBRoute.of((String)"fa"), (String)sql);
        while (ds.hasNext()) {
            Row row = ds.next();
            cnt = row.getBigDecimal("fnumber") == null ? 0 : row.getBigDecimal("fnumber").intValue();
        }
        return cnt;
    }

    public static int findFaAssetTransferByApplyerIdAndBizStatus(Object ApplyerPkid, FaAssetTranfer.BizStatusEnum bizStatus, FaAssetTranfer.BizStatusEnum temporary) {
        int cnt = 0;
        String sql = "select sum(A.famount) famount from t_fa_assettransfer_entry A left join t_fa_assettransfer B on A.fid = B.fid where B.fsenderid = '" + ApplyerPkid + "' and B.fbizstatus in ('" + bizStatus.getValue() + "','" + temporary.getValue() + "')";
        DataSet ds = DB.queryDataSet((String)"kd.fi.fa.utils.FapUtils.findFaAssetTransferByApplyerIdAndBizStatus", (DBRoute)DBRoute.of((String)"fa"), (String)sql);
        while (ds.hasNext()) {
            Row row = ds.next();
            cnt = row.getBigDecimal("famount") == null ? 0 : row.getBigDecimal("famount").intValue();
        }
        return cnt;
    }

    public static int findFaAssetDrawbackByApplyerIdAndBizStatus(Object ApplyerPkid, FaAssetDrawback.BizStatusEnum bizStatus, FaAssetDrawback.BizStatusEnum temporary) {
        int cnt = 0;
        String sql = "select sum(A.famount) famount from t_fa_assetdrawback_entry A left join t_fa_assetdrawback B on A.fid = B.fid where B.fapplierid = '" + ApplyerPkid + "' and B.fbizstatus in ('" + bizStatus.getValue() + "','" + temporary.getValue() + "')";
        DataSet ds = DB.queryDataSet((String)"kd.fi.fa.utils.FapUtils.findFaAssetDrawbackByApplyerIdAndBizStatus", (DBRoute)DBRoute.of((String)"fa"), (String)sql);
        while (ds.hasNext()) {
            Row row = ds.next();
            cnt = row.getBigDecimal("famount") == null ? 0 : row.getBigDecimal("famount").intValue();
        }
        return cnt;
    }

    public static int countFaAssetRepairingByApplyerIdAndBizStatus(Object applyerId) {
        int cnt = 0;
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"B");
        qFilter.and("applier", "=", applyerId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"fa_apply_repair", (String)"id", (QFilter[])qFilter.toArray());
        cnt = result == null ? 0 : result.size();
        return cnt;
    }

    public static Long getAssetOrg(DynamicObject user) {
        DynamicObject dep = FaUserUtils.getAdminOrgByUser((DynamicObject)user);
        if (dep == null) {
            log.info((Object)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u90e8\u95e8");
            return null;
        }
        LinkedList<Long> Orgs = new LinkedList<Long>();
        Orgs.add(dep.getLong("id"));
        log.info((Object)("\u83b7\u53d6\u5230\u7684\u90e8\u95e8\uff1a" + dep.getLong("id")));
        List allOrgs = OrgUnitServiceHelper.getAdminOrgRelation(Orgs, (boolean)false);
        if (allOrgs != null && allOrgs.size() > 0) {
            log.info((Object)("\u59d4\u6258\u7684\u7ec4\u7ec7\uff1a" + allOrgs.get(0)));
        }
        List assetOrgs = OrgUnitServiceHelper.filterOrgDuty((List)allOrgs, (String)"09");
        Long assetOrgId = 0L;
        if (assetOrgs.size() > 0) {
            assetOrgId = (Long)assetOrgs.get(0);
            log.info((Object)(assetOrgId + "\u6709\u8d44\u4ea7\u7ec4\u7ec7\u804c\u80fd"));
        } else {
            log.info((Object)"\u6ca1\u6709\u59d4\u6258\u4e1a\u52a1\u5355\u5143");
            assetOrgs = OrgUnitServiceHelper.filterOrgDuty(Orgs, (String)"09");
            if (assetOrgs.size() > 0) {
                assetOrgId = (Long)assetOrgs.get(0);
                log.info((Object)("\u5f53\u524d\u90e8\u95e8" + assetOrgId + "\u6709\u8d44\u4ea7\u804c\u80fd"));
            } else {
                log.info((Object)"\u5f53\u524d\u90e8\u95e8\u6ca1\u6709\u8d44\u4ea7\u804c\u80fd");
                dep = FaUserUtils.getAssetOrgByUser((DynamicObject)user);
                if (dep != null) {
                    assetOrgId = (Long)dep.getPkValue();
                    log.info((Object)("\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\uff1a" + assetOrgId));
                }
            }
        }
        return assetOrgId;
    }

    public static DynamicObject checkStoreKeeper(IFormView view, Long orgId) {
        DynamicObject assertStoreKeeper = FaAssertOrgUtil.getStoreKeeper((Long)orgId);
        if (assertStoreKeeper == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5e93\u7ba1\u5458\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"FapUtils_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return null;
        }
        return assertStoreKeeper;
    }

    public static QFilter FindInventoryRecordByUserId(Long userId) {
        QFilter qFilter = new QFilter("realcard.headuseperson", "=", (Object)userId);
        QFilter qFilterEable = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        QFilter qStatus = new QFilter("status", "=", (Object)"C");
        SqlBuilder selectCheckerSqlSb = new SqlBuilder();
        selectCheckerSqlSb.append("select fdetailid from t_fa_invent_taskrule_chk where ", new Object[0]);
        selectCheckerSqlSb.append("fbasedataid= ? ", new Object[]{userId});
        DataSet InventorycheckerDs = DB.queryDataSet((String)"kd.fi.fa.utils.FapUtils.FindInventoryRecordByUserId", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)selectCheckerSqlSb);
        HashSet<Long> InventorycheckerSet = new HashSet<Long>(1);
        for (Row row : InventorycheckerDs) {
            Long fdetailid = row.getLong("fdetailid");
            InventorycheckerSet.add(fdetailid);
        }
        QFilter qInventoryTaskId = new QFilter("id", "in", InventorycheckerSet);
        qStatus.and(new QFilter("inventschemeid.billstate", "!=", (Object)"C")).and(qInventoryTaskId);
        DataSet inventoryTaskDs = QueryServiceHelper.queryDataSet((String)"kd.fi.fa.utils.FapUtils.FindInventoryRecordByUserId", (String)"fa_inventory_task", (String)"id,inventschemeid,inventorychecker", (QFilter[])new QFilter[]{qStatus}, null);
        HashSet<Long> taskSet = new HashSet<Long>(16);
        for (Row row : inventoryTaskDs) {
            if (null == row.getLong("id")) continue;
            taskSet.add(row.getLong("id"));
        }
        QFilter qTask = new QFilter("inventorytask.id", "in", taskSet);
        QFilter qConsignee = new QFilter("inventoryentrust.consignee", "=", (Object)userId);
        QFilter qInventschemeentry = new QFilter("inventoryentrust.inventschemeentry.billstate", "!=", (Object)"C");
        QFilter qConsign = qInventschemeentry.and(qConsignee);
        qFilter.and(qFilterEable).or(qTask).or(qConsign);
        return qFilter;
    }

    public static int getInventoryCount(Long userId) {
        String sql = "select record.fid id from t_fa_inventory_record record left join t_fa_card_real realcard on record.frealcardid = realcard.fid left join t_fa_invent_taskrule task on task.fdetailid = record.finventorytaskid left join t_fa_inventscheme scheme on scheme.fid = task.finventschemeid where scheme.fbillstate !='C' and task.fentrystatus = 'C' and realcard.fheadusepersonid = " + userId;
        DataSet checker = DB.queryDataSet((String)"fi-fa-formplugin", (DBRoute)DBRoute.of((String)"fa"), (String)sql);
        sql = "select record.fid id from t_fa_invent_taskrule_chk chk left join t_fa_invent_taskrule task on chk.fdetailid = task.fdetailid left join t_fa_inventory_record record on task.fdetailid = record.finventorytaskid left join t_fa_inventscheme scheme on scheme.fid = task.finventschemeid where scheme.fbillstate !='C' and task.fentrystatus = 'C' and chk.fbasedataid = " + userId;
        DataSet usePerson = DB.queryDataSet((String)"fi-fa-formplugin", (DBRoute)DBRoute.of((String)"fa"), (String)sql);
        sql = "select entrust.finventoryrecordid id from t_fa_inventory_entrust entrust left join t_fa_inventscheme scheme on entrust.finventschemeentryid = scheme.fid where entrust.fconsigneeid = " + userId + " and scheme.fbillstate !='C'";
        DataSet consignee = DB.queryDataSet((String)"fi-fa-formplugin", (DBRoute)DBRoute.of((String)"fa"), (String)sql);
        HashSet<Long> ids = new HashSet<Long>(100);
        while (checker.hasNext()) {
            ids.add(checker.next().getLong("id"));
        }
        while (usePerson.hasNext()) {
            ids.add(usePerson.next().getLong("id"));
        }
        while (consignee.hasNext()) {
            ids.add(consignee.next().getLong("id"));
        }
        return ids.size();
    }
}

